<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

/**
 * Class AssetsAdmin
 */
class AssetsAdmin extends AdminMnv
{
    protected $template;

    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {

        $this->smarty->assign('activeItem','templates');
        $this->smarty->assign('title', lang('templates:title'));

        $this->action   = getRequestVar('action','');
        $this->template = getRequestVar('template', '', true);
        $this->template['content'] = lang('templates:dateTemplateNewFile');


        switch ($this->action) {
            case 'save':
                if (!empty($this->template['isNew'])) {
                    if (empty($this->template['fileName'])) $this->errors['fileName'] = true;
                    $this->template['fileName'] = str_replace(' ', '_', $this->template['fileName']);
                    if (preg_match('/[^0-9a-zA-Z\-_\. ]/i', $this->template['fileName'])) $this->errors['fileNameCharacters'] = true;
                    $templates = searchDir(THEME_ROOT, '*.tpl');
                    if (in_array($this->template['fileName'].'.tpl', $templates)) $this->errors['fileNameExists'] = true;
                }
                if (empty($this->errors)) {
                    if (!empty($this->template['isNew'])) $this->template['fileName'] = $this->template['fileName'].'.tpl';
                    if ($this->templates->save($this->template)) {
                        $this->messages['saved_new_file'] = true;
                        $this->logger->info("Создан новый шаблон «" . $this->template['fileName'] . "».", $this->managers->manager);
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                } else {
                        $this->smarty->assign('template', $this->template);
                }
                break;
        }

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);



        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('assets', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('assets.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }
}








	
	
	
	
	