<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

use Mnv\Models\Content;
use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\EmptyArticleIdException;
use Mnv\Models\Contents\Exceptions\ContentNotDeletedException;
use Mnv\Models\Contents\Exceptions\NotContentApproveException;


/**
 * Class BanksAdmin
 */
class BanksAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $contents = new Content();

        $sectionIds = [];
        /** title */
        $this->smarty->assign('title', 'Банки');
        /** activeItem */
        $this->smarty->assign('activeItem', 'banks');

        /** получение ID статьи для удаления / изменение статуса / удаление и обновление основной картинки статьи */
        $contents->articleId     = (int) getRequestVar('id', '');
        $contentIds    = getRequestVar('articleIds', '', true);
        /** фильтрация статей */
        $section       = (int) getRequestVar('section', '');
        $query         = getRequestVar('query', '');
        $status        = getRequestVar('status', '');

        /** действия */
        if ($this->action == 'remove') {
            try {
                $contents->remove($this->managers->manager);
                response()->make("deleteSuccess('" . $contents->articleId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (ContentNotDeletedException $e) { /** ошибка при удаление контента */
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }

        } else if ($this->action == 'approve') {

            try {
                $contents->approve($this->managers->manager);
                echo "approveSuccess('" . $contents->articleId . "');";

            } catch (NotContentApproveException $e) { /** ошибка при одобрение контента */
                response()->make("approveError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;

        } else if ($this->action == 'reorder') {
            $ids = array_values($contentIds);
            sort($contentIds);
            $contentIds = array_reverse($contentIds);
            $contents->reorder($ids, $contentIds);

        } else if ($this->action == 'status') {

            try {
                $contents->status();
                response()->json($contents->result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (NotContentApproveException $e) { /** ошибка при изменение статуса контента */
                response()->make("statusError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;
        } else {

            if (!empty($section) && !empty($SECTIONS[$section])) {
                $sectionIds = array($section);
                if (!empty($SECTIONS[$section]->allChildren)) {
                    $sectionIds = array_merge($sectionIds, $SECTIONS[$section]->allChildren);
                }
            }

            /** получение разделов по типу контента */
            $sections = Helpers::init()->getSectionContent(null, 'banks');

            /** получение всех статей */
            $contents->listContent($query, $status, 'banks', $sectionIds, 'orderBy DESC', $this->managers->manager);
            if (!is_null($contents->contents)) {
                foreach ($contents->contents as $articleId => $content) {
                    $contents->contents[$articleId]->statusName     = lang('general:statuses:' . $content->status);
                    $contents->contents[$articleId]->publishedOn    = langDate(adjustTime($content->publishedOn, false, 'd.m.Y'));
                    $content->contents[$articleId]->image           = $contents->getFile($content->articleId);
                    $contents->contents[$articleId]->section        = array();
                    if (isset($SECTIONS[$content->sectionId])) $contents->contents[$articleId]->section = $SECTIONS[$content->sectionId];
                }
            }

            /** Получение кол-во статей */
            $contents->total($query, $status, 'banks', $sectionIds, $this->managers->manager);

            /** pagination */
            $pages = getPageNums($contents->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $contents->total);
            $this->smarty->assign('articles', $contents->contents);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('page', $this->page);
        }

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('banks', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('banks.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

}