<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\BannerGroups;
use Mnv\Core\Managers\Role;

/**
 * Class BannerGroupsAdmin
 */
class BannerGroupsAdmin extends AdminMnv
{

	public function fetch()
    {
        $groupBanners = new BannerGroups();

        $this->smarty->assign('activeItem','bannergroups');
        $this->smarty->assign('title', 'Группы баннеров');

        $groupBanners->groupId  = getRequestVar('id', '');
        $groupIds = getRequestVar('group', '', true);

        if ($this->action == 'remove') {

            if ($groupBanners->remove()) {
                response()->make("deleteSuccess('". $groupBanners->groupId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;

        } else if ($this->action == 'status') {

            $result = $groupBanners->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        } else if ($this->action == 'reorder') {

            $groupBanners->reorder($groupIds);

        }
        $groupBanners->get();

        $groupBanners->total();
//print_r($groupBanners->groups);
        $pages = getPageNums($groupBanners->total, 1, 50, 0, 4, 4, 0);

        $this->smarty->assign('totalSliders', $groupBanners->total);
        $this->smarty->assign('groups', $groupBanners->groups);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('bannergroups', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('banner-groups.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

}