<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\BannerGroups;
use Mnv\Models\BannerImages;
use Mnv\Models\Sliders;
use Mnv\Core\Managers\Role;

/**
 * Class BannerImageAdmin
 */
class BannerImageAdmin extends AdminMnv
{

	public function fetch()
    {
        $banners = new BannerImages();
        $groups = new BannerGroups();

        $this->smarty->assign('activeItem','bannerimages');
        $this->smarty->assign('title', 'Слайд');

        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        $this->smarty->assign('groups', $groups->getGroups());


        $banners->banner   = (object) getRequestVar('banner', '',  true);
        $banners->bannerId = (int) getRequestVar('id', '');
        $image    = getRequestVar('image', '',  true);

        if ($this->action == 'add' || $this->action == 'edit') {
            $banners->edit();

        } else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($banners->banner->title)) $this->errors['title'] = true;
            if (empty($banners->banner->groupId)) $this->errors['group'] = true;
            if (!empty($image)) $banners->banner->fileId = $image['fileId'];

            if (empty($this->errors)) {
                if (empty($banners->bannerId)) {
                    if ($banners->add($banners->banner)) {
                        $this->messages['saved'] = true;
                        $this->logger->info("Добавлен новый слайд «" . $banners->banner->title . "»", $this->managers->manager);
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                    if (empty($this->errors) && $this->action == 'apply') redirect("index.php?mod=bannerimage&action=edit&id=".$banners->bannerId);
                } else {
                    $banners->update($banners->banner);
                    $this->messages['saved'] = true;
//                    if ($banners->update($banners->banner)) {
//                        $this->messages['saved'] = true;
//                        $this->logger->info("Слайд «" . $banners->banner->title . "» отредактирован", $this->managers->manager);
//                    } else {
//                        $this->errors['not_saved'] = true;
//                    }
                }

                $banners->edit();

                if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=bannerimages");

            } else {
                $this->smarty->assign('action', 'edit');
            }
        } else if ($this->action == 'deleteImage') {
            if ($banners->deleteImage($banners->bannerId)) {
                response()->make("deleteImageSuccess();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteImageError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        }

        if (!($banners->banner instanceof \stdClass)) $banners->banner = (object)$banners->banner;

        $this->smarty->assign('banner',  $banners->banner);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);



        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('bannerimages', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('banner-image.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }


}