<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

use Mnv\Models\Blocks\Blocks;

/**
 * Class ArticlesAdmin
 */
class BlocksAdmin extends AdminMnv
{

    /**
     * Вывод всех статей
     */
    public function fetch()
    {
        global $SECTIONS;

        $blocks = new Blocks();

        /** title */
        $this->smarty->assign('title', ' Информационные блоки');
        /** activeItem */
        $this->smarty->assign('activeItem', 'blocks');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));

        $blocks->blockId = (int) getRequestVar('id', '');

        /** фильтрация статей */
        $query         = getRequestVar('query', '');
        $status        = getRequestVar('status', '');


        $sections = Helpers::init()->getSectionContentNotTypeContent(0);
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);

        /** действия */
        if ($this->action == 'remove') {
            if ($blocks->remove()) {
                response()->make("deleteSuccess('" . $blocks->blockId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        }
        /** статус */
        else if ($this->action == 'status') {

            if ($blocks->status()) {
                response()->json($blocks->result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else { /** ошибка при изменение статуса контента */
                response()->make("statusError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();

        }  else {

            /** получение разделов по типу контента */
            $sections = Helpers::init()->getSectionContentNotTypeContent(0);
            $blocks->getAll($query, $status);
            if (!is_null($blocks->blocks)) {
                foreach ($blocks->blocks as $blockId => $block) {
                    $blocks->blocks[$blockId]->statusName = lang('general:statuses:' . $block->status);
                    if (isset($SECTIONS[$block->sectionId])) $blocks->blocks[$blockId]->section = $SECTIONS[$block->sectionId];
                }
            }

            /** Получение кол-во статей */
            $blocks->total($query, $status);

            /** pagination */
            $pages = getPageNums($blocks->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $blocks->total);
            $this->smarty->assign('blocks', $blocks->blocks);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('page', $this->page);

        }

        if (!($blocks->blocks instanceof stdClass)) $blocks->blocks = (object)$blocks->blocks;

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);



        /** Права доступа к данному шаблону */
        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('blocks', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('blocks.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }


}