<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\AdminMnv;
use Mnv\Models\Brands;
use Mnv\Core\Managers\Role;

/**
 * Class ArticlesAdmin
 */
class BrandAdmin extends AdminMnv
{

    protected $imageId;

    public function fetch()
    {
        $brands = new Brands();
        $this->smarty->assign('title', lang('brands:title'));
        $this->smarty->assign('activeItem', 'brands');
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        /** получение параметров */
        $brands->brandId   = (int) getRequestVar('id', '');
        $brands->brand     = (object)getRequestVar('brand', '', true);
        $image             = getRequestVar('image', '',  true);

        if ( $this->action == 'add' || $this->action == 'edit' ) {
            $brands->editBrand();
        } else  if ( $this->action == 'save'|| $this->action == 'apply') {

            /** проверка полей */
            if (empty($brands->brand->name)) $this->errors['name'] = true;
            /** проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if ($fileName = $brands->isFileName($brands->brand->fileName)) {
                if ($fileName == $brands->brand->fileName) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $brands->brand->fileName = $fileName;
                }
            }

            if (!empty($image)) $brands->brand->fileId = $image['fileId'];
            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                /** построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
                $brands->brand->url = SITE_URL.'/brands/'.$brands->brand->fileName;

                /** если пустой ID то создаем / если существует ID то редактируем */
                if (empty($brands->brandId)) {
                    if ($brands->brandId = $brands->add($brands->brand, $this->managers->manager)) {
                        $this->messages['saved'] = true;
                        $this->logger->info("Добавлен новый бренд «" . $brands->brand->name . "»", $this->managers->manager);
                        if (empty($this->errors) && $this->action == 'apply') redirect("index.php?mod=brand&action=edit&id={$brands->brandId}");
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                } else {
                    $brands->update($brands->brand, $this->managers->manager);
                    $this->messages['saved'] = true;
                    $this->logger->info("Бренд «" . $brands->brand->name . "» отредактирован", $this->managers->manager);
//                    if ($brands->updateBrand($brands->brand, $this->managers->manager)) {
//                        $this->messages['saved'] = true;
//                        $this->logger->info("Бренд «" . $brands->brand->name . "» отредактирован", $this->managers->manager);
//                    } else {
//                        $this->errors['not_saved'] = true;
//                        $brands->editBrand();
//                    }
                }
            } else {
                $this->smarty->assign('action', 'edit');
                $brands->editBrand();
            }

            if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=brands&page={$this->page}");

        } else  if ( $this->action == 'deleteImage') {

            if ($brands->deleteImage($brands->brandId)) {
                response()->make("deleteImageSuccess();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        }

        if (!($brands->brand instanceof stdClass)) $brands->brand = (object)$brands->brand;


        $this->smarty->assign('brand', $brands->brand);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('brands', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('brand.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }

}
