<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\Coupons;
use Mnv\Core\Managers\Role;
use Mnv\Models\Currencies;

/**
 * Class CouponsAdmin
 */
class CouponsAdmin extends AdminMnv
{

    /**
     * Получение всех слайдов
     * @return string
     * @throws \SmartyException
     */
	public function fetch()
    {
        $coupons = new Coupons();
        $currency = new Currencies();

        $this->smarty->assign('activeItem','coupons');
        $this->smarty->assign('title', 'Купоны');
        $this->smarty->assign('defaultCurrency', $currency->getDefaultCurrency()->codeName);

        $coupons->couponId  = getRequestVar('id', '');
        $coupons->coupon  = (object)getRequestVar('coupon', '', true);

//        print_r($coupons->coupon);

        if ($this->action == 'apply') {
            if (empty($coupons->coupon->code)) $this->errors['code'] = true;
            if (empty($coupons->coupon->value)) $this->errors['value'] = true;
            if (empty($coupons->coupon->min_order_price)) unset($coupons->coupon->min_order_price);
            if (empty($coupons->coupon->expire)) unset($coupons->coupon->expire);

            $result = array('status' => 400, 'message' => $this->errors);
            if (empty($this->errors)) {
                if ($coupons->add($coupons->coupon)) {
                    $this->messages['saved'] = true;
                    $result = array('status' => 200, 'message' => $this->messages);
                } else {
                    $this->errors['not_saved'] = true;
                    $result = array('status' => 400, 'message' => $this->errors);
                }
            }

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        } else if ($this->action == 'remove') {

            if ($coupons->remove()) {
                response()->make("deleteSuccess('". $coupons->couponId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();

        } else if ($this->action == 'status') {

            $result = $coupons->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }


        $coupons->getAll();

        $coupons->total();

        $pages = getPageNums($coupons->total, 1, 50, 0, 4, 4, 0);

        $this->smarty->assign('totalSliders', $coupons->total);
        $this->smarty->assign('coupons',  $coupons->coupons);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('coupons', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('coupons.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

}