<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\Currencies;
use Mnv\Core\Managers\Role;

/**
 * Class CurrencyAdmin
 */
class CurrenciesAdmin extends AdminMnv
{

    public function fetch()
    {
        $currencies = new Currencies();

        $this->smarty->assign('activeItem','currencies');
        $this->smarty->assign('title', lang('currency:title'));

        $currencyIds            = getRequestVar('currency', '', true);
        $currencies->currencyId = (int) getRequestVar('id');



        if ($this->action == 'remove') {
            if ($currencies->remove()) {
                if (!saveSerializations()) $this->errors['serializations'] = true;

                response()->make("deleteSuccess('". $currencies->currencyId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
                exit;
            }
        } else if ($this->action == 'reorder') {
            $currencies->reorder($currencyIds);

//            if (!saveSerializations()) $this->errors['serializations'] = true;
        }



        $currencies->getAll();
        $this->smarty->assign('currencyList', $currencies->currencies);

        if (!empty($errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('currencies', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('currencies.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }
}


    



