<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

/**
 * Class SysErrorsAdmin
 */
class ErrorsSysAdmin extends AdminMnv
{
    /**
     * SysErrorsAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();

        $this->smarty->assign('activeItem', 'syserrors');
        $this->smarty->assign('title','Критические ошибки');

        $this->action = getRequestVar('action', '');

        $this->action();

    }

    public function action()
    {
        switch ($this->action) {
            case 'clear':
                $this->clearLogErrors(SYSERRLOG);
                break;
        }
    }

    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $data = file_read(SYSERRLOG);

        $error = [];
        $errors = explode("\n", $data);

        foreach($errors as $e) {
            if(trim($e) != "") {
                $error[] = $e;
            }
        }

        $error = array_reverse($error);

//        print_r($error);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER]) && (in_array('syserrors', $this->managers->manager->permissions))) {
            $this->smarty->assign('error', $error);
            return $this->smarty->fetch('syserrors.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }


    public function clearLogErrors($logfile)
    {
        $this->write_file($logfile, "");
        $this->logger->info("Лог ".basename($logfile)." очищен", $this->managers->manager);
        redirect('index.php?mod=syserrors');
    }


    public function write_file($file, $context) {
        $f = fopen($file, "w+");
        if(is_writable($file) && is_resource($f)) {
            fwrite($f, $context);
        }
        fclose($f);
    }

}