<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\FAQ;
use Mnv\Core\Managers\Role;

/**
 * Class FAQsAdmin
 */
class FAQsAdmin extends AdminMnv
{

    /**
     * Получение всех слайдов
     * @return string
     * @throws \SmartyException
     */
	public function fetch()
    {
        $faqs = new FAQ();

        $this->smarty->assign('activeItem','faqs');
        $this->smarty->assign('title', 'FAQ');

        $faqs->faqId  = (int) getRequestVar('id', '');
        $faqIds       = getRequestVar('faq', '', true);

        if ($this->action == 'remove') {
            if ($faqs->remove()) {
                response()->make("deleteSuccess('". $faqs->faqId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;
        } else if ($this->action == 'status') {
            $result = $faqs->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        } else if ($this->action == 'reorder') {
            $faqs->reorder($faqIds);
        }


        $faqs->getAll();

        $faqs->total();

        $pages = getPageNums($faqs->total, 1, 50, 0, 4, 4, 0);

        $this->smarty->assign('totalSliders', $faqs->total);
        $this->smarty->assign('faqs',  $faqs->faqs);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('faqs', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('faqs.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

}