<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Models\Features;
use Mnv\Core\Managers\Role;


class FeatureAdmin extends AdminMnv
{

    private $typeContent;

    public function fetch()
    {

        $feature = new Features();

        $this->smarty->assign('activeItem','features');
        $this->smarty->assign('title', 'Свойства товара');
        $this->typeContent   = 'products';

        /** действие */
        $this->action        = getRequestVar('action', '');


        /** постраничная навигация / по умолчанию страница 1 */
        $this->page          = (int) getRequestVar('page', '1');
        /* получение параметров статьи*/
        /** получение ID статьи для удаления / изменение статуса / удаление и обновление основной картинки статьи */
        $feature->featureId     = (int) getRequestVar('id', '');
        $feature->feature       =  getRequestVar('feature', '', true);
//        $feature->sectionIds    =  getRequestVar('sectionIds', '', true);

        /* фильтрация статей */
        $this->query         = getRequestVar('query', '');
        $this->section       = (int) getRequestVar('section', '', '', $checkCookie = true);
        $this->status        = getRequestVar('status', '');
        $this->limit         = (int) getRequestVar('limit');

        /* statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        $sections = Helpers::init()->getSectionContent('', $this->typeContent);
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);


        if ($this->action == 'add' || $this->action == 'edit') {
           $feature->edit($feature->featureId);

        } else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($feature->feature['name'])) $this->errors['name'] = true;
            /** проверка доступных разделов для статей */
            if (empty($feature->feature['sectionIds'])) {
                $this->errors['sectionId'] = true;
            } else {
                $feature->feature['sectionIds'] = json_encode($feature->feature['sectionIds'], JSON_UNESCAPED_UNICODE);
            }

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {

                /** если пустой ID то создаем новую / если существует ID то редактируем */
                if (empty($feature->featureId)) {
                    if ($feature->add($feature->feature)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }

                    if (empty($this->errors) && $this->action == 'apply') redirect("index.php?mod=feature&action=edit&id={$feature->featureId}&page={$this->page}");

                } else {
                    if ($feature->update($feature->feature['id'], $feature->feature)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                }
            } else {
                /** если есть какие-либо ошибки в полях */
                $feature->edit($feature->featureId);
            }

            if (empty($this->errors) && $this->action == 'save')  redirect("index.php?mod=features&page={$this->page}");
        }

        if (!($feature->feature instanceof stdClass)) {
            $feature->feature = (object)$feature->feature;
        }
        $this->smarty->assign('feature', $feature->feature);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('features', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('feature.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }
}