<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;
use Mnv\Models\Users\UserFactory;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;
use Mnv\Models\Users\Exceptions\UserNotDeletedException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedDeveloperException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedAdministratorException;

/**
 * Class ManagersAdmin
 */
class ManagersAdmin extends AdminMnv
{

    public function fetch()
    {
        $adminUser = UserFactory::adminUser();

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem', 'managers');
        $this->smarty->assign('title', lang('managers:title'));

        $adminUser->accessLevels = lang('managers:accessLevels');
        if ($this->managers->manager->accessLevel != 4) {
            $adminUser->accessLevels = array_slice($adminUser->accessLevels, 5);
        }
        $this->smarty->assign('accessLevels', $adminUser->accessLevels);


        /** Получаемые параметры $_GET / $_POST */
        $adminUser->user    = (object) getRequestVar('manager','');
        $adminUser->userId  = (int) getRequestVar('id','');

        /* table list */
        $start             = getRequestVar('start', 0);
        $length           = getRequestVar('length', 10);

        $draw               = getRequestVar('draw', 1);
        $search	            = getRequestVar('search', '');     // $_POST['search']['value'];
        $columnName         = getRequestVar('columns');                 // $_POST['columns'][$columnIndex]['data'];
        $columnSortOrder    = getRequestVar('order');                   // $_POST['order'][0]['dir'];
        /* end table list */

        if ($this->action == 'remove') {
            try {
                $adminUser->remove();
                response()->make("deleteSuccess('" . $adminUser->userId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (CannotBeRemovedDeveloperException $e) {
                response()->make("notDeleteDeveloper();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (CannotBeRemovedAdministratorException $e) {
                response()->make("notDeleteAdministrator();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyUserIdException | NoUserException $e) {
                response()->make("userNotFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (UserNotDeletedException $e) {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();
        } else if ($this->action == 'table') {


            /** получение всех менеджеров */
            $adminUser->getAll($search['value'], null, $start, $length, $columnSortOrder, $columnName, $this->managers->manager);

            /** получение кол-во менеджеров */
            $adminUser->total($search['value'], null, $this->managers->manager);

            /** получение кол-во менеджеров при фильтрации */
            $adminUser->countTableFiltered($search['value'], $this->managers->manager);

            $response = array(
                "draw"              => intval($draw),
                "recordsTotal"      => intval($adminUser->total),
                "recordsFiltered"   => intval($adminUser->totalFiltered),
                "data"              => $adminUser->users
            );

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }

        /** Права доступа к данному шаблону */
        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('managers', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('managers.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

}









