<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Models\Maps;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

/**
 * Class MapsAdmin
 */
class MapsAdmin extends AdminMnv
{

    public function fetch()
    {
        $maps = new Maps();

        $this->smarty->assign('activeItem','maps');
        $this->smarty->assign('title', lang('settings:title'));
        $this->smarty->assign('works', lang('general:works'));

        $maps->map = (object) getRequestVar('map', '', true);

        if ($this->action == 'save') {
            if ($maps->save($maps->map)) $this->messages['saved'] = true;
        }

        $maps->getMaps();

        if (!($maps->map instanceof \stdClass)) $maps->map = (object)$maps->map;

        $this->smarty->assign('map', $maps->map);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('maps', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('maps.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }
}


