<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Models\Content;
use Mnv\Core\Managers\Role;
use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\NotUpdateContentException;
use Mnv\Models\Contents\Exceptions\NotInsertContentException;


/**
 * Class NewAdmin
 */
class NewAdmin extends AdminMnv
{

    /**
     * Вывод всего контента
     */
    public function fetch()
    {
        global $SECTIONS;

        $content = new Content();

        $this->smarty->assign('activeItem', 'news');
        $this->smarty->assign('title', 'Новости и Статьи');
        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        /** получение ID статьи для удаления / изменение статуса / удаление и обновление основной картинки статьи */
        $date                   = getRequestVar('date', '', true);
        $content->articleId     = (int) getRequestVar('id', '');
        $content->content       = (object)getRequestVar('article', '', true);

        /** фильтрация статей */
        $query         = getRequestVar('query', '');
        $section       = (int) getRequestVar('section', '', '', true);
        $status        = getRequestVar('status', '');

        /** работа с галереей */
        $image      = getRequestVar('image', '', true);
        $gallery    = getRequestVar('gallery', '', true);
        $imageIds   = getRequestVar('imageIds', '', true);
        $imageId    = (int) getRequestVar('imageId', '');
        $picture    = getRequestVar('picture', '', true);


        $sections = Helpers::init()->getSectionContent( null, 'news', 3);
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);


        if ($this->action == 'add' || $this->action == 'edit') {
            try {
                $content->edit();
            } catch (NoContentException $e) { /** контент не найден */
                $this->errors['article_not_found'] = true;
            }
        }
        /** сохрание новости */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($content->content->title)) $this->errors['title'] = true;
            $content->content->isFeatured = $content->content->isFeatured ?? 0;
            /** тип контента */
            if (empty($content->content->typeContent)) $content->content->typeContent = 'news';
//            if (empty($content->content->typeNews)) $this->errors['typeNews'] = true;

            /** установка даты */
            $content->content->publishedOn = Helpers::init()->dateFormation($date);

            /** проверка доступных разделов для статей */
            if (empty($content->content->sectionId) || empty($sections[$content->content->sectionId])) $this->errors['sectionId'] = true;

            /** проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if ($fileName = $content->checkFileName($content->content->fileName)) {
                if ($fileName == $content->content->fileName) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $content->content->fileName = $fileName;
                }
            }

            /** основная картинка */
            $images['fileId'] = !empty($image) ? $image['fileId'] : null;

            /** включить / отключить галерею у данного контента */
            $content->content->enableGallery = isset($content->content->enableGallery) ? 1 : 0;
            $images['gallery'] = !empty($gallery) ? $gallery : null;

//            if (!empty($content->content->urlType) && $content->content->urlType == 'external') {
//                if (empty($content->content->externalLink)) $this->errors['externalLink'] = true;
//            } else {
//                $content->content->externalLink = null;
//            }

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                /** построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
                $content->content->url = $SECTIONS[$content->content->sectionId]->path.'/'.$content->content->fileName.'.'.$this->config['file_extension'];

                /** если пустой ID то создаем новую статью / если существует ID то редактируем статью */
                if (empty($content->articleId)) {

                    try {
                        $content->add($content->content, $images, $this->managers->manager);
                        $this->messages['saved'] = true;
                        $this->logger->info("Добавлен контент «" . $content->content->title . "»", $this->managers->manager);

                        if (empty($this->errors) && $this->action == 'apply') {
                            redirect("index.php?mod=new&action=edit&id={$content->articleId}&page={$this->page}&query=$query&section=$section&status=$status");
                        }
                    } catch (NotInsertContentException $e) {
                        $this->errors['not_saved'] = true;
                    }

                } else {
                    try {
                        $content->update($content->content, $images, $this->managers->manager);

                        $this->messages['saved'] = true;
                        $this->logger->info("Контент «" . $content->content->title . "» отредактирован", $this->managers->manager);
                    } catch (NotUpdateContentException $e) {
                        $this->errors['not_saved'] = true;
                        $content->edit();
                    }
                }
            } else {
                /** если есть какие-либо ошибки в полях */
                $this->smarty->assign('action', 'edit');
            }

            if (empty($this->errors) && $this->action == 'save')  redirect("index.php?mod=news&page={$this->page}&query=$query&section=$section&status=$status");

        }
        /** удаление основной картинки */
        else if ($this->action == 'deleteImage') {

            if ($content->deleteImage($content->articleId)) {
                response()->make("deleteImageSuccess();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteImageError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();
        }
        /** редактирование ифонмации у картинки в галереи */
        else if ($this->action == 'editPictureInfo') {

            if ($result = $content->editPictureInfo($imageId, $picture)) {
                $response = array('status' => 200, 'title' => $result->title, 'alias' => $result->alias, 'description' => $result->description, 'link' => $result->link, 'position' => $result->position);
            } else {
                $response = array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');
            }
            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            exit();
        }
        /** сортировка картинок в галереи */
        else if ($this->action == 'sortPictures') {

            $content->sortPictures($imageIds);
        }
        /** удаление картинки в галереи */
        else if ($this->action == 'deletePicture') {

            $result = array('del' => $content->deletePicture($imageId));

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            exit();
        }

        if (!($content->content instanceof \stdClass)) $content->content = (object)$content->content;

//        var_dump($content->content);
//        $this->smarty->assign('typeNews', array('' => 'Выберите тип', 'news' => 'Новости', 'smi' => 'Статьи'));
//        $this->smarty->assign('urlTypes', array('default' => 'Выбрать тип ссылки', 'modal' => 'Модальное окно', 'external' => 'Внешняя ссылка' ));

        $this->smarty->assign('article', $content->content);
        $this->smarty->assign('date', $date);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER]) && (in_array('news', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('new.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }



}