<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\AdminMnv;
use Mnv\Models\Orders;
use Mnv\Core\Managers\Role;

/**
 * Class OrdersAdmin
 */
class OrderAdmin extends AdminMnv
{

    public function fetch()
    {
        $orders = new Orders();

        $this->smarty->assign('activeItem','orders');
        $this->smarty->assign('title', lang('orders:title'));
        $this->smarty->assign('statuses', lang('orders:statuses'));

        $orders->order	 = (object)getRequestVar('order','', true);
        $orders->orderId = (int)getRequestVar('id', '');

        switch ($this->action) {
            case 'edit':
                $orders->edit();
                break;
            case 'read_order':
                $orders->edit();
                $orders->order->status    = lang('orders:statuses:'.$orders->order->status);
                $orders->order->createdBy = langDate(adjustTime($orders->order->createdBy, false, 'd.m.Y H:i'));

                if (!empty($this->order))
                    $this->smarty->assign('order', $orders->order);
                return $this->smarty->display('module/order-list.tpl');
              break;
            case 'save':
                if ($orders->update($orders->order)) {
                    $this->messages['saved'] = true;
                }
                redirect('index.php?mod=orders');
                break;
        }

        if (!($orders->order instanceof stdClass)) $orders->order = (object)$orders->order;

        $this->smarty->assign('order', $orders->order);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::ADMIN, Role::MODERATOR]) && (in_array('orders', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('order.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }
}