<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\Orders;
use Mnv\Core\Managers\Role;

/**
 * Class OrdersAdmin
 */
class OrdersAdmin extends AdminMnv
{

    public function fetch()
    {
        $orders = new Orders();

        $this->smarty->assign('activeItem','orders');
        $this->smarty->assign('title', lang('orders:title'));
        $this->smarty->assign('statuses', lang('orders:statuses'));

        $orders->order	= arrAddSlashes(getRequestVar('order','', true));
        $orders->orderId	= getRequestVar('id', '');

        $draw     = getRequestVar('draw', '1');
        $start    = getRequestVar('start', '0');
        $length   = getRequestVar('length', '10');

        $searchValue = getRequestVar('search'); //$_POST['search']['value'];
        $columnName = getRequestVar('columns'); //$_POST['columns'][$columnIndex]['data'];
        $columnSortOrder = getRequestVar('order');// $_POST['order'][0]['dir'];

        if ($this->action == 'remove') {
            if ($orders->remove()) {
                response()->make("deleteSuccess('" . $orders->orderId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        } else if ($this->action == 'read_table') {

            $ordersArr           = $orders->getTableOrders($start, $length, $searchValue, $columnSortOrder, $columnName);
            $totalOrders         = $orders->countTableOrders();
            $totalFilteredOrders = $orders->countTableFilteredOrders($searchValue);
            $response = array(
                "draw"              => intval($draw),
                "recordsTotal"      => $totalOrders,
                "recordsFiltered"   => $totalFilteredOrders,
                "data"              => $ordersArr
            );

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        }

        $this->smarty->assign('page', $this->page);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::ADMIN, Role::MODERATOR]) && (in_array('orders', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('orders.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }
}
