<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\Payments;
use Mnv\Core\Managers\Role;

class PaymentAdmin extends AdminMnv
{

    public function fetch()
    {
        $payments = new Payments();

        $this->smarty->assign('activeItem','payments');
        $this->smarty->assign('title', lang('payments:title'));
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        $payments->payment      = (object) getRequestVar('payment', '',  true);
        $payments->paymentId    = (int) getRequestVar('id', '');

        if ($this->action == 'edit' || $this->action == 'add') {

         $payments->editPayment();

        } else if ($this->action == 'save' || $this->action == 'apply') {
            /* проверка полей */
            if (empty($payments->payment->name)) $this->errors['name'] = true;
            if (empty($payments->payment->fileName)) $this->errors['name'] = true;

            if ($fileName = $payments->fileNameExist($payments->payment->fileName)) {
                if ($fileName == $payments->payment->fileName) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $payments->payment->fileName = $fileName;
                }
            }

            if (isset($payments->payment->settings) && !empty($payments->payment->settings)) $payments->payment->settings = json_encode($payments->payment->settings);

            if (empty($this->errors)) {
                if (empty($payments->paymentId)) {
                    if ($payments->add($payments->payment, $this->managers->manager)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                    if (empty($this->errors) && $this->action == 'apply') redirect("index.php?mod=payment&action=edit&id={$payments->paymentId}");
                } else {
//                    if (!$payments->oldPayment($payments->paymentId)) $this->errors['payment_not_found'] = true;
                    if (empty($this->errors)) {

                        if ($payments->update($payments->payment, $this->managers->manager)) {
                            $this->messages['saved'] = true;
                        } else {
                            $this->errors['not_saved'] = true;
                        }
                    }
                }
                if (empty($this->errors) && $this->action == 'save') redirect("index.php?mod=payments");

            } else {
                $payments->editPayment();
            }
        }

        if (!($payments->payment instanceof stdClass)) $payments->payment = (object)$payments->payment;

        $payment_modules = $payments->getPaymentModules();
        $this->smarty->assign('payment_modules', $payment_modules);
        $this->smarty->assign('payment', $payments->payment);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::ADMIN]) && (in_array('payments', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('payment.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }



}