<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

/**
 * Class RobotsAdmin
 */
class RobotsAdmin extends AdminMnv
{

    /**
     * RobotsAdmin constructor.
     * @throws \SmartyException
     */
    public function fetch()
    {

        $this->smarty->assign('activeItem','robots');
        $this->smarty->assign('title', 'robots.txt');


        /*Обновление файла*/
        $this->action = getRequestVar('action', '');
        if (!empty($this->action) && $this->action == 'save') {
            $robots_data = getRequestVar('robots');
            $this->get_robots($robots_data, 'write');
        }
        $robots_txt = $this->get_robots('','read');
        $this->smarty->assign('robots_txt', $robots_txt);
        $perms = is_writable(GLOBAL_ROOT.'/robots.txt');
        if (!$perms) $this->smarty->assign('message_error','Файла не существует');

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('robots', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('robots.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

    /*Чтение/Запись файла*/
    private function get_robots($data, $type)
    {
        if ($type == 'write') {
            $perms = is_writable(GLOBAL_ROOT.'/robots.txt');
            if ($perms) {
                file_put_contents(GLOBAL_ROOT.'/robots.txt', strip_tags($data), LOCK_EX);
                $this->smarty->assign('message_success', 'Файл robots.txt обновлен');
            } else {
                $this->smarty->assign('message_error','Файл robots.txt не обновлен');
            }
        } elseif ($type='read') {
            return $robots = file_get_contents(GLOBAL_ROOT."/robots.txt");
        }
        return false;
    }

}
	
	