<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

use Mnv\Models\Sections\Sections;

class SectionAdmin extends AdminMnv
{
    protected $id;
    protected $val;

    public $totalSections = 0;

    /**
     * @throws \SmartyException
     */
    public function fetch()
    {
        global $SECTIONS;

        $sections       = new Sections();

        $this->smarty->assign('title', lang('sections:title'));
        $this->smarty->assign('activeItem', 'sections');

        $sections->section     = (object) getRequestVar('section', '', true);
        $sections->parentId    = (int) getRequestVar('parentId','0');
        $sections->sectionId   = (int) getRequestVar('sectionId','');
        $this->id 	           = (int) getRequestVar('id','');

        /** для работы с галереей */
        $image      = getRequestVar('image', '', true);
        $gallery    = getRequestVar('gallery', '', true);
        $docs       = getRequestVar('docs', '', true);

        $picture   = getRequestVar('picture', '', true);
        $imageId     = (int) getRequestVar('imageId','');
        $imageIds    = getRequestVar('imageIds', '', true);
        /** для работы с меню */
        $this->val         = (int) getRequestVar('val','');

        /** редактирование или добавление */
        if ($this->action == 'edit') {
            $sections->edit($sections->sectionId);
        }
        /** сохранение */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            $sections->section->name = trim($sections->section->name);
            $sections->section->name = ltrim($sections->section->name);
            if (empty($sections->section->name)) $this->errors['name'] = true;

            /** параметры input(checkbox) int 1/0 */
            $sections->section->topMenu       = $sections->section->topMenu ?? 0;
            $sections->section->footerMenu    = $sections->section->footerMenu ?? 0;
            $sections->section->enableGallery = $sections->section->enableGallery ?? 0;
            $sections->section->enableIcon    = $sections->section->enableIcon ?? 0;
            $sections->section->enableVideo   = $sections->section->enableVideo ?? 0;
            $sections->section->enableIndex   = $sections->section->enableIndex ?? 0;

//            $sections->section->sectionIds   = !empty($sections->section->sectionIds) ? json_encode($sections->section->sectionIds) : '';


            /** проверяем существует ли главная страница если да то ошибка / если нет то устанавливаем ей параметры type и parentId */
            if ($sections->section->fileName == 'index') {
                $sections->section->type = 'plain';
                $sections->section->parentId = 0;
                if ($fileName = $sections->isFileNamePage($sections->section->fileName, $sections->sectionId)) {
                    if ($fileName == $sections->section->fileName) {
                        $this->errors['pageFileNameExists'] = true;
                    } else {
                        $sections->section->fileName = $fileName;
                    }
                }
            }

            /** проверка наличия  */
            if (!empty($sections->sectionId)) $oldSection = $SECTIONS[$sections->sectionId] ?? null;

            if (empty($sections->section->fileName)) $this->errors['fileName'] = true;
            if (empty($sections->section->parentId)) $sections->section->parentId = 0;

            /** проверяем существует ли `fileName` если да то ошибка */
            if ($fileName = $sections->isFileNameSection($sections->section->fileName, $sections->sectionId, $sections->section->parentId)) {
                if ($fileName == $sections->section->fileName) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $sections->section->fileName = $fileName;
                }
            }

            if (preg_match('/^(admin|images|files)$/i', $sections->section->fileName)) $this->errors['fileNameProhibited'] = true;
            if (preg_match('/[^0-9a-zA-Z\-_\.,]/i', $sections->section->fileName)) $this->errors['fileNameCharacters'] = true;

            $templates = searchDir(THEME_ROOT, '*.tpl');
            if (!in_array($sections->section->templateName, $templates)) $sections->section->templateName = '';
            if (!in_array($sections->section->subTemplateName, $templates)) $sections->section->subTemplateName = '';
            if (!in_array($sections->section->artTemplateName, $templates)) $sections->section->artTemplateName = '';

            /** проверка тип и тип контента */
//            if (!empty($sections->section->parentId) && $sections->section->parentId > 0) {
//                $parentTypeContent = $sections->parentTypeContent($sections->section->parentId);
//                if ($parentTypeContent->type != $sections->section->type) {
//                    $this->errors['error_parent_type'] = true;
//                } elseif (!empty($sections->section->typeContent)) {
//                    if ($parentTypeContent->typeContent != $sections->section->typeContent) $this->errors['error_parent_typeContent'] = true;
//                }
//            }

            $sections->images['fileId'] = !empty($image) ? $image['fileId'] : '';
            $sections->images['gallery'] = !empty($gallery) ? $gallery : '';

//            if (!empty($sections->section->price)) {
//                $sections->section->price = \trim($sections->section->price);
//                $sections->section->price = str_replace(" ", "", $sections->section->price);
//            } else {
//                $sections->section->price = 0;
//            }
//
//            if (!empty($sections->section->oldPrice)) {
//                $sections->section->oldPrice = \trim($sections->section->oldPrice);
//                $sections->section->oldPrice = str_replace(" ", "", $sections->section->oldPrice);
//            } else {
//                $sections->section->oldPrice = 0;
//            }


            if (isset($docs)) $sections->images['docs'] = !empty($docs) ? $docs : '';

            if (!empty($sections->section->urlType) && $sections->section->urlType == 'external') {
                if (empty($sections->section->externalLink)) $this->errors['externalLink'] = true;
            } else {
                $sections->section->externalLink = null;
            }

//            print_r($sections->section);
            if (empty($this->errors)) {

                if (empty($sections->sectionId)) {
                    if ($sections->add($sections->section, $sections->images, $this->managers->manager)) {

                        if (!saveSerializations()) $this->errors['serializations'] = true;
                        if (!writeHtaccess()) $this->errors['htaccess'] = true;
                        $this->logger->info("Добавлен новый раздел «" . $sections->section->name . "»", $this->managers->manager);
                        $this->messages['saved'] = true;

                        if (empty($this->errors) && $this->action == 'apply') {
                            if (isset($sections->parentId) && !empty($sections->parentId)) {
                                redirect("index.php?mod=section&action=edit&sectionId={$sections->sectionId}&parentId={$sections->parentId}&page={$this->page}");
                            } else {
                                redirect("index.php?mod=section&action=edit&sectionId={$sections->sectionId}&page={$this->page}");
                            }
                        }
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                } else {

                    if ($sections->update($sections->sectionId, $sections->section, $oldSection, $sections->images, $this->managers->manager)) {
                        if (!saveSerializations()) $this->errors['serializations'] = true;
                        if (!writeHtaccess()) $this->errors['htaccess'] = true;

                        if ($sections->section->parentId != $oldSection->parentId) {
                            /** обновить порядок сортировки, если был изменен родитель */
                            $sections->writeSortOrders($sections->section->parentId);
                            $sections->writeSortOrders($oldSection->parentId);
                        }

                        $this->logger->info("Раздел «" . $sections->section->name . "» отредактирован", $this->managers->manager);
                        $this->messages['saved'] = 'saved';
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                }

                $sections->parentId = $sections->section->parentId;
                if (!saveSerializations()) $this->errors['serializations'] = true;
                if (!writeHtaccess()) $this->errors['htaccess'] = true;

                /* если есть какие-либо ошибки в полях */
                $this->smarty->assign('action', 'edit');
            }

            if (empty($this->errors) && $this->action == 'save')  redirect("index.php?mod=sections&parentId={$sections->parentId}&page={$this->page}");

        }
        /** удаление основной картинки */
        else if ($this->action == 'deleteImage') {

            if ($sections->deleteImage($this->id)) {
                response()->make("deleteImageMessage();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteImageError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        }
        /** редактирование картинки в галереи */
        else if ($this->action == 'editPictureInfo') {

            $result = $sections->editPictureInfo($imageId, $picture);
            if (!empty($result)) {
                $response = array('status' => 200, 'title' => $result->title, 'alias' => $result->alias, 'description' => $result->description, 'link' => $result->link, 'position' => $result->position);
            } else {
                $response = array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');
            }

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json; charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }
        /** сортировка галереи */
        else if ($this->action == 'sortPictures') {

            $sections->sortPictures($imageIds);
        }
        /** удаление картинки из галереи */
        else if ($this->action == 'deletePicture') {
            $result = $sections->deletePicture($imageId)
                ? array('status' => 200, 'message' => lang('deletingImage'), 'type', 'success')
                : array('status' => 500, 'message' => lang('deletingImageError'), 'type', 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
         }

        /** удаление файлов docs */
        else if ($this->action == 'deleteDocs') {

            $result = $sections->deleteDocs($imageId)
                ? array('status' => 200, 'message' => lang('deletingDocs'), 'type', 'success')
                : array('status' => 500, 'message' => lang('deletingDocsError'), 'type', 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }



        if (!($sections->section instanceof \stdClass)) $sections->section = (object)$sections->section;

//        print_r($sections->section);

        $this->smarty->assign('section', $sections->section);

        if (!empty($sections->sectionId)) {
            $this->smarty->assign('parents', Helpers::init()->getSectionOptions($sections->sectionId));
        } else {
            $this->smarty->assign('parents', Helpers::init()->getSectionOptions());
        }

        /* template options */
        $templates = searchDir(THEME_ROOT, '*.tpl');
        array_unshift($templates, lang('general:useDefaultTemplate'));
        $this->smarty->assign('templates', $templates);
        /* caching time options */
        for($i = 1; $i <= 60; $i++) $cachingTimeOptions[$i] = $i;
        $this->smarty->assign('cachingTimeOptions', $cachingTimeOptions);
        $this->smarty->assign('cachingPeriodOptions', lang('general:cachingPeriodOptions'));
        $this->smarty->assign('statuses', lang('sections:statuses'));
        $this->smarty->assign('typeContents', lang('sections:typeContents'));
        $this->smarty->assign('types', lang('sections:types'));
        $this->smarty->assign('urlTypes', array('default' => 'Выбрать тип ссылки', 'modal' => 'Модальное окно', 'external' => 'Внешняя ссылка' ));


        if (!empty($this->errors))   $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('sections', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('section.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }






}
	
	

	
