<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\DB;
use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;

use Mnv\Models\Sections\Sections;


class SectionsAdmin extends AdminMnv
{

    private static $_table = 'sections';

    protected $param;

    /** @var int $id */
    protected $id;

    /** @var int $val для работы с меню */
    protected $val;
    /** @var int $totalSections */
    public $totalSections = 0;

    /**
     * Вывод списка разделов
     */
    public function fetch()
    {
        global $SECTIONS;

        $sections =  new Sections();

        $this->smarty->assign('title', lang('sections:title'));
        $this->smarty->assign('activeItem', 'sections');

        $this->param       = getRequestVar('param','');
        $sections->section   = getRequestVar('section', '', true);
        $sections->parentId  = (int) getRequestVar('parentId','0');
        $sections->sectionId   = (int) getRequestVar('sectionId','');

        $sectionIds  = getRequestVar('sectionIds', '', true);
        $this->id 	       = (int) getRequestVar('id','');

        // для работы с меню
        $this->val         = (int) getRequestVar('val','');

        if ($this->action == 'confirmDelete') {

            $sections->confirmDelete($sections->sectionId);

            if ($sections->section->hasSubsections) {
                $subsectionOptions = array('delete' => lang('general:delete'));
                $subsectionOptions[0] = lang('sections:moveToRoot');
                $subsectionOptions += Helpers::init()->getSectionOptions($sections->section->sectionId);
                foreach ($subsectionOptions as $key => $name) if ($key > 0) $subsectionOptions[$key] = lang('sections:moveTo') . ': ' . $name;
                $this->smarty->assign('subsectionOptions', $subsectionOptions);
            }

            if ($sections->section->hasArticles) {
                $articleOptions = array('delete' => lang('general:delete'));
                $articleOptions += Helpers::init()->getSectionOptions($sections->section->sectionId);
                foreach ($articleOptions as $key => $name) if ($key > 0) $articleOptions[$key] = lang('sections:moveTo') . ': ' . $name;
                unset($articleOptions[0]);
                $this->smarty->assign('articleOptions', $articleOptions);
            }

            $this->smarty->assign('section', $sections->section);

        } else if ($this->action == 'deleteConfirmed') {

            if (!empty($sections->section['sectionId'])) {
                if ($sections->sections = $sections->deleteConfirmed($sections->section, $this->param)) $this->messages['deleted'] = true;
                if (!saveSerializations())  $this->errors['serializations'] = true;
                if (!writeHtaccess()) $this->errors['htaccess'] = true;
            } else {
                $this->errors['section_not_found'] = true;
            }
        } else if ($this->action == 'menu') {

            $result = $sections->menuSection($this->id, $this->val);
            if (!saveSerializations()) $this->errors['serializations'] = true;

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();

        } else if ($this->action == 'status') {

            if ($result = $sections->statusSection($this->id)) {
                if (!saveSerializations()) $this->errors['serializations'] = true;
                if (!writeHtaccess()) $this->errors['htaccess'] = true;
                response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        } else if ($this->action == 'reorder') {

            $ids = array_values($sectionIds);
            sort($sectionIds);
            // $sectionIds = array_reverse($sectionIds);
            $sections->reorderSections($ids, $sectionIds);

            if (!saveSerializations()) $this->errors['serializations'] = true;
            if (!writeHtaccess()) $this->errors['htaccess'] = true;

        }


        if (!empty($sections->parentId) && !DB::init()->connect()->table(self::$_table)->count('*', 'count')->where('parentId', $sections->parentId)->getValue()) {
            $sections->parentId = DB::init()->connect()->table(self::$_table)->select('parentId')->where('sectionId', $sections->parentId)->getValue();
            redirect('index.php?mod=sections&parentId=' . $sections->parentId );
            die (lang('sections:noSubsections'));
        }

        /** получать информацию о родительском разделе */
        if ($sections->parentId > 0) {
            $parent = $SECTIONS[$sections->parentId];
            if ($parent->parentId > 0) $parent->parent = $SECTIONS[$parent->parentId];
            $this->smarty->assign('parent', $parent);
        }

        /** получение всех разделов */
        $sections->getSections($sections->parentId);

        /** Получение кол-во разделов */
        $sections->total($sections->parentId);
        /** pagination */
        $pages = getPageNums($sections->total, $this->page, $this->limit, 0, 4, 4, 0);

        /** вывод в шаблон результатов */
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('sections', $sections->sections);
        $this->smarty->assign('parentId', $sections->parentId);
        $this->smarty->assign('page', $this->page);


        if (!empty($this->errors))   $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('sections', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('sections.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

}