<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\Config;
use Mnv\Core\DB;
use Mnv\Core\Helpers;
use Mnv\Core\UserInfo;
use Mnv\Core\AdminMnv;
use Mnv\Models\Settings;
use Mnv\Core\Managers\Role;
use Mnv\Core\Locale\Charset;
use Mnv\Core\Locale\LanguageSelection;

/**
 * Class SettingsAdmin
 */
class SettingsAdmin extends AdminMnv
{

    public function fetch()
    {

        $settings = new Settings();

        $this->smarty->assign('activeItem','settings');
        $this->smarty->assign('title', lang('settings:title'));

        $setting  = getRequestVar('settings', '', true);
        $date    = getRequestVar('date', '');

        if ($this->action == 'save') {

            if (empty($setting['convert_filename_to_lowercase'])) $setting['convert_filename_to_lowercase'] = 0;
            if (empty($setting['statistics_enabled'])) $setting['statistics_enabled'] = 0;

            if (empty($setting['comments_enabled']))                     $setting['comments_enabled'] = 0;
            if (empty($setting['comments_must_be_approved']))            $setting['comments_must_be_approved'] = 0;
            if (empty($setting['comments_whitelist_enabled']))           $setting['comments_whitelist_enabled'] = 0;
            if (empty($setting['comments_blacklist_enabled']))           $setting['comments_blacklist_enabled'] = 0;
            if (empty($setting['comments_editors_may_approve']))         $setting['comments_editors_may_approve'] = 0;
            if (empty($setting['comments_captcha_enabled']))             $setting['comments_captcha_enabled'] = 0;
            if (empty($setting['comments_strip_html']))                  $setting['comments_strip_html'] = 0;
            if (empty($setting['comments_convert_links']))               $setting['comments_convert_links'] = 0;
            if (empty($setting['comments_email_confirmation_required'])) $setting['comments_email_confirmation_required'] = 0;

            if (empty($setting['allow_watermark']))            $setting['allow_watermark'] = 0;
            if (empty($setting['save_original_image']))        $setting['save_original_image'] = 0;
            if (empty($setting['keep_original_image_name']))   $setting['keep_original_image_name'] = 0;
            if (empty($setting['save_thumbnail_image']))       $setting['save_thumbnail_image'] = 0;
            if (empty($setting['force_webp']))                 $setting['force_webp'] = 0;
            if (empty($setting['mail_bcc']))                   $setting['mail_bcc'] = 0;

            if (empty($setting['cache_enabled_index']))        $setting['cache_enabled_index'] = 0;
            if (empty($setting['cache_enabled_article']))      $setting['cache_enabled_article'] = 0;
            if (empty($setting['cache_enabled_section']))      $setting['cache_enabled_section'] = 0;
            if (empty($setting['cache_enabled_rss']))          $setting['cache_enabled_rss'] = 0;
            if (empty($setting['cache_enabled_sitemap']))      $setting['cache_enabled_sitemap'] = 0;

            if (empty($setting['feedback_captcha_enabled']))   $setting['feedback_captcha_enabled'] = 0;
//            if (empty($setting['compress_js_css']))            $setting['compress_js_css'] = 0;
//            if (empty($setting['mod_deflate']))                $setting['mod_deflate'] = 0;
//            if (empty($setting['mod_headers']))                $setting['mod_headers'] = 0;
//            if (empty($setting['mod_expires']))                $setting['mod_expires'] = 0;
            if (empty($setting['website_language']))           $setting['website_language'] = '';
//            if (empty($setting['telegram_send']))              $setting['telegram_send'] = 0;
            if (empty($setting['error_test']))                 $setting['error_test'] = 0;
            if (empty($setting['check_banned_ips']))           $setting['check_banned_ips'] = 0;
            if (empty($setting['twoFactorAuth']))              $setting['twoFactorAuth'] = 0;

            if (empty($setting['timezone']))
                $setting['timezone'] = $setting['timezone'];

            foreach (lang('langtimezones:timezone') as $key => $langtimezone) {
                if ($setting['timezone'] == $key)  {
                    $timezone = explode(":", $langtimezone);
                    $setting['hour_adjustment']   = $timezone[0];
                    $setting['minute_adjustment'] = $timezone[1];
                }
            }
            if (empty($setting['site_url'])) $setting['site_url'] = GLOBAL_URL;


            $settings->save($setting);

            /** получить обновленные настройки */
            $this->smarty->assign('config', $settings->get());

            if (!saveSerializations()) $this->errors['serializations'] = true;
            if (!writeHtaccess()) $this->errors['htaccess'] = true;

            $this->messages['saved'] = true;

        } else if  ($this->action == 'clear_cache') {
            $settings->clearCache();
            exit;
        } else if  ($this->action == 'delete_stats') {
            $settings->deleteStatsPriorTo($date);
            exit;
        } else if ($this->action ==  'test_smtp') {
            $response = $settings->testSMTP($setting['smtp_port'], $setting['smtp_server'], $setting['smtp_user'], $setting['smtp_pass']);

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }


        for($i = 100; $i >= 70; $i = $i - 5) $thumbQualityOptions[$i] = $i;
        $this->smarty->assign('thumbQualityOptions', $thumbQualityOptions);

        for($i = 1; $i <= 10; $i++) $sectionDepthOptions[$i] = $i;
        $this->smarty->assign('sectionDepthOptions', $sectionDepthOptions);

        /* caching time options */
        for($i = 1; $i <= 60; $i++) $cachingTimeOptions[$i] = $i;
        $this->smarty->assign('cachingTimeOptions', $cachingTimeOptions);

        $this->smarty->assign('cachingPeriodOptions', lang('general:cachingPeriodOptions'));

        $this->smarty->assign('adjustedTime', langDate(adjustTime(gmdate('Y-m-d H:i:s'), false, 'F j, Y - H:i')));
        $this->smarty->assign('gmtTime', langDate(gmdate('F j, Y - H:i')));

        if ($deleteStatsTime = DB::init()->connect()->table('stats_visitors')->min('firstVisitOn')->getValue()) {
            $deleteStatsTime = strtotime($deleteStatsTime);
        } else {
            $deleteStatsTime = time() - 60*60*24*365;
        }

        $this->smarty->assign('deleteStatsTime', $deleteStatsTime);

        /** получить обновленные настройки */
        $this->smarty->assign('config', $settings->get());

        /** получить из папки themes языковые версии сайта(шаблоны) */
        $this->smarty->assign('themes', Helpers::init()->getThemes());
        /** с файла ru.inc.php получить разные спадающие списки <select> */
        $this->smarty->assign('ports',          lang('settings:mails:ports'));
        $this->smarty->assign('secures',        lang('settings:mails:secures'));
        $this->smarty->assign('methods',        lang('settings:users:methods'));
        $this->smarty->assign('mailTransports', lang('settings:mails:mailTransports'));
        $this->smarty->assign('langtimezones',  lang('langtimezones:langtimezone'));
        $this->smarty->assign('captchas',       lang('settings:captchas'));
        $this->smarty->assign('timeformats',    lang('settings:timeFormats'));
        $this->smarty->assign('fileExtension',  lang('settings:fileExtension'));
        $this->smarty->assign('separators',     lang('settings:separators'));
        $this->smarty->assign('driver',         lang('settings:driver'));
        $this->smarty->assign('works',          lang('general:works'));
        /** languages */
        $this->smarty->assign('adminLangs',         getLanguages());
        $this->smarty->assign('languageOptions',    LanguageSelection::$languageOptions);
        $this->smarty->assign('languageCharsets',   Charset::$languageCharsets);
        $this->smarty->assign('charsetOptions',     Charset::$charsetOptions);


        $this->smarty->assign('ADMINIP', UserInfo::get_ip());

        if(!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if(!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('settings', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('settings.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }
}
