<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;
use Mnv\Models\Socials\Socials;

/**
 * Class SocialsAdmin
 */
class SocialsAdmin extends AdminMnv
{

    public function fetch()
    {
        $socials = new Socials();

        $this->smarty->assign('activeItem','socials');
        $this->smarty->assign('title', lang('settings:social'));

        $socials->socialId  = (int) getRequestVar('id','');
        $socialIds          = getRequestVar('social', '',  true);

        if  ($this->action == 'remove') {

            if ($socials->remove()) {
                response()->make("deleteSuccess('" . $socials->socialId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();

        } else if ($this->action == 'status') {

            $result = $socials->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();

        } else if ($this->action == 'reorder') {

            $socials->reorder($socialIds);

        }

        /** получение всех соц. сетей */
        $socials->getAll();

        /** вывод в шаблон результатов */
        $this->smarty->assign('socials', $socials->socials);


        /** Права доступа к данному шаблону */
        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('socials', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('socials.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }


}



