<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\DB;
use Mnv\Models\Stats;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;


/**
 * Class Overview
 */
class StatsDownloadAdmin extends AdminMnv
{
    protected $dateSelector;

    /**
     * Overview constructor.
     * @throws \SmartyException
     */
    public function fetch()
    {
        $stats = new Stats();

        if (empty($dsCookieName)) $dsCookieName = 'mainDateSelector';

        $this->smarty->assign('activeItem', 'download');
        $this->smarty->assign('title', 'Статистика скачиваний');

        $modelId    = (int) getRequestVar('modelId', 0);
        $newDateStart    = getRequestVar('newDateStart');
        $newDateEnd      = getRequestVar('newDateEnd');

        $this->smarty->assign('models', $stats->getModels());
        $dateStart = $stats->getStartDate();
        $dateEnd = date('Y-m-d H:i:s');



        if (!empty($newDateStart)) $dateStart = "$newDateStart[Year]-$newDateStart[Month]-$newDateStart[Day]";
        if (!empty($newDateEnd)) $dateEnd = "$newDateEnd[Year]-$newDateEnd[Month]-$newDateEnd[Day]";

        $downloadPricesTotals = 0;
        $downloadPrices = $stats->getStatsDownloads($dateStart, $dateEnd, $modelId, 'prices');
        if (!empty($downloadPrices)) foreach ($downloadPrices as $downloadPrice) $downloadPricesTotals += $downloadPrice->totalDownloads;

        $this->smarty->assign('downloadPricesTotals', $downloadPricesTotals);
        $this->smarty->assign('downloadPrices', $downloadPrices);

        $downloadBrochuresTotals = 0;
        $downloadBrochures = $stats->getStatsDownloads($dateStart, $dateEnd, $modelId, 'brochure');
        if (!empty($downloadBrochures)) foreach ($downloadBrochures as $downloadBrochure) $downloadBrochuresTotals += $downloadBrochure->totalDownloads;

//        print_r($downloadPrices);
        $this->smarty->assign('downloadBrochuresTotals', $downloadBrochuresTotals);
        $this->smarty->assign('downloadBrochures', $downloadBrochures);


        $this->smarty->assign('modelId', $modelId);
        $this->smarty->assign('dateStart', $dateStart);
        $this->smarty->assign('dateEnd', $dateEnd);



        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('download', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('stats.download.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }

    }

    /**
     * Обновить статистику если были посещения
     */
    private function updateStatsCacheDaily()
    {
        /** найти самую последнюю дату */
        $firstDate = DB::init()->connect()->table('stats_cache_daily')->max('cacheDate', 'cacheDate')->get();
        $firstDate = $firstDate->cacheDate;

        if (empty($firstDate)) {
            $firstDate =  DB::init()->connect()->table('stats_visits')->min('visitDate', 'visitDate')->get();
            $firstDate = $firstDate->visitDate;
        }

        /* нахождение общего количества дней */
        $totalDays = intval((strtotime(adjustTime(gmNow())) - strtotime($firstDate)) / (60 * 60 * 24));

        /** запрашивать данные за каждый день */
        if(!empty($firstDate)) for($i = 0; $i <= $totalDays; $i++) {
            $cacheDay = array();
            $cacheDay['cacheDate'] = date('Y-m-d', strtotime("$firstDate $i days"));

            $startDate = adjustTime($cacheDay['cacheDate'], true);
            $endDate   = date('Y-m-d H:i:s', strtotime("$startDate +1 day -1 second"));

            /** новые и вернувшиеся посетители */
            $visitors = $this->visitors($startDate, $endDate);
            $cacheDay['newVisitors']    = empty($visitors[0]) ? 0 : $visitors[0];
            $cacheDay['retVisitors']    = empty($visitors[1]) ? 0 : $visitors[1];

            /** посещения по типу */
            $visits = $this->visits($startDate, $endDate);
            $cacheDay['sectionVisits']  = empty($visits[2]) ? 0 : $visits[2];
            $cacheDay['articleVisits']  = empty($visits[3]) ? 0 : $visits[3];
            $cacheDay['searchVisits']   = empty($visits[4]) ? 0 : $visits[4];
            $cacheDay['errorVisits']    = empty($visits[6]) ? 0 : $visits[6];
            $cacheDay['rssVisits']      = empty($visits[7]) ? 0 : $visits[7];


            /** посещения по времени создания страницы */
            $genTimes = $this->genTimes($startDate, $endDate);
            $cacheDay['pageGenTime100'] = empty($genTimes[0]) ? 0 : $genTimes[0];
            $cacheDay['pageGenTime250'] = empty($genTimes[1]) ? 0 : $genTimes[1];
            $cacheDay['pageGenTime500'] = empty($genTimes[2]) ? 0 : $genTimes[2];
            $cacheDay['pageGenTime1000'] = empty($genTimes[3]) ? 0 : $genTimes[3];
            $cacheDay['pageGenTime2000'] = empty($genTimes[4]) ? 0 : $genTimes[4];
            $cacheDay['pageGenTimeMore'] = empty($genTimes[5]) ? 0 : $genTimes[5];

            DB::init()->connect()->table('stats_cache_daily')->replace($cacheDay);
        }
    }

    /**
     * новые и вернувшиеся посетители
     *
     * 'indexKey'=>'isReturning', 'valueKey'=>'totalVisitors'
     *
     * @param $startDate
     * @param $endDate
     * @return array
     */
    private function visitors($startDate, $endDate)
    {
        $visitors = null;
        DB::init()->connect()->where('visitDate','>=', $startDate);
        DB::init()->connect()->where('visitDate','<=', $endDate);
        DB::init()->connect()->where('isBot','=', 0);

//        DB::init()->connect()->usingJoin('stats_visitors AS svs', 'visitorId','LEFT ');
//        DB::init()->connect()->usingJoin('stats_user_agents', 'userAgentId', 'LEFT ');
//        DB::init()->connect()->count('DISTINCT svs.visitorId', 'totalVisitors');
//        DB::init()->connect()->select("TO_DAYS('$startDate') - TO_DAYS(firstVisitOn) >= 1 AS isReturning");


        $visitorsArr = DB::init()->connect()->table('stats_visits')
            ->usingJoin('stats_visitors', 'visitorId', 'LEFT ')
            ->usingJoin('stats_user_agents', 'userAgentId', 'LEFT ')
            ->select("TO_DAYS('$startDate') - TO_DAYS(firstVisitOn) >= 1 AS isReturning")
            ->count('DISTINCT visitorId', 'totalVisitors')
            ->groupBy('isReturning')
            ->getAll();

        foreach ($visitorsArr as $item) $visitors[$item->isReturning] = $item->totalVisitors;

        return $visitors;
    }

    /**
     * посещения по типу
     *
     * 'indexKey'=>'typeId', 'valueKey'=>'totalVisits'
     *
     * @param $startDate
     * @param $endDate
     * @return array|null
     */
    private function visits($startDate, $endDate)
    {
        $visits = null;

        DB::init()->connect()->where('visitDate','>=', $startDate);
        DB::init()->connect()->where('visitDate','<=', $endDate);
        DB::init()->connect()->where('isBot','=', 0);

        DB::init()->connect()->usingJoin('stats_visitors', 'visitorId','LEFT ');
        DB::init()->connect()->usingJoin('stats_user_agents', 'userAgentId', 'LEFT ');
        if ($visitsArr = DB::init()->connect()->table('stats_visits')->select('typeId')->count('*','totalVisits')->groupBy('typeId')->getAll()) {
            foreach ($visitsArr as $item) $visits[$item->typeId] = $item->totalVisits;
        }

        return $visits;
    }


    /**
     * посещения по времени создания страницы
     *
     * 'indexKey'=>'pgtGroup', 'valueKey'=>'totalVisits'
     *
     * @param $startDate
     * @param $endDate
     * @return array
     */
    private function genTimes($startDate, $endDate)
    {
        $genTimes = null;

        DB::init()->connect()->where('visitDate','>=',$startDate);
        DB::init()->connect()->where('visitDate','<=',$endDate);
        DB::init()->connect()->groupBy('pgtGroup');
        DB::init()->connect()->select('INTERVAL(loadTime * 1000, 100, 250, 500, 1000, 2000) AS pgtGroup');

        if ($genTimesArr = DB::init()->connect()->table('stats_visits')->count( '*', 'totalVisits')->groupBy('pgtGroup')->getAll()) {
            foreach ($genTimesArr as $item) $genTimes[$item->pgtGroup] = $item->totalVisits;

          //  print_r(DB::init()->connect()->getQuery());

            return $genTimes;
        }
        return null;
    }

}

