<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Models\Stats;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;


/**
 * Class StatsErrorsAdmin
 */
class StatsErrorsAdmin extends AdminMnv
{
    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $stats = new Stats();

        $dateSelector = new StatsDateSelector();
        $errorCodeSelector = new StatsErrorCodeSelector();

        $this->smarty->assign('activeItem','errors');
        $this->smarty->assign('title', lang('stats:errorsTitle'));

        $errors = $stats->getStatsErrors($dateSelector->dateStart, $dateSelector->dateEnd, $errorCodeSelector->filterErrorCode, $this->page);
        if (!empty($errors)) foreach($errors as $error) {
            if (!empty($error->referer)) {
                $parseReferer = parseReferer($error->referer);
                if (isset($parseReferer['refererUrl'])) $error->refererUrl = $parseReferer['refererUrl'];
                if (isset($parseReferer['refererWebsite'])) $error->refererWebsite = $parseReferer['refererWebsite'];
            }

        }

        /* page numbering */
        $totalItems = $stats->getTotalStatsErrors($dateSelector->dateStart, $dateSelector->dateEnd, $errorCodeSelector->filterErrorCode);

        $pages = getPageNums($totalItems, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('errors', $errors);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('totalItems', $totalItems);
        $this->smarty->assign('page', $this->page);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('errors', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('stats.errors.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }
}
