<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\AdminMnv;
use Mnv\Core\DB;
use Mnv\Models\Subscribe;
use Mnv\Core\Managers\Role;

/**
 * Class SubscribeAdmin
 */
class SubscribeAdmin extends AdminMnv
{

    private $step = 0;


    public function fetch()
    {
        $subscribe = new Subscribe();
        $startFrom = 0;

        $this->smarty->assign('activeItem', 'subscribe');
        $this->smarty->assign('title', 'Рассылка письма');

        $subject      = getRequestVar('subject');
        $message      = getRequestVar('message');
        $startFrom = getRequestVar('startFrom');
//        $this->limit        = getRequestVar('limit');

        if  ($this->action == 'send') {
                $subscribers = DB::init()->connect()->table('users')
                    ->select('email, loginName, fullName, firstName, middleName, lastName')
                    ->where('subscribe', 'yes')
                    ->where('status', 1)
                    ->where('accessLevel', ROLE::CONSUMER)
                    ->limit($this->limit)->offset($startFrom)->getAll();

                if ($this->config['mail_transport'] == 'smtp') {
                    foreach ($subscribers as $subscriber) {
                        $subscribe->sendSMTP($subscriber->email, $subject, $message);
                        $this->step++;
                    }
                }

                $count = $startFrom + $this->step;

                if ($this->errors) {
                    $this->response = array('status' => 403, 'message' => $this->errors);
                } else {
                    $this->response = array('status' => 200, 'count' => $count);
                }
                response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();

        } else {
                $subscribers = DB::init()->connect()->table('users')->count('*', 'count')->where('subscribe','=', 'yes')->where('status','=', 1)->where('accessLevel','=', 8192)->getValue();

                $this->smarty->assign('total', $subscribers);
        }


        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('subscribe', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('subscribe.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }
}
