<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');


use Mnv\Core\AdminMnv;
use Mnv\Core\DB;
use Mnv\Models\Subscribe;
use Mnv\Core\Managers\Role;
use Mnv\Models\Telegram\TelegramConfig;
use Mnv\Models\Telegram\TelegramMyMailings;
use Mnv\Modules\Telegram\Telegram;

/**
 * Class TelegramMailingAdmin
 */
class TelegramMailingAdmin extends AdminMnv
{
    private $tags = ['</p>', '<br />', '<br>', '<hr />', '<hr>', '</h1>', '</h2>', '</h3>', '</h4>', '</h5>', '</h6>', '</ul>', '</ol>', '</li>'];
    private int $step = 0;
    private Telegram $telegram;
    private ?string $image;
    private ?string $text;
    private ?string $type;
    private int $state = 200;

    public function fetch()
    {
        $mailing = new TelegramMyMailings();
        $this->telegram = new Telegram(TelegramConfig::init()->get('botApiKey'));

        $this->smarty->assign('activeItem', 'botmailing');
        $this->smarty->assign('title', 'Рассылка письма');
        $this->smarty->assign('mailingList', $mailing->getMailingList());
        $this->smarty->assign('types',  array(0 => 'Выберите вид отображение картинки', 1 => 'В тексте', 2 => 'Над текстом'));

        $startFrom          = (int) getRequestVar('startFrom', 0);
        $limit              = (int) getRequestVar('limit', '');
        $mailing->mailingId = (int) getRequestVar('id', '');
        $this->type         = getRequestVar('type');
        $chats              = getRequestVar('chats');


        /** отправка рассылки */
        if ($this->action == 'send') {
            if (!empty($mailing->mailingId) && $mailing->mailingId > 0) {
                if (!empty($this->type)) {
                    $users = $this->getUsers($limit, $startFrom);
                    $this->get($mailing);

                    if (!empty($this->text)) {
                        foreach ($users as $user) {
//                            $result = $this->send($user->chat_id);
//                            print_r($result);
//                            if (isset($result['error_code']) && ($code = $result['error_code'])) {
//                                $this->state = $code;
//                                $this->messages = 'CHAT_ID: ' . $user->chat_id . '...ERROR: ' . $result['description'];
//                            }
//                            if (isset($result['ok']) && (int)$result['ok'] == 1) {
                                $this->step++;
                                $sending = [
                                    'mailing_id'    => $mailing->mailingId,
                                    'user_id'       => $user->user_id,
                                    'chat_id'       => $user->chat_id,
                                    'status'        => 1,
                                    'message'       => 'CHAT_ID: ' . $user->chat_id . '...OK: ',
                                ];
                                $this->messages = 'CHAT_ID: ' . $user->chat_id . '...OK: ';
//                            }
                            DB::init()->connect()->table('telegram_mailing_stats')->insert($sending);
                        }
                    }
                } else {
                    $this->errors = 'Необходимо выбрать тип отображения картинки';
                    $this->state = 403;
                }
            } else {
                $this->errors = 'Необходимо выбрать рассылку ';
                $this->state = 403;
            }

            $count = $startFrom + $this->step;

            if ($this->errors) {
                $this->response = array('status' => $this->state, 'message' => $this->errors, 'count' => $count, 'type' => 'error');
            } else {
                $this->response = array('status' => $this->state, 'message' => $this->messages, 'count' => $count, 'type' => 'success');
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        }
        /** тестировать рассылку */
        else if ($this->action == 'testing') {
            if (!empty($mailing->mailingId) && $mailing->mailingId > 0) {
                if (!empty($chats)) {
                    if (!empty($this->type)) {
                        $this->get($mailing);
                        $chats = explode(", ", $chats);
                        if (!empty($this->text)) {
                            foreach ($chats as $chatID) {
                                $result = $this->send($chatID);
                                if ($result['ok'] == 1) {
                                    $this->response = array('status' => 200, 'message' => 'Успешно отправлено пользователю ' . $chatID);
                                } else {
                                    $this->response = array('status' => $result['error_code'], 'message' => "Ошибка отправления <br>Код ошибки: " . $result['error_code'] . "<br>Описание ошибки: " . $result['description']);
                                }
                            }
                        }
                    } else {
                        $this->response = array('status' => 403, 'message' => 'Необходимо выбрать тип отображения картинки');
                    }
                } else {
                    $this->response = array('status' => 403, 'message' => 'Укажите CHAT ID');
                }
            } else {
                $this->response = array('status' => 403, 'message' => 'Необходимо выбрать рассылку');
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        }
        /** изменение статуса пользователей бота для оправки рассылки  */
        elseif ($this->action == 'change') {
            $res = DB::init()->connect()->table('telegram_user')->where('mailing', 'yes')->update(['mailing' => 'no'], false);
            if ($res) {
                $this->response = array('status' => 200, 'count' => $res);
            } else {
                $this->response = array('status' => 403, 'message' => 'Ошибка изменения статуса');
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }

        else {
            /** кол-во пользователей */
            $this->getUsers($limit, $startFrom);
            $this->smarty->assign('total', $this->getTotal());
            $this->smarty->assign('limit', $limit);
        }

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN, Role::MODERATOR]) && (in_array('botmailing', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('bot.mailing.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }

    /**
     * Получение рассылки
     *
     * @param TelegramMyMailings $mailing
     */
    private function get(TelegramMyMailings $mailing)
    {
        if ($mailing->mailingId > 0) {
            $mailing->edit();

            if (!empty($mailing->mailing)) {
                $cleanedContent = str_replace($this->tags, "\n", $mailing->mailing->content);
                $this->text = html_entity_decode(strip_tags($cleanedContent));
                if (!empty($mailing->mailing->image)) $this->image = GLOBAL_URL . $mailing->mailing->image->original;

                if (!empty($mailing->mailing->image) && $this->type != 2) {
                    $this->text .= "\n<a href='" . $this->image . "'>&#8205;</a>";
                }
            }
        }
    }

    /**
     * Отправка сообщение пользователю
     * @param $chatID
     * @return mixed
     */
    private function send($chatID)
    {
        if ($this->type == 2) {
           return $this->telegram->sendPhoto([
                'chat_id'       => $chatID,
                'photo'         => $this->image,
                'caption'       => $this->text,
                'parse_mode'    => "HTML"
            ]);
        } else {
            return $this->telegram->sendMessage([
                'chat_id'   => $chatID,
                'text'          => $this->text,
                'parse_mode'    => "HTML"
            ]);
        }
    }


    /**
     * получить пользователей
     *
     * @param int $limit
     * @param int $startFrom
     * @return array|false|mixed|string|null
     */
    private function getUsers(int $limit, int $startFrom = 0)
    {
        $users = DB::init()->connect()->table('telegram_user')->join('telegram_user_chat', 'user_id', '=', 'id')
            ->select('id, chat_id, user_id, mailing')
//            ->where('mailing', 'no')
            ->orderBy('id', 'DESC')
            ->limit($limit)->offset($startFrom)->getAll();
            file_put_contents("text.txt", date('[Y-m-d H:i:s] ') . DB::init()->connect()->getQuery() . PHP_EOL, FILE_APPEND);
            file_put_contents("text2.txt",  date('[Y-m-d H:i:s] ') . print_r($users, true) . PHP_EOL, FILE_APPEND);

        return $users;
    }


    /**
     * Получить кол-во
     * @return mixed|string|null
     */
    private function getTotal()
    {
        return DB::init()->connect()->table('telegram_user')->count('*', 'count')
//            ->where('mailing', 'no')
            ->getValue();
    }
}
