<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers\Role;
use Mnv\Models\Telegram\TelegramMyMailings;

/**
 * Class TelegramMyMailingAdmin
 * @package Mnv\Admin\Controllers
 */
class TelegramMyMailingAdmin  extends AdminMnv
{

    public function fetch()
    {

        $mailing = new TelegramMyMailings();
        $this->smarty->assign('activeItem','botmymailings');
        $this->smarty->assign('title', "Новая рассылка");
        /** statuses */
        $this->smarty->assign('statuses', array('hidden' => 'Завершена', 'visible' => 'Ожидает'));
        $this->smarty->assign('positions',  array(0 => 'Выберите вид отображение картинки', 1 => 'В тексте', 2 => 'Над текстом'));

        /** получение ID для редактирования / удаления / изменение статуса */
        $mailing->mailingId     = (int) getRequestVar('id', '');
        $mailing->mailing       = (object)getRequestVar('mailing', '', true);
        $image    = getRequestVar('image', '',  true);

        if ($this->action == 'add' || $this->action == 'edit') {
            $mailing->edit();
        } else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($mailing->mailing->name)) $this->errors['name'] = true;
            if (empty($mailing->mailing->positionImage)) $this->errors['positionImage'] = true;
            if (!empty($image)) $mailing->mailing->fileId = $image['fileId'];


            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {

                /** если пустой ID то создаем новую статью / если существует ID то редактируем статью */
                if (empty($mailing->mailingId)) {

                    $mailing->mailing->addedBy     = $this->managers->manager->userId;
                    $mailing->mailing->addedOn     = gmdate('Y-m-d H:i:s');

                    if ($mailing->add($mailing->mailing)) {
                        $this->messages['saved'] = true;

                        if (empty($this->errors) && $this->action == 'apply')
                            redirect("index.php?mod=botmymailing&action=edit&id={$mailing->mailingId}&page={$this->page}");

                    } else {
                        $this->errors['not_saved'] = true;
                    }

                } else {

                    $mailing->update($mailing->mailing);
                    $this->messages['saved'] = true;
                }
            }

            $mailing->edit();

            if (empty($this->errors) && $this->action == 'save')
                redirect("index.php?mod=botmymailings&page={$this->page}");

        }/** удаление основной картинки */
        else if ($this->action == 'deleteImage') {
            if ($mailing->deleteImage($mailing->mailingId)) {
                response()->make("deleteImageSuccess();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteImageError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();
        }

        if (!empty($mailing->mailingId) && empty($mailing->mailing)) $this->errors['template_empty'] = true;

        if (!($mailing->mailing instanceof \stdClass)) $mailing->mailing = (object)$mailing->mailing;

        $this->smarty->assign('mailing', $mailing->mailing);

        /** Вывод сообщений или ошибок */
        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('botmymailings', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('bot.mymailing.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }
    }

}