<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Core\DB;
use Mnv\Core\Managers\Role;
use Mnv\Models\Telegram\TelegramConfig;
use Mnv\Models\Telegram\TelegramMyMailings;
use Mnv\Modules\Telegram\Telegram;

/**
 * Class TelegramMyMailingSendAdmin
 * @package Mnv\Admin\Controllers
 */
class TelegramMyMailingSendAdmin  extends AdminMnv
{
    private int $step = 0;
    private Telegram $telegram;
    private ?string $image;
    private ?string $text;
    private int $state = 200;
    private $group;
    public function fetch()
    {
        $count = 0;
        $mailing = new TelegramMyMailings();
        $this->telegram = new Telegram(TelegramConfig::init()->get('botApiKey'));

        $this->smarty->assign('activeItem','botmymailings');
        $this->smarty->assign('title', "Рассылка");
        /** statuses */

        $mailing->mailingId = (int) getRequestVar('id', '');
        $startFrom          = (int) getRequestVar('startFrom', 0);
        $limit              = (int) getRequestVar('limit', '');

        /** $chatIDS для тестирования **/
        $chatIDS              = getRequestVar('chatIDS');

        if ($this->action == 'send') {
            if ($mailing->mailingId > 0) {
                $this->get($mailing);
                $users = $this->getUsers($mailing->mailingId, $limit, $startFrom);
                foreach ($users as $user) {
                    $this->send($mailing, $user->user_id, $user->chat_id);
                }

                $count = $startFrom + $this->step;
            } else {
                $this->state = 403;
                $this->errors = 'Необходимо выбрать рассылку';
            }

            if ($this->errors) {
                $this->response = array('status' => $this->state, 'message' => $this->errors, 'type' => 'error');
            } else {
                $this->messages = 'Успешно отправлено группе пользователей из ' . $this->step . ' контактов';
                $this->response = array('status' => $this->state, 'message' => $this->messages, 'count' => $count, 'group' => $this->group, 'type' => 'success');
            }

            return response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();

        }
        /** тестировать рассылку */
        else if ($this->action == 'testing') {
            if (!empty($chatIDS)) {
                $this->get($mailing);
                $chatIDS = explode(", ", $chatIDS);
                if (!empty($this->text)) {
                    foreach ($chatIDS as $chatID) {
                        $this->send($mailing, 0, $chatID);
                        if ($this->errors) {
                            $this->response = array('status' => $this->state, 'message' => $this->errors, 'type' => 'error');
                        } else {
                            $this->response = array('status' => $this->state, 'message' => $this->messages, 'type' => 'success');
                        }
                    }
                }
            } else {
                $this->response = array('status' => 403, 'message' => 'Укажите CHAT ID');
            }

           return response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        }
        /** Обновить статус по окончанию рассылки */
        else if ($this->action == 'end') {
            if ($mailing->update(['status' => 'hidden'])) {
                $this->response = array('status' => $this->state, 'message' => 'Статус обновлен', 'type' => 'success');
            } else {
                $this->response = array('status' => $this->state, 'message' => 'Ошибка обновление статуса', 'type' => 'error');
            }
            return response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();

        } else {

            $mailing->edit();
            if (!empty($mailing->mailingId) && empty($mailing->mailing)) $this->errors['template_empty'] = true;

            if (!($mailing->mailing instanceof \stdClass)) $mailing->mailing = (object)$mailing->mailing;

            $this->smarty->assign('mailing', $mailing->mailing);
            $this->smarty->assign('total', $this->getTotal($mailing->mailingId));
            $this->smarty->assign('limit', $limit);

            if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        }

        if (in_array($this->managers->manager->accessLevel, [Role::DEVELOPER, Role::MANAGER, Role::ADMIN]) && (in_array('botmymailings', $this->managers->manager->permissions))) {
            return $this->smarty->fetch('bot.mailingsend.tpl');
        } else {
            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');
        }


    }

    /**
     * Получение рассылки
     *
     * @param TelegramMyMailings $mailing
     */
    private function get(TelegramMyMailings $mailing)
    {
        $tags = ['</p>', '<br />', '<br>', '<hr />', '<hr>', '</h1>', '</h2>', '</h3>', '</h4>', '</h5>', '</h6>', '</ul>', '</ol>', '</li>'];

        if ($mailing->mailingId > 0) {
            $mailing->edit();

            if (!empty($mailing->mailing)) {
                $cleanedContent = str_replace($tags, "\n", $mailing->mailing->content);
                $this->text = html_entity_decode(strip_tags($cleanedContent));
                if (!empty($mailing->mailing->image)) $this->image = GLOBAL_URL . $mailing->mailing->image->original;

                if (!empty($mailing->mailing->image) && $mailing->mailing->positionImage != 2) {
                    $this->text .= "\n<a href='" . $this->image . "'>&#8205;</a>";
                }
            }
        }
    }

    /**
     * Отправка сообщение пользователю
     *
     * @param TelegramMyMailings $mailing
     * @param $userID
     * @param $chatID
     */
    private function send(TelegramMyMailings $mailing, $userID = 0, $chatID)
    {
        $sending = null;
        if ($mailing->mailing->positionImage == 2) {
            $result = $this->telegram->sendPhoto([
                'chat_id'       => $chatID,
                'photo'         => $this->image,
                'caption'       => $this->text,
                'parse_mode'    => "HTML"
            ]);
        } else {
            $result = $this->telegram->sendMessage([
                'chat_id'   => $chatID,
                'text'          => $this->text,
                'parse_mode'    => "HTML"
            ]);
        }

        if (isset($result['error_code']) && ($code = $result['error_code'])) {
            $this->state = $code;
            $this->group .= '<span class="font-size-xs text-danger">CHAT_ID: ' . $chatID . '...ERROR:</span><br />';
            $sending = [
                'mailing_id'    => $mailing->mailingId,
                'user_id'       => $userID,
                'chat_id'       => $chatID,
                'status'        => $this->state,
                'message'       => 'CHAT_ID: ' . $chatID . '...ERROR: ' . $result['description'],
                'state'         => 'ERROR',
            ];
        }
        if (isset($result['ok']) && (int)$result['ok'] == 1) {
            $this->state = 200;
            $this->group .= '<span class="font-size-xs">CHAT_ID: ' . $chatID . '...OK:</span><br />';
            $sending = [
                'mailing_id'    => $mailing->mailingId,
                'user_id'       => $userID,
                'chat_id'       => $chatID,
                'status'        => $this->state,
                'message'       => 'CHAT_ID: ' . $chatID . '...OK: ',
                'state'         => 'OK',
            ];
        }

        $this->step++;
        if (!is_null($sending) && $userID != 0) {
            DB::init()->connect()->table('telegram_mailing_stats')->replace($sending);
        }

    }

    /**
     * получить пользователей
     *
     * @param int $limit
     * @param int $startFrom
     * @return array|false|mixed|string|null
     */
    private function getUsers($mailingID, int $limit, int $startFrom = 0)
    {
        $this->getUserIds($mailingID);

        $users = DB::init()->connect()->table('telegram_user')->join('telegram_user_chat', 'user_id', '=', 'id')
            ->select('id, chat_id, user_id, mailing')->orderBy('id', 'DESC')->limit($limit)
//            ->offset($startFrom)
            ->getAll();

        return $users;
    }


    /**
     * Получить кол-во
     * @return mixed|string|null
     */
    private function getTotal($mailingID)
    {
        $this->getUserIds($mailingID);

        return DB::init()->connect()->table('telegram_user')->count('*', 'count')->getValue();
    }

    /**
     * @param $mailingID
     */
    private function getUserIds($mailingID)
    {
//        $userIds = DB::init()->connect()->table('telegram_mailing_stats')->select('user_id')->where('mailing_id', $mailingID)->indexKey('user_id')->valueKey('user_id')->getAllIndexes();
        $users = DB::init()->connect()->table('telegram_mailing_stats')->select('user_id')->where('mailing_id', $mailingID)->getAll();
        $userIds = array_column($users, 'user_id');

        if (!empty($userIds)) DB::init()->connect()->notIn('id', $userIds);
    }


}