var App = function () {

    var _transitionsDisabled = function() {
        $('body').addClass('no-transitions');
    };

    var _transitionsEnabled = function() {
        $('body').removeClass('no-transitions');
    };

    var _sidebarMainResize = function() {

        var revertBottomMenus = function() {
            $('.sidebar-main').find('.nav-sidebar').children('.nav-item-submenu').hover(function() {
                var totalHeight = 0,
                    $this = $(this),
                    navSubmenuClass = 'nav-group-sub',
                    navSubmenuReversedClass = 'nav-item-submenu-reversed';

                totalHeight += $this.find('.' + navSubmenuClass).filter(':visible').outerHeight();
                if($this.children('.' + navSubmenuClass).length) {
                    if(($this.children('.' + navSubmenuClass).offset().top + $this.find('.' + navSubmenuClass).filter(':visible').outerHeight()) > document.body.clientHeight) {
                        $this.addClass(navSubmenuReversedClass);
                    }
                    else {
                        $this.removeClass(navSubmenuReversedClass);
                    }
                }
            });
        }

        if($('body').hasClass('sidebar-xs')) {
            revertBottomMenus();
        }

        $('.sidebar-main-toggle').on('click', function (e) {
            e.preventDefault();

            $('body').toggleClass('sidebar-xs').removeClass('sidebar-mobile-main');
            revertBottomMenus();
        });
    };

    var _sidebarMainToggle = function() {
        $(document).on('click', '.sidebar-main-hide', function (e) {
            e.preventDefault();
            $('body').toggleClass('sidebar-main-hidden');
        });
    };

    var _sidebarSecondaryToggle = function() {
        $(document).on('click', '.sidebar-secondary-toggle', function (e) {
            e.preventDefault();
            $('body').toggleClass('sidebar-secondary-hidden');
        });
    };

    var _sidebarRightMainToggle = function() {
        $(document).on('click', '.sidebar-right-main-toggle', function (e) {
            e.preventDefault();

            $('body').toggleClass('sidebar-right-visible');

            if ($('body').hasClass('sidebar-right-visible')) {
                $('body').addClass('sidebar-xs');
                $('.sidebar-main .nav-sidebar').children('.nav-item').children('.nav-group-sub').css('display', '');
            } else {
                $('body').removeClass('sidebar-xs');
            }
        });
    };

    var _sidebarRightMainHide = function() {
        $(document).on('click', '.sidebar-right-main-hide', function (e) {
            e.preventDefault();

            // Opposite sidebar visibility
            $('body').toggleClass('sidebar-right-visible');
            
            // If visible
            if ($('body').hasClass('sidebar-right-visible')) {
                $('body').addClass('sidebar-main-hidden');
            }
            else {
                $('body').removeClass('sidebar-main-hidden');
            }
        });
    };

    var _sidebarRightToggle = function() {
        $(document).on('click', '.sidebar-right-toggle', function (e) {
            e.preventDefault();

            $('body').toggleClass('sidebar-right-visible');
        });
    };

    var _sidebarRightSecondaryToggle = function() {
        $(document).on('click', '.sidebar-right-secondary-toggle', function (e) {
            e.preventDefault();

            $('body').toggleClass('sidebar-right-visible');

            if ($('body').hasClass('sidebar-right-visible')) {
                $('body').addClass('sidebar-secondary-hidden');
            } else {
                $('body').removeClass('sidebar-secondary-hidden');
            }
        });
    };

    var _sidebarComponentToggle = function() {
        $(document).on('click', '.sidebar-component-toggle', function (e) {
            e.preventDefault();
            $('body').toggleClass('sidebar-component-hidden');
        });
    };

    var _sidebarMobileFullscreen = function() {
        $('.sidebar-mobile-expand').on('click', function (e) {
            e.preventDefault();
            var $sidebar = $(this).parents('.sidebar'), sidebarFullscreenClass = 'sidebar-fullscreen';

            if(!$sidebar.hasClass(sidebarFullscreenClass)) {
                $sidebar.addClass(sidebarFullscreenClass);
            } else {
                $sidebar.removeClass(sidebarFullscreenClass);
            }
        });
    };

    var _sidebarMobileMainToggle = function() {
        $('.sidebar-mobile-main-toggle').on('click', function(e) {
            e.preventDefault();
            $('body').toggleClass('sidebar-mobile-main').removeClass('sidebar-mobile-secondary sidebar-mobile-right');

            if($('.sidebar-main').hasClass('sidebar-fullscreen')) {
                $('.sidebar-main').removeClass('sidebar-fullscreen');
            }
        });
    };

    var _sidebarMobileSecondaryToggle = function() {
        $('.sidebar-mobile-secondary-toggle').on('click', function (e) {
            e.preventDefault();
            $('body').toggleClass('sidebar-mobile-secondary').removeClass('sidebar-mobile-main sidebar-mobile-right');

            if($('.sidebar-secondary').hasClass('sidebar-fullscreen')) {
                $('.sidebar-secondary').removeClass('sidebar-fullscreen');
            }
        });
    };

    var _sidebarMobileRightToggle = function() {
        $('.sidebar-mobile-right-toggle').on('click', function (e) {
            e.preventDefault();
            $('body').toggleClass('sidebar-mobile-right').removeClass('sidebar-mobile-main sidebar-mobile-secondary');

            if($('.sidebar-right').hasClass('sidebar-fullscreen')) {
                $('.sidebar-right').removeClass('sidebar-fullscreen');
            }
        });
    };

    var _sidebarMobileComponentToggle = function() {
        $('.sidebar-mobile-component-toggle').on('click', function (e) {
            e.preventDefault();
            $('body').toggleClass('sidebar-mobile-component');
        });
    };

    var _navigationSidebar = function() {

        var navClass = 'nav-sidebar', navItemClass = 'nav-item', navItemOpenClass = 'nav-item-open',
            navLinkClass = 'nav-link', navSubmenuClass = 'nav-group-sub', navSlidingSpeed = 250;

        $('.' + navClass).each(function() {
            $(this).find('.' + navItemClass).has('.' + navSubmenuClass).children('.' + navItemClass + ' > ' + '.' + navLinkClass).not('.disabled').on('click', function (e) {
                e.preventDefault();

                var $target = $(this),
                    $navSidebarMini = $('.sidebar-xs').not('.sidebar-mobile-main').find('.sidebar-main .' + navClass).children('.' + navItemClass);

                if ($target.parent('.' + navItemClass).hasClass(navItemOpenClass)) {
                    $target.parent('.' + navItemClass).not($navSidebarMini).removeClass(navItemOpenClass).children('.' + navSubmenuClass).slideUp(navSlidingSpeed);
                } else {
                    $target.parent('.' + navItemClass).not($navSidebarMini).addClass(navItemOpenClass).children('.' + navSubmenuClass).slideDown(navSlidingSpeed);
                }

                if ($target.parents('.' + navClass).data('nav-type') == 'accordion') {
                    $target.parent('.' + navItemClass).not($navSidebarMini).siblings(':has(.' + navSubmenuClass + ')').removeClass(navItemOpenClass).children('.' + navSubmenuClass).slideUp(navSlidingSpeed);
                }
            });
        });

        $(document).on('click', '.' + navClass + ' .disabled', function(e) {
            e.preventDefault();
        });

        $('.nav-scrollspy').find('.' + navItemClass).has('.' + navSubmenuClass).children('.' + navItemClass + ' > ' + '.' + navLinkClass).off('click');
    };

    var _navigationNavbar = function() {

        $(document).on('click', '.dropdown-content', function(e) {
            e.stopPropagation();
        });

        $('.navbar-nav .disabled a, .nav-item-levels .disabled').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
        });

        $('.dropdown-content a[data-toggle="tab"]').on('click', function(e) {
            $(this).tab('show');
        });
    };


    var _componentTooltip = function() {
        $('[data-popup="tooltip"]').tooltip();

        var demoTooltipSelector = '[data-popup="tooltip-demo"]';
        if($(demoTooltipSelector).is(':visible')) {
            $(demoTooltipSelector).tooltip('show');
            setTimeout(function() {
                $(demoTooltipSelector).tooltip('hide');
            }, 2000);
        }
    };

    var _componentPopover = function() {
        $('[data-popup="popover"]').popover();
    };

    var _cardActionReload = function() {
        $('.card [data-action=reload]:not(.disabled)').on('click', function (e) {
            e.preventDefault();
            var $target = $(this), block = $target.closest('.card');

            $(block).block({ 
                message: '<i class="icon-spinner2 spinner"></i>',
                overlayCSS: { backgroundColor: '#fff', opacity: 0.8, cursor: 'wait', 'box-shadow': '0 0 0 1px #ddd' },
                css: { border: 0, padding: 0, backgroundColor: 'none' }
            });

            window.setTimeout(function () {
               $(block).unblock();
            }, 2000); 
        });
    };

    var _cardActionCollapse = function() {
        var $cardCollapsedClass = $('.card-collapsed');

        $cardCollapsedClass.children('.card-header').nextAll().hide();

        $cardCollapsedClass.find('[data-action=collapse]').addClass('rotate-180');

        $('.card [data-action=collapse]:not(.disabled)').on('click', function (e) {
            var $target = $(this), slidingSpeed = 150;

            e.preventDefault();
            $target.parents('.card').toggleClass('card-collapsed');
            $target.toggleClass('rotate-180');
            $target.closest('.card').children('.card-header').nextAll().slideToggle(slidingSpeed);
        });
    };

    var _cardActionRemove = function() {
        $('.card [data-action=remove]').on('click', function (e) {
            e.preventDefault();
            var $target = $(this), slidingSpeed = 150;

            if(!$target.hasClass('disabled')) {
                $target.closest('.card').slideUp({
                    duration: slidingSpeed,
                    start: function() { $target.addClass('d-block'); },
                    complete: function() { $target.remove(); }
                });
            }
        });
    };

    var _cardActionFullscreen = function() {
        $('.card [data-action=fullscreen]').on('click', function (e) {
            e.preventDefault();

            var $target = $(this), cardFullscreen = $target.closest('.card'), overflowHiddenClass = 'overflow-hidden', collapsedClass = 'collapsed-in-fullscreen', fullscreenAttr = 'data-fullscreen';

            cardFullscreen.toggleClass('fixed-top h-100 rounded-0');

            if (!cardFullscreen.hasClass('fixed-top')) {
                $target.removeAttr(fullscreenAttr);
                cardFullscreen.children('.' + collapsedClass).removeClass('show');
                $('body').removeClass(overflowHiddenClass);
                $target.siblings('[data-action=move], [data-action=remove], [data-action=collapse]').removeClass('d-none');
            } else {
                $target.attr(fullscreenAttr, 'active');
                cardFullscreen.removeAttr('style').children('.collapse:not(.show)').addClass('show ' + collapsedClass);
                $('body').addClass(overflowHiddenClass);
                $target.siblings('[data-action=move], [data-action=remove], [data-action=collapse]').addClass('d-none');
            }
        });
    };

    var _dropdownSubmenu = function() {

        $('.dropdown-menu').find('.dropdown-submenu').not('.disabled').find('.dropdown-toggle').on('click', function(e) {
            e.stopPropagation();
            e.preventDefault();

            $(this).parent().siblings().removeClass('show').find('.show').removeClass('show');

            $(this).parent().toggleClass('show').children('.dropdown-menu').toggleClass('show');

            $(this).parents('.show').on('hidden.bs.dropdown', function(e) {
                $('.dropdown-submenu .show, .dropdown-submenu.show').removeClass('show');
            });
        });
    };

    var _headerElements = function() {
        $('.header-elements-toggle').on('click', function(e) {
            e.preventDefault();
            $(this).parents('[class*=header-elements-]').find('.header-elements').toggleClass('d-none');
        });

        $('.footer-elements-toggle').on('click', function(e) {
            e.preventDefault();
            $(this).parents('.card-footer').find('.footer-elements').toggleClass('d-none');
        });
    };

    var _componentNoty = function() {
        if (typeof Noty == 'undefined') {
            console.warn('Warning - noty.min.js is not loaded.');
            return;
        }

        Noty.overrideDefaults({ theme: 'limitless', layout: 'topRight', type: 'alert', timeout: 2500 });

        $('#noty_error').on('click', function() {
            new Noty({ text: 'Change a few things up and try submitting again.', type: 'error' }).show();
        });

        $('#noty_success').on('click', function() {
            new Noty({ text: 'You successfully read this important alert message.', type: 'success' }).show();
        });

        $('#noty_warning').on('click', function() {
            new Noty({ text: 'Warning! Best check yo self, you\'re not looking too good.', type: 'warning' }).show();
        });

        $('#noty_info').on('click', function() {
            new Noty({ text: 'This alert needs your attention, but it\'s not super important.',  type: 'info' }).show();
        });

        $('#noty_alert').on('click', function() {
            new Noty({ text: 'Best check yourself, you\'re not looking too good.', type: 'alert' }).show();
        });


    };

    var _componentFileUpload = function() {
        if (!$().fileinput) {
            console.warn('Warning - fileinput.min.js is not loaded.');
            return;
        }

        var modalTemplate = '<div class="modal-dialog modal-lg" role="document">\n' +
            '  <div class="modal-content">\n' +
            '    <div class="modal-header align-items-center">\n' +
            '      <h6 class="modal-title">{heading} <small><span class="kv-zoom-title"></span></small></h6>\n' +
            '      <div class="kv-zoom-actions btn-group">{toggleheader}{fullscreen}{borderless}{close}</div>\n' +
            '    </div>\n' +
            '    <div class="modal-body">\n' +
            '      <div class="floating-buttons btn-group"></div>\n' +
            '      <div class="kv-zoom-body file-zoom-content"></div>\n' + '{prev} {next}\n' +
            '    </div>\n' +
            '  </div>\n' +
            '</div>\n';

        var previewZoomButtonClasses = {
            toggleheader: 'btn btn-light btn-icon btn-header-toggle btn-sm',
            fullscreen: 'btn btn-light btn-icon btn-sm',
            borderless: 'btn btn-light btn-icon btn-sm',
            close: 'btn btn-light btn-icon btn-sm'
        };

        var previewZoomButtonIcons = {
            prev: '<i class="icon-arrow-left32"></i>',
            next: '<i class="icon-arrow-right32"></i>',
            toggleheader: '<i class="icon-menu-open"></i>',
            fullscreen: '<i class="icon-screen-full"></i>',
            borderless: '<i class="icon-alignment-unalign"></i>',
            close: '<i class="icon-cross2 font-size-base"></i>'
        };

        var fileActionSettings = {
            zoomClass: '',
            zoomIcon: '<i class="icon-zoomin3"></i>',
            dragClass: 'p-2',
            dragIcon: '<i class="icon-three-bars"></i>',
            removeClass: '',
            removeErrorClass: 'text-danger',
            removeIcon: '<i class="icon-bin"></i>',
            indicatorNew: '<i class="icon-file-plus text-success"></i>',
            indicatorSuccess: '<i class="icon-checkmark3 file-icon-large text-success"></i>',
            indicatorError: '<i class="icon-cross2 text-danger"></i>',
            indicatorLoading: '<i class="icon-spinner2 spinner text-muted"></i>'
        };

        $('.file-input').fileinput({
            maxFileCount: 1,
            removeLabel: "Удалить",
            browseLabel: 'Загрузить файл',
            browseIcon: '<i class="icon-file-plus mr-2"></i>',
            uploadIcon: '<i class="icon-file-upload2 mr-2"></i>',
            removeIcon: '<i class="icon-cross2 font-size-base mr-2"></i>',
            layoutTemplates: { icon: '<i class="icon-file-check"></i>', modal: modalTemplate },
            initialCaption: "No file selected",
            previewZoomButtonClasses: previewZoomButtonClasses,
            previewZoomButtonIcons: previewZoomButtonIcons,
            fileActionSettings: fileActionSettings
        });
        
        $('.file-manager').fileinput({
            maxFileCount: 1,
            removeLabel: "Удалить",
            browseLabel: 'Добавить файл...',
            browseIcon: '<i class="icon-file-plus mr-2"></i>',
            uploadIcon: '<i class="icon-file-upload2 mr-2"></i>',
            removeIcon: '<i class="icon-cross2 font-size-base mr-2"></i>',
            layoutTemplates: { icon: '<i class="icon-file-check"></i>', modal: modalTemplate },
            initialCaption: "No file selected",
            previewZoomButtonClasses: previewZoomButtonClasses,
            previewZoomButtonIcons: previewZoomButtonIcons,
            fileActionSettings: fileActionSettings
        });

        $('.file-input-custom').fileinput({
            previewFileType: 'image',
            browseLabel: 'Select',
            browseClass: 'btn bg-slate-700',
            browseIcon: '<i class="icon-image2 mr-2"></i>',
            removeLabel: 'Remove',
            removeClass: 'btn btn-danger',
            removeIcon: '<i class="icon-cancel-square mr-2"></i>',
            uploadClass: 'btn bg-teal-400',
            uploadIcon: '<i class="icon-file-upload mr-2"></i>',
            layoutTemplates: { icon: '<i class="icon-file-check"></i>', modal: modalTemplate },
            initialCaption: "Please select image",
            mainClass: 'input-group',
            previewZoomButtonClasses: previewZoomButtonClasses,
            previewZoomButtonIcons: previewZoomButtonIcons,
            fileActionSettings: fileActionSettings
        });

        $('.file-input-advanced').fileinput({
            browseLabel: 'Browse',
            browseClass: 'btn btn-light',
            removeClass: 'btn btn-light',
            uploadClass: 'btn bg-success-400',
            browseIcon: '<i class="icon-file-plus mr-2"></i>',
            uploadIcon: '<i class="icon-file-upload2 mr-2"></i>',
            removeIcon: '<i class="icon-cross2 font-size-base mr-2"></i>',
            layoutTemplates: {
                icon: '<i class="icon-file-check"></i>',
                main1: "{preview}\n" +
                    "<div class='input-group {class}'>\n" +
                    "   <div class='input-group-prepend'>\n" +
                    "       {browse}\n" +
                    "   </div>\n" +
                    "   {caption}\n" +
                    "   <div class='input-group-append'>\n" +
                    "       {upload}\n" +
                    "       {remove}\n" +
                    "   </div>\n" +
                    "</div>",
                modal: modalTemplate
            },
            initialCaption: "No file selected",
            previewZoomButtonClasses: previewZoomButtonClasses,
            previewZoomButtonIcons: previewZoomButtonIcons,
            fileActionSettings: fileActionSettings
        });

        $('.file-input-extensions').fileinput({
            browseLabel: 'Browse',
            browseIcon: '<i class="icon-file-plus mr-2"></i>',
            uploadIcon: '<i class="icon-file-upload2 mr-2"></i>',
            removeIcon: '<i class="icon-cross2 font-size-base mr-2"></i>',
            layoutTemplates: { icon: '<i class="icon-file-check"></i>', modal: modalTemplate },
            maxFilesNum: 10,
            allowedFileExtensions: ["jpg", "gif", "png", "txt"],
            initialCaption: "No file selected",
            previewZoomButtonClasses: previewZoomButtonClasses,
            previewZoomButtonIcons: previewZoomButtonIcons,
            fileActionSettings: fileActionSettings
        });

        $('.file-input-preview').fileinput({
            browseLabel: 'Browse',
            browseIcon: '<i class="icon-file-plus mr-2"></i>',
            uploadIcon: '<i class="icon-file-upload2 mr-2"></i>',
            removeIcon: '<i class="icon-cross2 font-size-base mr-2"></i>',
            layoutTemplates: { icon: '<i class="icon-file-check"></i>', modal: modalTemplate },
            initialPreview: [ 'assets/images/demo/images/1.png' ],
            initialPreviewConfig: [ { caption: 'Jane.jpg', size: 930321, key: 1, url: '{$url}', showDrag: false } ],
            initialPreviewAsData: true,
            overwriteInitial: false,
            maxFileSize: 100,
            previewZoomButtonClasses: previewZoomButtonClasses,
            previewZoomButtonIcons: previewZoomButtonIcons,
            fileActionSettings: fileActionSettings
        });

        $('.file-input-ajax').fileinput({
            browseLabel: 'Browse',
            uploadUrl: "http://localhost", // server upload action
            uploadAsync: true,
            maxFileCount: 5,
            initialPreview: [],
            browseIcon: '<i class="icon-file-plus mr-2"></i>',
            uploadIcon: '<i class="icon-file-upload2 mr-2"></i>',
            removeIcon: '<i class="icon-cross2 font-size-base mr-2"></i>',
            fileActionSettings: {
                removeIcon: '<i class="icon-bin"></i>',
                uploadIcon: '<i class="icon-upload"></i>',
                uploadClass: '',
                zoomIcon: '<i class="icon-zoomin3"></i>',
                zoomClass: '',
                indicatorNew: '<i class="icon-file-plus text-success"></i>',
                indicatorSuccess: '<i class="icon-checkmark3 file-icon-large text-success"></i>',
                indicatorError: '<i class="icon-cross2 text-danger"></i>',
                indicatorLoading: '<i class="icon-spinner2 spinner text-muted"></i>',
            },
            layoutTemplates: { icon: '<i class="icon-file-check"></i>', modal: modalTemplate },
            initialCaption: 'No file selected',
            previewZoomButtonClasses: previewZoomButtonClasses,
            previewZoomButtonIcons: previewZoomButtonIcons
        });

        $('#btn-modify').on('click', function() {
            $btn = $(this);
            if ($btn.text() == 'Disable file input') {
                $('#file-input-methods').fileinput('disable');
                $btn.html('Enable file input');
                alert('Hurray! I have disabled the input and hidden the upload button.');
            }
            else {
                $('#file-input-methods').fileinput('enable');
                $btn.html('Disable file input');
                alert('Hurray! I have reverted back the input to enabled with the upload button.');
            }
        });
    };

    var _componentMultiselect = function() {
        if (!$().multiselect) {
            console.warn('Warning - bootstrap-multiselect.js is not loaded.');
            return;
        }

        $('.multiselect').multiselect();
        $('.multiselect-number').multiselect({ numberDisplayed: 1 });
        $('.multiselect-nonselected-text').multiselect({ nonSelectedText: 'Please choose' });
        $('.multiselect-select-all').multiselect({ includeSelectAllOption: true });
        $('.multiselect-filtering').multiselect({ enableFiltering: true, enableCaseInsensitiveFiltering: true });
        $('.multiselect-select-all-filtering').multiselect({ includeSelectAllOption: true, enableFiltering: true, enableCaseInsensitiveFiltering: true });
        $('.multiselect-link').multiselect({ buttonClass: 'btn btn-link' });
        $('.multiselect-clickable-groups').multiselect({ enableClickableOptGroups: true });
        $('.multiselect-disable-empty').multiselect({ disableIfEmpty: true });
        $('.multiselect-menu-bg-color').multiselect({
            templates: {
                ul: '<div class="multiselect-container bg-teal-400 dropdown-menu"></div>'
            }
        });

        // Combined colors
        $('.multiselect-combine-all').multiselect({
            buttonClass: 'btn bg-slate',
            templates: {
                ul: '<div class="multiselect-container bg-slate dropdown-menu"></div>'
            }
        });

        $('.multiselect-full-featured').multiselect({ includeSelectAllOption: true, enableFiltering: true });
        $('.multiselect-max-height').multiselect({ maxHeight: 200 });

        var $preventDeselectElement = $('.multiselect-prevent-deselect');
        $preventDeselectElement.multiselect({
            onChange: function(option, checked) {
                if (checked === false) {
                    $preventDeselectElement.multiselect('select', option.val());
                }
            }
        });

        $('.multiselect-no-active-class').multiselect({ selectedClass: null });
        $('.multiselect-onchange-notice').multiselect({
            onChange: function(element, checked){
                new PNotify({
                    text: '<code>onChange</code> callback fired.',
                    addclass: 'bg-teal border-teal'
                });
            }
        });

        $('.multiselect-onchange-desktop').multiselect({
            onChange:function(element, checked){
                PNotify.desktop.permission();
                (new PNotify({ title: 'Desktop Notice', text: 'onChange callback desktop notification.',
                    desktop: { desktop: true, addclass: 'bg-blue', icon: 'assets/images/pnotify/info.png' }
                })).get().on('click', function(e) {
                    if ($('.ui-pnotify-closer, .ui-pnotify-sticker, .ui-pnotify-closer *, .ui-pnotify-sticker *').is(e.target)) return;
                    alert('Hey! You clicked the desktop notification!');
                });
            }
        });

        $('.multiselect-show-event').multiselect({
            onDropdownShow: function() { new PNotify({ text: '<code>onDropdownShow</code> event fired.', addclass: 'bg-teal border-teal' }); }
        });

        $('.multiselect-hide-event').multiselect({
            onDropdownHide: function() { new PNotify({ text: '<code>onDropdownHide</code> event fired.', addclass: 'bg-teal border-teal' }); }
        });

        $('.multiselect-method-destroy').multiselect();
        $('.multiselect-destroy-button').on('click', function() {
            $('.multiselect-method-destroy').multiselect('destroy');
        });

        $('.multiselect-create-button').on('click', function() {
            $('.multiselect-method-destroy').multiselect();
        });

        $('.multiselect-method-refresh').multiselect();
        $('.multiselect-select-button').on('click', function() {

            $('option[value="tomatoes"]', $('.multiselect-method-refresh')).attr('selected', 'selected');
            $('option[value="tomatoes"]', $('.multiselect-method-refresh')).prop('selected', true);

            $('option[value="mushrooms"]', $('.multiselect-method-refresh')).prop('selected', true);
            $('option[value="mushrooms"]', $('.multiselect-method-refresh')).attr('selected', 'selected');

            $('option[value="onions"]', $('.multiselect-method-refresh')).prop('selected', true);
            $('option[value="onions"]', $('.multiselect-method-refresh')).attr('selected', 'selected');

            alert('Selected Tomatoes, Mushrooms and Onions.');
        });

        $('.multiselect-deselect-button').on('click', function() {
            $('option', $('.multiselect-method-refresh')).each(function(element) {
                $(this).removeAttr('selected').prop('selected', false);
            });
        });

        $('.multiselect-refresh-button').on('click', function() {
            $('.multiselect-method-refresh').multiselect('refresh');
        });

        $('.multiselect-method-rebuild').multiselect();

        $('.multiselect-add-button').on('click', function() {
            $('.multiselect-method-rebuild').append('<option value="add1">Addition 1</option><option value="add2">Addition 2</option><option value="add3">Addition 3</option>');
        });

        $('.multiselect-delete-button').on('click', function() {
            $('option[value="add1"]', $('.multiselect-method-rebuild')).remove();
            $('option[value="add2"]', $('.multiselect-method-rebuild')).remove();
            $('option[value="add3"]', $('.multiselect-method-rebuild')).remove();
        });

        $('.multiselect-rebuild-button').on('click', function() {
            $('.multiselect-method-rebuild').multiselect('rebuild');
        });

        $('.multiselect-method-select').multiselect();
        $('.multiselect-select-cheese-button').on('click', function() {
            $('.multiselect-method-select').multiselect('select', 'cheese');
        });

        $('.multiselect-select-onions-button').on('click', function() {
            $('.multiselect-method-select').multiselect('select', 'onions');
        });

        $('.multiselect-method-deselect').multiselect();
        $('.multiselect-deselect-cheese-button').on('click', function() {
            $('.multiselect-method-deselect').multiselect('deselect', 'cheese');
        });
        $('.multiselect-deselect-onions-button').on('click', function() {
            $('.multiselect-method-deselect').multiselect('deselect', 'onions');
        });

        $('.multiselect-method-disable').multiselect();

        $('.multiselect-enable1-button').on('click', function() {
            $('.multiselect-method-disable').multiselect('enable');
        });

        $('.multiselect-disable1-button').on('click', function() {
            $('.multiselect-method-disable').multiselect('disable');
        });

        $('.multiselect-method-enable').multiselect();

        $('.multiselect-enable2-button').on('click', function() {
            $('.multiselect-method-enable').multiselect('enable');
        });

        $('.multiselect-disable2-button').on('click', function() {
            $('.multiselect-method-enable').multiselect('disable');
        });

        $('.multiselect-simulate-selections').multiselect({
            onChange: function(option, checked) {
                var values = [];
                $('.multiselect-simulate-selections option').each(function() {
                    if ($(this).val() !== option.val()) {
                        values.push($(this).val());
                    }
                });

                $('.multiselect-simulate-selections').multiselect('deselect', values);
            }
        });

        $('.multiselect-close-dropdown').multiselect({
            onChange: function(option, checked) {
                var selected = 0;
                $('option', $('.multiselect-close-dropdown')).each(function() {
                    if ($(this).prop('selected')) {
                        selected++;
                    }
                });

                if (selected >= 3) {
                    $('.multiselect-close-dropdown').siblings('div').children('.dropdown-menu').dropdown('toggle');
                }
            }
        });

        $('.multiselect-templates').multiselect({ templates: { divider: '<div class="multiselect-item dropdown-divider border-danger"></div>' } });

        $('.multiselect-display-values').multiselect();

        $('.multiselect-display-values-select').on('click', function() {
            $('.multiselect-display-values').multiselect('select', 'cheese');
            $('.multiselect-display-values').multiselect('select', 'tomatoes');

            $('.values-area').addClass('alert alert-info').text('Selected: ' + $('.multiselect-display-values').val().join(', '));
        });

        $('.multiselect-display-values-deselect').on('click', function() {
            $('.multiselect-display-values').multiselect('deselect', 'cheese');
            $('.multiselect-display-values').multiselect('deselect', 'tomatoes');

            $('.values-area').addClass('alert alert-info').text('Selected: ' + $('.multiselect-display-values').val() > 0 ? $('.multiselect-display-values').val().join(', ') : 'Nothing selected');
        });

        function multiselect_selected($el) {
            var ret = true;
            $('option', $el).each(function(element) {
                if (!!!$(this).prop('selected')) {
                    ret = false;
                }
            });
            return ret;
        }
        function multiselect_selectAll($el) {
            $('option', $el).each(function(element) {
                $el.multiselect('select', $(this).val());
            });
        }
        function multiselect_deselectAll($el) {
            $('option', $el).each(function(element) {
                $el.multiselect('deselect', $(this).val());
            });
        }
        function multiselect_toggle($el, $btn) {
            if (multiselect_selected($el)) {
                multiselect_deselectAll($el);
                $btn.text('Select All');
            }
            else {
                multiselect_selectAll($el);
                $btn.text('Deselect All');
            }
        }

        $('.multiselect-toggle-selection').multiselect();

        $('.multiselect-toggle-selection-button').on('click', function(e) {
            e.preventDefault();
            multiselect_toggle($('.multiselect-toggle-selection'), $(this));
        });

        var orderCount = 0;

        $('.multiselect-order-options').multiselect({
            buttonText: function(options) {
                if (options.length == 0) {
                    return 'None selected';
                }
                else if (options.length > 3) {
                    return options.length + ' selected';
                } else {
                    var selected = [];
                    options.each(function() {
                        selected.push([$(this).text(), $(this).data('order')]);
                    });

                    selected.sort(function(a, b) {
                        return a[1] - b[1];
                    });

                    var text = '';
                    for (var i = 0; i < selected.length; i++) {
                        text += selected[i][0] + ', ';
                    }

                    return text.substr(0, text.length -2);
                }
            },
            onChange: function(option, checked) {
                if (checked) {
                    orderCount++;
                    $(option).data('order', orderCount);
                }
                else {
                    $(option).data('order', '');
                }
            }
        });

        $('.multiselect-order-options-button').on('click', function() {
            var selected = [];
            $('.multiselect-order-options option:selected').each(function() {
                selected.push([$(this).val(), $(this).data('order')]);
            });

            selected.sort(function(a, b) {
                return a[1] - b[1];
            });

            var text = '';
            for (var i = 0; i < selected.length; i++) {
                text += selected[i][0] + ', ';
            }
            text = text.substring(0, text.length - 2);

            alert(text);
        });

        $('.multiselect-reset').multiselect();

        $('#multiselect-reset-form').on('reset', function() {
            $('.multiselect-reset option:selected').each(function() {
                $(this).prop('selected', false);
            })

            $('.multiselect-reset').multiselect('refresh');
        });
    };

    var _componentUniform = function() {
        if (!$().uniform) {
            console.warn('Warning - uniform.min.js is not loaded.');
            return;
        }

        $('.form-check-input-styled').uniform();

        $('.form-input-styled').uniform({
            fileButtonClass: 'action btn bg-blue'
        });

        $('.form-input-styled').uniform({
            fileButtonClass: 'action btn bg-warning-400'
        });

        $('.form-check-input-styled-primary').uniform({
            wrapperClass: 'border-primary-600 text-primary-800'
        });

        $('.form-check-input-styled-danger').uniform({
            wrapperClass: 'border-danger-600 text-danger-800'
        });

        $('.form-check-input-styled-success').uniform({
            wrapperClass: 'border-success-600 text-success-800'
        });

        $('.form-check-input-styled-warning').uniform({
            wrapperClass: 'border-warning-600 text-warning-800'
        });

        $('.form-check-input-styled-info').uniform({
            wrapperClass: 'border-info-600 text-info-800'
        });

        $('.form-check-input-styled-custom').uniform({
            wrapperClass: 'border-indigo-600 text-indigo-800'
        });
    };

    var _componentSwitchery = function() {
        if (typeof Switchery == 'undefined') {
            console.warn('Warning - switchery.min.js is not loaded.');
            return;
        }

        var elems = Array.prototype.slice.call(document.querySelectorAll('.form-check-input-switchery'));
        elems.forEach(function(html) {
          var switchery = new Switchery(html);
        });

        var elems = Array.prototype.slice.call(document.querySelectorAll('.form-input-switchery'));
        elems.forEach(function(html) {
            var switchery = new Switchery(html);
        });
    };

    var _componentBootstrapSwitch = function() {
        if (!$().bootstrapSwitch) {
            console.warn('Warning - switch.min.js is not loaded.');
            return;
        }

        $('.form-check-input-switch').bootstrapSwitch();
        $('.form-input-switch').bootstrapSwitch({
            onSwitchChange: function(state) {
                if(state) {
                    $(this).valid(true);
                } else {
                    $(this).valid(false);
                }
            }
        });
    };
    
    var _componentTokenfield = function() {
        if (!$().tokenfield) {
            console.warn('Warning - tokenfield.min.js is not loaded.');
            return;
        }

        $('.tokenfield').tokenfield();
        $('.tokenfield-blur').tokenfield({ createTokensOnBlur: true });
        $('.tokenfield-delimiter').tokenfield({ delimiter: ';' });

        $('.tokenfield-primary').on('tokenfield:initialize', function (e) {
            $(this).parent().find('.token').addClass('bg-primary text-white');
        });

        $('.tokenfield-primary').tokenfield();
        $('.tokenfield-primary').on('tokenfield:createdtoken', function (e) {
            $(e.relatedTarget).addClass('bg-primary text-white');
        });

        $('.tokenfield-teal').on('tokenfield:initialize', function (e) {
            $(this).parent().find('.token').addClass('bg-teal text-white');
        });

        $('.tokenfield-teal').tokenfield();
        $('.tokenfield-teal').on('tokenfield:createdtoken', function (e) {
            $(e.relatedTarget).addClass('bg-teal text-white');
        });

        $('.tokenfield-success').on('tokenfield:initialize', function (e) {
            $(this).parent().addClass('border-success');
            $(this).parent().find('.token').addClass('bg-success text-white');
        });
        $('.tokenfield-success').tokenfield();
        $('.tokenfield-success').on('tokenfield:createdtoken', function (e) {
            $(e.relatedTarget).addClass('bg-success text-white');
        });

        $('.tokenfield-danger').on('tokenfield:initialize', function (e) {
            $(this).parent().addClass('border-danger');
            $(this).parent().find('.token').addClass('bg-danger text-white');
        });

        // Initialize plugin
        $('.tokenfield-danger').tokenfield();
        $('.tokenfield-danger').on('tokenfield:createdtoken', function (e) {
            $(e.relatedTarget).addClass('bg-danger text-white');
        });

        var engine = new Bloodhound({
            local: [
                {value: 'red'},
                {value: 'blue'},
                {value: 'green'} ,
                {value: 'yellow'},
                {value: 'violet'},
                {value: 'brown'},
                {value: 'purple'},
                {value: 'black'},
                {value: 'white'}
            ],
            datumTokenizer: function(d) {
                return Bloodhound.tokenizers.whitespace(d.value);
            },
            queryTokenizer: Bloodhound.tokenizers.whitespace
        });

        engine.initialize();

        $('.tokenfield-typeahead').tokenfield({ typeahead: [null, { displayKey: 'value', source: engine.ttAdapter() }] });
        var $touchspinContainer = $('.touchspin-postfix');

        $touchspinContainer.TouchSpin({ min: 0, max: 100, step: 0.1, decimals: 2, postfix: '%'});
        $touchspinContainer.on('touchspin.on.startspin', function() {
            $(this).trigger('blur');
        });

        $('#set-tokens').on('click', function() {
            $('#set-tokens-field').tokenfield('setTokens', ['blue','red','white']);
        });

        $('#get-tokens').on('click', function() {
            var tokens = $('#get-tokens-field').tokenfield('getTokensList');
            alert(tokens);
        });

        $('#create-token').on('click', function() {
            $('#create-token-field').tokenfield('createToken', { value: 'new', label: 'New token' });
        });

        $('.tokenfield-disable').tokenfield();

        $('#disable').on('click', function() {
            $('.tokenfield-disable').tokenfield('disable');
        });

        $('#enable').on('click', function() {
            $('.tokenfield-disable').tokenfield('enable');
        });

        $('.tokenfield-readonly').tokenfield();

        $('#readonly').on('click', function() {
            $('.tokenfield-readonly').tokenfield('readonly');
        });

        $('#writeable').on('click', function() {
            $('.tokenfield-readonly').tokenfield('writeable');
        });
        $('.tokenfield-destroy').tokenfield();

        $('#destroy').on('click', function() {
            $('.tokenfield-destroy').removeAttr('data-fouc').tokenfield('destroy');
        });

        $('#create').on('click', function() {
            $('.tokenfield-destroy').tokenfield();
        });
    };

    var _componentTagsinput = function() {
        if (!$().tagsinput) {
            console.warn('Warning - tagsinput.min.js is not loaded.');
            return;
        }

        $('.tags-input, [data-role="tagsinput"], .tagsinput-max-tags, .tagsinput-custom-tag-class').on('change', function(event) {
            var $element = $(event.target),
                $container = $element.parent().parent('.mb-3');

            if (!$element.data('tagsinput'))
            return;

            var val = $element.val();
            if (val === null)
            val = "null";
        
            $('pre.val > code', $container).html( ($.isArray(val) ? JSON.stringify(val) : "\"" + val.replace('"', '\\"') + "\"") );
            $('pre.items > code', $container).html(JSON.stringify($element.tagsinput('items')));
            Prism.highlightAll();
        }).trigger('change');

        $('.tags-input').tagsinput();
        $('.tags-input-dublicates').tagsinput({ allowDuplicates: true });
        $('.tagsinput-max-tags').tagsinput({ maxTags: 5 });
        $('.tagsinput-custom-tag-class').tagsinput({
            tagClass: function(item){
                return 'bg-success text-white';
            }
        });
    };

    var _componentFancybox = function() {
        if (!$().fancybox) {
            console.warn('Warning - fancybox.min.js is not loaded.');
            return;
        }

        $('[data-popup="lightbox"]').fancybox({ padding: 3 });
    };

    var _componentFootable = function() {
        if (!$().footable) {
            console.warn('Warning - footable.min.js is not loaded.');
            return;
        }

        $('.table-togglable').footable();
    };

    var _componentWizard = function() {
        if (!$().steps) {
            console.warn('Warning - steps.min.js is not loaded.');
            return;
        }

        $('.steps-basic').steps({
            headerTag: 'h6',
            bodyTag: 'fieldset',
            transitionEffect: 'fade',
            titleTemplate: '<span class="number">#index#</span> #title#',
            labels: {
                previous: '<i class="icon-arrow-left13 mr-2" /> Previous',
                next: 'Next <i class="icon-arrow-right14 ml-2" />',
                finish: 'Submit form <i class="icon-arrow-right14 ml-2" />'
            },
            onFinished: function (event, currentIndex) {
                alert('Form submitted.');
            }
        });

        $('.steps-async').steps({
            headerTag: 'h6',
            bodyTag: 'fieldset',
            transitionEffect: 'fade',
            titleTemplate: '<span class="number">#index#</span> #title#',
            loadingTemplate: '<div class="card-body text-center"><i class="icon-spinner2 spinner mr-2"></i>  #text#</div>',
            labels: {
                previous: '<i class="icon-arrow-left13 mr-2" /> Previous',
                next: 'Next <i class="icon-arrow-right14 ml-2" />',
                finish: 'Submit form <i class="icon-arrow-right14 ml-2" />'
            },
            onContentLoaded: function (event, currentIndex) {
                $(this).find('.card-body').addClass('hide');

                _componentSelect2();
                _componentUniform();
            },
            onFinished: function (event, currentIndex) {
                alert('Form submitted.');
            }
        });

        $('.steps-state-saving').steps({
            headerTag: 'h6',
            bodyTag: 'fieldset',
            titleTemplate: '<span class="number">#index#</span> #title#',
            labels: {
                previous: '<i class="icon-arrow-left13 mr-2" /> Previous',
                next: 'Next <i class="icon-arrow-right14 ml-2" />',
                finish: 'Submit form <i class="icon-arrow-right14 ml-2" />'
            },
            transitionEffect: 'fade',
            saveState: true,
            autoFocus: true,
            onFinished: function (event, currentIndex) { alert('Form submitted.'); }
        });

        $('.steps-starting-step').steps({
            headerTag: 'h6',
            bodyTag: 'fieldset',
            titleTemplate: '<span class="number">#index#</span> #title#',
            labels: {
                previous: '<i class="icon-arrow-left13 mr-2" /> Previous',
                next: 'Next <i class="icon-arrow-right14 ml-2" />',
                finish: 'Submit form <i class="icon-arrow-right14 ml-2" />'
            },
            transitionEffect: 'fade',
            startIndex: 2,
            autoFocus: true,
            onFinished: function (event, currentIndex) { alert('Form submitted.'); }
        });

        $('.steps-enable-all').steps({
            headerTag: 'h6',
            bodyTag: 'fieldset',
            transitionEffect: 'fade',
            enableAllSteps: true,
            titleTemplate: '<span class="number">#index#</span> #title#',
            labels: {
                previous: '<i class="icon-arrow-left13 mr-2" /> Previous',
                next: 'Next <i class="icon-arrow-right14 ml-2" />',
                finish: 'Submit form <i class="icon-arrow-right14 ml-2" />'
            },
            onFinished: function (event, currentIndex) {
                alert('Form submitted.');
            }
        });

        if (!$().validate) {
            console.warn('Warning - validate.min.js is not loaded.');
            return;
        }

        var form = $('.steps-validation').show();

        $('.steps-validation').steps({
            headerTag: 'h6',
            bodyTag: 'fieldset',
            titleTemplate: '<span class="number">#index#</span> #title#',
            labels: {
                previous: '<i class="icon-arrow-left13 mr-2" /> Previous',
                next: 'Next <i class="icon-arrow-right14 ml-2" />',
                finish: 'Submit form <i class="icon-arrow-right14 ml-2" />'
            },
            transitionEffect: 'fade',
            autoFocus: true,
            onStepChanging: function (event, currentIndex, newIndex) {
                if (currentIndex > newIndex) {
                    return true;
                }

                if (currentIndex < newIndex) {
                    form.find('.body:eq(' + newIndex + ') label.error').remove();
                    form.find('.body:eq(' + newIndex + ') .error').removeClass('error');
                }

                form.validate().settings.ignore = ':disabled,:hidden';
                return form.valid();
            },
            onFinishing: function (event, currentIndex) {
                form.validate().settings.ignore = ':disabled';
                return form.valid();
            },
            onFinished: function (event, currentIndex) {
                alert('Submitted!');
            }
        });

        $('.steps-validation').validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            highlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            errorPlacement: function(error, element) {
                if (element.parents().hasClass('form-check')) {
                    error.appendTo( element.parents('.form-check').parent() );
                } else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo( element.parent() );
                } else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo( element.parent().parent() );
                } else {
                    error.insertAfter(element);
                }
            },
            rules: {
                email: {
                    email: true
                }
            }
        });
    };

    var _componentDragula = function() {
        if (typeof dragula == 'undefined') {
            console.warn('Warning - dragula.min.js is not loaded.');
            return;
        }

        dragula([document.getElementById('cards-target-left'), document.getElementById('cards-target-right')]);
        dragula([document.getElementById('forms-target-left'), document.getElementById('forms-target-right')]);
        dragula([document.getElementById('media-list-target-left'), document.getElementById('media-list-target-right')], {
            mirrorContainer: document.querySelector('.media-list-container'),
            moves: function (el, container, handle) {
                return handle.classList.contains('dragula-handle');
            }
        });

        var containers = $('.dropdown-menu-sortable').toArray();
        dragula(containers, {
            mirrorContainer: document.querySelector('.dropdown-menu-sortable')
        });

        dragula([document.getElementById('tabs-target-left')], {
            mirrorContainer: document.querySelector('#tabs-target-left')
        });

        dragula([document.getElementById('tabs-target-right')], {
            mirrorContainer: document.querySelector('#tabs-target-right')
        });

        dragula([document.getElementById('tabs-solid-target-left')], {
            mirrorContainer: document.querySelector('#tabs-solid-target-left')
        });

        dragula([document.getElementById('tabs-solid-target-right')], {
            mirrorContainer: document.querySelector('#tabs-solid-target-right')
        });

        dragula([document.getElementById('pills-target-left')], {
            mirrorContainer: document.querySelector('#pills-target-left')
        });

        dragula([document.getElementById('pills-target-right')], {
            mirrorContainer: document.querySelector('#pills-target-right')
        });

        dragula([document.getElementById('pills-toolbar-target-left')], {
            mirrorContainer: document.querySelector('#pills-toolbar-target-left')
        });

        dragula([document.getElementById('pills-toolbar-target-right')], {
            mirrorContainer: document.querySelector('#pills-toolbar-target-right')
        });

        dragula([document.getElementById('accordion-target')], {
            mirrorContainer: document.getElementById('accordion-target')
        });

        dragula([document.getElementById('collapsible-target')], {
            mirrorContainer: document.getElementById('collapsible-target')
        });
    };

    var _componentTouchspin = function() {
        if (!$().TouchSpin) {
            console.warn('Warning - touchspin.min.js is not loaded.');
            return;
        }

        var $touchspinContainer = $('.touchspin-postfix');
        $touchspinContainer.TouchSpin({ min: 0, max: 100, step: 0.1, decimals: 2, postfix: '%' });

        // Trigger value change when +/- buttons are clicked
        $touchspinContainer.on('touchspin.on.startspin', function() {
            $(this).trigger('blur');
        });
    };

    var _componentSelect2 = function() {
        if (!$().select2) {
            console.warn('Warning - select2.min.js is not loaded.');
            return;
        }

        $('.form-control-select2').select2();
        var $select = $('.form-control-select2').select2({ minimumResultsForSearch: Infinity,  width: '100%' });

        $select.on('change', function() {
            $(this).trigger('blur');
        });

        $('.select').select2({ minimumResultsForSearch: Infinity });
        $('.select-search').select2();
        $('.select-fixed-single').select2({ minimumResultsForSearch: Infinity, width: 250 });
        $('.select-fixed-multiple').select2({ minimumResultsForSearch: Infinity, width: 400 });
        $('.select-minimum').select2({ minimumInputLength: 2, minimumResultsForSearch: Infinity });
        $('.select-clear').select2({ placeholder: 'Select a State', allowClear: true });
        $('.select-multiple-tags').select2({ tags: true });
        $('.select-multiple-maximum-length').select2({ tags: true, maximumInputLength: 5 });

        $('.select-multiple-drag').select2({
            containerCssClass: 'sortable-target'
        });

        function iconFormat(icon) {
            var originalOption = icon.element;
            if (!icon.id) { return icon.text; }
            var $icon = '<i class="icon-' + $(icon.element).data('icon') + '"></i>' + icon.text;

            return $icon;
        }

        $('.select-icons').select2({ templateResult: iconFormat, minimumResultsForSearch: Infinity, templateSelection: iconFormat, escapeMarkup: function(m) { return m; } });

        function matchStart (term, text) {
            if (text.toUpperCase().indexOf(term.toUpperCase()) == 0) {
                return true;
            }

            return false;
        }

        $.fn.select2.amd.require(['select2/compat/matcher'], function (oldMatcher) {
            $('.select-matched-customize').select2({
                minimumResultsForSearch: Infinity,
                placeholder: 'Select a State',
                matcher: oldMatcher(matchStart)
            });
        });

        $('.select-access-value').select2({
            minimumResultsForSearch: Infinity,
            placeholder: 'Select State...'
        });
        $('.access-get').on('click', function () { alert('Selected value is: '+$('.select-access-value').val()); });
        $('.access-set').on('click', function () { $('.select-access-value').val('CA').trigger('change'); });

        $('.select-access-open').select2({
            minimumResultsForSearch: Infinity,
            placeholder: 'Select State...'
        });
        $('.access-open').on('click', function () { $('.select-access-open').select2('open'); });
        $('.access-close').on('click', function () { $('.select-access-open').select2('close'); });

        $('.select-access-enable').select2({
            minimumResultsForSearch: Infinity,
            placeholder: 'Select State...'
        });
        $('.access-disable').on('click', function () { $('.select-access-enable').prop('disabled', true); });
        $('.access-enable').on('click', function () { $('.select-access-enable').prop('disabled', false); });

        function create_menu() {
            $('.select-access-create').select2({
                minimumResultsForSearch: Infinity,
                placeholder: 'Select State...'
            });
        }
        create_menu();
        $('.access-create').on('click', function () { return create_menu()});
        $('.access-destroy').on('click', function () { $('.select-access-create').select2('destroy'); });

        $('.select-access-multiple-value').select2();
        $('.change-to-ca').on('click', function() { $('.select-access-multiple-value').val('CA').trigger('change'); });
        $('.change-to-ak-co').on('click', function() { $('.select-access-multiple-value').val(['AK','CO']).trigger('change'); });

        $('.select-access-multiple-open').select2({
            minimumResultsForSearch: Infinity
        });
        $('.access-multiple-open').on('click', function () { $('.select-access-multiple-open').select2('open'); });
        $('.access-multiple-close').on('click', function () { $('.select-access-multiple-open').select2('close'); });

        $('.select-access-multiple-enable').select2({
            minimumResultsForSearch: Infinity
        });
        $('.access-multiple-disable').on('click', function () { $('.select-access-multiple-enable').prop('disabled', true); });
        $('.access-multiple-enable').on('click', function () { $('.select-access-multiple-enable').prop('disabled', false); });

        function create_menu_multiple() {
            $('.select-access-multiple-create').select2({
                minimumResultsForSearch: Infinity
            });
        }
        create_menu_multiple();
        $('.access-multiple-create').on('click', function () { return create_menu_multiple()});
        $('.access-multiple-destroy').on('click', function () { $('.select-access-multiple-create').select2('destroy'); });

        $('.select-access-multiple-clear').select2({
            minimumResultsForSearch: Infinity
        });
        $('.access-multiple-clear').on('click', function () { $('.select-access-multiple-clear').val(null).trigger('change'); });

    };

    var _componentValidation = function() {
        if (!$().validate) {
            console.warn('Warning - validate.min.js is not loaded.');
            return;
        }
    };

    var _componentSticky = function() {
        if (!$().stick_in_parent) {
            console.warn('Warning - sticky.min.js is not loaded.');
            return;
        }

        $('.sidebar-sticky .sidebar').stick_in_parent({
            offset_top: 60,
            parent: '.content'
        });

        $('.sidebar-mobile-component-toggle').on('click', function() {
            $('.sidebar-sticky .sidebar').trigger("sticky_kit:detach");
        });
    };

    var _componentUiSortable = function() {
        if (!$().sortable) {
            console.warn('Warning - jQuery UI components are not loaded.');
            return;
        }

        $('#sortable-list-basic').sortable();
        $('#sortable-list-basic').disableSelection();

        $('#sortable-list-placeholder').sortable({
            placeholder: 'sortable-placeholder',
        });
        $('#sortable-list-placeholder').disableSelection();

        $('#sortable-list-first, #sortable-list-second').sortable({
            connectWith: '.selectable-demo-connected'
        }).disableSelection();

        $('#sortable-list-specify').sortable({
            items: 'li:not(.ui-handle-excluded)'
        });

        $('#sortable-list-cancel').sortable({
            cancel: '.ui-handle-excluded'
        });

        $('#sortable-list-specify li, #sortable-list-cancel li').disableSelection();
    };

    var _componentProgress = function() {
        if (!$().progressbar) {
            console.warn('Warning - progressbar.min.js is not loaded.');
            return;
        }

        $('#h-default-basic-start').on('click', function() {
            var $pb = $('#h-default-basic .progress-bar');
            $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
            $pb.progressbar();
        });

        $('#h-default-basic-reset').on('click', function() {
            $('#h-default-basic .progress-bar').attr('data-transitiongoal', 0).progressbar();
        });

        $('#h-right-basic-start').on('click', function() {
            var $pb = $('#h-right-basic .progress-bar');
            $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
            $pb.progressbar();
        });

        $('#h-right-basic-reset').on('click', function() {
            $('#h-right-basic .progress-bar').attr('data-transitiongoal', 0).progressbar();
        });

        $('#h-fill-basic-start').on('click', function() {
            var $pb = $('#h-fill-basic .progress-bar');
            $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
            $pb.progressbar({display_text: 'fill'});
        });

        $('#h-fill-basic-reset').on('click', function() {
            $('#h-fill-basic .progress-bar').attr('data-transitiongoal', 0).progressbar({display_text: 'fill'});
        });

        $('#h-fill-basic-right-start').on('click', function() {
            var $pb = $('#h-fill-basic-right .progress-bar');
            $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
            $pb.progressbar({display_text: 'fill'});
        });

        $('#h-fill-basic-right-reset').on('click', function() {
            $('#h-fill-basic-right .progress-bar').attr('data-transitiongoal', 0).progressbar({display_text: 'fill'});
        });

        $('#h-fill-nonpercentage-basic-start').on('click', function() {
            var $pb = $('#h-fill-nonpercentage-basic .progress-bar');
            $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
            $pb.progressbar({display_text: 'fill', use_percentage: false});
        });

        $('#h-fill-nonpercentage-basic-reset').on('click', function() {
            $('#h-fill-nonpercentage-basic .progress-bar').attr('data-transitiongoal', 0).progressbar({display_text: 'fill', use_percentage: false});
        });

        $('#h-fill-nonpercentage-right-basic-start').on('click', function() {
            var $pb = $('#h-fill-nonpercentage-right-basic .progress-bar');
            $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
            $pb.progressbar({display_text: 'fill', use_percentage: false});
        });

        $('#h-fill-nonpercentage-right-basic-reset').on('click', function() {
            $('#h-fill-nonpercentage-right-basic .progress-bar').attr('data-transitiongoal', 0).progressbar({display_text: 'fill', use_percentage: false});
        });

        $('#v-default-basic-start').on('click', function() {
            $('#v-default-basic .progress-bar').each(function () {
                var $pb = $(this);
                $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
                $pb.progressbar();
            });
        });

        $('#v-default-basic-reset').on('click', function() {
            $('#v-default-basic .progress-bar').attr('data-transitiongoal', 0).progressbar();
        });

        $('#v-bottom-basic-start').on('click', function() {
            $('#v-bottom-basic .progress-bar').each(function () {
                var $pb = $(this);
                $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
                $pb.progressbar();
            });
        });

        $('#v-bottom-basic-reset').on('click', function() {
            $('#v-bottom-basic .progress-bar').attr('data-transitiongoal', 0).progressbar();
        });

        $('#v-fill-basic-start').on('click', function() {
            $('#v-fill-basic .progress-bar').each(function () {
                var $pb = $(this);
                $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
                $pb.progressbar({display_text: 'fill'});
            });
        });

        $('#v-fill-basic-reset').on('click', function() {
            $('#v-fill-basic .progress-bar').attr('data-transitiongoal', 0).progressbar();
        });

        $('#v-fill-bottom-start').on('click', function() {
            $('#v-fill-bottom .progress-bar').each(function () {
                var $pb = $(this);
                $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
                $pb.progressbar({display_text: 'fill'});
            });
        });

        $('#v-fill-bottom-reset').on('click', function() {
            $('#v-fill-bottom .progress-bar').attr('data-transitiongoal', 0).progressbar();
        });

        $('#v-fill-nonpercentage-basic-start').on('click', function() {
            $('#v-fill-nonpercentage-basic .progress-bar').each(function () {
                var $pb = $(this);
                $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
                $pb.progressbar({display_text: 'fill', use_percentage: false});
            });
        });

        $('#v-fill-nonpercentage-basic-reset').on('click', function() {
            $('#v-fill-nonpercentage-basic .progress-bar').attr('data-transitiongoal', 0).progressbar();
        });

        $('#v-fill-nonpercentage-bottom-start').on('click', function() {
            $('#v-fill-nonpercentage-bottom .progress-bar').each(function () {
                var $pb = $(this);
                $pb.attr('data-transitiongoal', $pb.attr('data-transitiongoal-backup'));
                $pb.progressbar({display_text: 'fill', use_percentage: false});
            });
        });

        $('#v-fill-nonpercentage-bottom-reset').on('click', function() {
            $('#v-fill-nonpercentage-bottom .progress-bar').attr('data-transitiongoal', 0).progressbar();
        });
    };

    var _componentInputFormatter = function() {
        if (!$().formatter) {
            console.warn('Warning - formatter.min.js is not loaded.');
            return;
        }

        $('[name="format-date"]').formatter({ pattern: '{{99}}/{{99}}/{{9999}}' });
        $('[name="format-credit-card"]').formatter({ pattern: '{{9999}} - {{9999}} - {{9999}} - {{9999}}' });
        $('.format-phone-number').formatter({ pattern: '({{999}}) {{999}} - {{9999}}' });
        $('[name="format-phone-ext"]').formatter({ pattern: '({{999}}) {{999}} - {{9999}} / {{a999}}' });
        $('[name="format-currency"]').formatter({ pattern: '${{999}}.{{99}}' });
        $('[name="format-international-phone"]').formatter({ pattern: '+3{{9}} {{999}} {{999}} {{999}}' });
        $('[name="format-tax-id"]').formatter({ pattern: '{{99}} - {{9999999}}' });
        $('[name="format-ssn"]').formatter({ pattern: '{{999}} - {{99}} - {{9999}}' });
        $('[name="format-product-key"]').formatter({ pattern: '{{a*}} - {{999}} - {{a999}}' });
        $('[name="format-order-number"]').formatter({ pattern: '{{aaa}} - {{999}} - {{***}}' });
        $('[name="format-isbn"]').formatter({ pattern: '{{999}} - {{99}} - {{999}} - {{9999}} - {{9}}' });
        $('[name="format-persistent"]').formatter({ pattern: '+3 ({{999}}) {{999}} - {{99}} - {{99}}' });
    };

    var _componentAutosize = function() {
        if (typeof autosize == 'undefined') {
            console.warn('Warning - autosize.min.js is not loaded.');
            return;
        }

        // Basic example
        autosize($('.elastic'));

        // Manual trigger
        $('.elastic-manual-trigger').on('click', function() {
            var manual = autosize($('.elastic-manual'));
            $('.elastic-manual').val('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed ultricies nibh, sed faucibus eros. Vivamus tristique fringilla ante, vitae pellentesque quam porta vel. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nunc vehicula gravida nisl non imperdiet. Mauris felis odio, vehicula et laoreet non, tempor non enim. Cras convallis sapien hendrerit nibh sagittis sollicitudin. Fusce nec ultricies justo. Interdum et malesuada fames ac ante ipsum primis in faucibus. Fusce ac urna in dui consequat cursus vel sit amet mauris. Proin nec bibendum arcu. Aenean sit amet nisi mi. Sed non leo nisl. Mauris leo odio, ultricies interdum ornare ac, posuere eu risus. Suspendisse adipiscing sapien sit amet gravida sollicitudin. Maecenas laoreet velit in dui adipiscing, vel fermentum tellus ullamcorper. Nullam et mi rhoncus, tempus nulla sit amet, varius ipsum.');
            autosize.update(manual);
        });

        // Destroy method
        var destroyAutosize = autosize($('.elastic-destroy'));
        $('.elastic-destroy-trigger').on('click', function() {
            autosize.destroy(destroyAutosize);
        });
    };

    var _componentPassy = function() {
        if (!$().passy) {
            console.warn('Warning - passy.js is not loaded.');
            return;
        }

        var $inputLabel = $('.badge-indicator input');
        var $inputLabelAbsolute = $('.badge-indicator-absolute input');
        var $inputGroup = $('.group-indicator input');

        var $outputLabel = $('.badge-indicator > span');
        var $outputLabelAbsolute = $('.badge-indicator-absolute > span');
        var $outputGroup = $('.group-indicator .input-group-text');

        var $inputGroupMaterial = $('.group-indicator-material input');
        var $outputGroupMaterial = $('.group-indicator-material .input-group-text');

        $.passy.requirements.length.min = 4;

        var feedback = [
            {color: '#D55757', text: 'Weak', textColor: '#fff'},
            {color: '#EB7F5E', text: 'Normal', textColor: '#fff'},
            {color: '#3BA4CE', text: 'Good', textColor: '#fff'},
            {color: '#40B381', text: 'Strong', textColor: '#fff'}
        ];

        $inputLabel.passy(function(strength) {
            $outputLabel.text(feedback[strength].text);
            $outputLabel.css({ 'display': 'block', 'background-color': feedback[strength].color, 'color': feedback[strength].textColor });
        });

        $inputLabelAbsolute.passy(function(strength) {
            $outputLabelAbsolute.text(feedback[strength].text);
            $outputLabelAbsolute.css({ 'background-color': feedback[strength].color,  'color': feedback[strength].textColor });
        });

        $inputGroup.passy(function(strength) {
            $outputGroup.text(feedback[strength].text);
            $outputGroup.css({ 'background-color': feedback[strength].color, 'border-color': feedback[strength].color, 'color': feedback[strength].textColor });
        });

        $inputGroupMaterial.passy(function(strength) {
            $outputGroupMaterial.text(feedback[strength].text);
            $outputGroupMaterial.css({ 'color': feedback[strength].color });
        });


        $('.generate-group').on('click', function() {
            $inputGroup.passy('generate', 16);
        });
        $('.generate-group-material').on('click', function() {
            $inputGroupMaterial.passy('generate', 16);
        });
    };

    var _componentMaxlength = function() {
        if (!$().maxlength) {
            console.warn('Warning - maxlength.min.js is not loaded.');
            return;
        }

        $('.maxlength').maxlength();
        $('.maxlength-threshold').maxlength({ threshold: 15 });
        $('.maxlength-custom').maxlength({ threshold: 10, warningClass: 'badge badge-primary form-text', limitReachedClass: 'badge badge-danger form-text' });

        $('.maxlength-options').maxlength({ alwaysShow: true, threshold: 10, warningClass: 'text-success form-text', limitReachedClass: 'text-danger form-text',
            separator: ' of ', preText: 'You have ', postText: ' chars remaining.', validate: true
        });

        $('.maxlength-textarea').maxlength({ alwaysShow: true });
        $('.maxlength-badge-position').maxlength({ alwaysShow: true, placement: 'top' });
    };

    var _componentDaterange = function() {
        if (!$().daterangepicker) {
            console.warn('Warning - daterangepicker.js is not loaded.');
            return;
        }

        $('.daterange-basic').daterangepicker({ applyClass: 'bg-slate-600', cancelClass: 'btn-light'});
        $('.daterange-weeknumbers').daterangepicker({ showWeekNumbers: true, applyClass: 'bg-slate-600', cancelClass: 'btn-light'});
        $('.daterange-buttons').daterangepicker({ applyClass: 'btn-success', cancelClass: 'btn-danger' });
        $('.daterange-time').daterangepicker({ timePicker: true, applyClass: 'bg-slate-600', cancelClass: 'btn-light', locale: { format: 'MM/DD/YYYY h:mm a' } });
        $('.daterange-left').daterangepicker({ opens: 'left', applyClass: 'bg-slate-600', cancelClass: 'btn-light' });
        $('.daterange-single').daterangepicker({ singleDatePicker: true });
        $('.daterange-datemenu').daterangepicker({ showDropdowns: true, opens: 'left', applyClass: 'bg-slate-600', cancelClass: 'btn-light' });

        $('.daterange-increments').daterangepicker({ timePicker: true, opens: 'left', applyClass: 'bg-slate-600', cancelClass: 'btn-light', timePickerIncrement: 10, locale: { format: 'MM/DD/YYYY h:mm a' } });

        $('.daterange-locale').daterangepicker({ applyClass: 'bg-slate-600', cancelClass: 'btn-light', opens: 'left',
            ranges: {
                'Сегодня': [moment(), moment()],
                'Вчера': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Последние 7 дней': [moment().subtract(6, 'days'), moment()],
                'Последние 30 дней': [moment().subtract(29, 'days'), moment()],
                'Этот месяц': [moment().startOf('month'), moment().endOf('month')],
                'Прошедший месяц': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
            locale: {
                applyLabel: 'Вперед',
                cancelLabel: 'Отмена',
                startLabel: 'Начальная дата',
                endLabel: 'Конечная дата',
                customRangeLabel: 'Выбрать дату',
                daysOfWeek: ['Вс', 'Пн', 'Вт', 'Ср', 'Чт', 'Пт','Сб'],
                monthNames: ['Январь', 'Февраль', 'Март', 'Апрель', 'Май', 'Июнь', 'Июль', 'Август', 'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь'],
                firstDay: 1
            }
        });

        $('.daterange-predefined').daterangepicker({
                startDate: moment().subtract(29, 'days'),
                endDate: moment(),
                minDate: '01/01/2014',
                maxDate: '12/31/2019',
                dateLimit: { days: 60 },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                opens: 'left',
                applyClass: 'btn-sm bg-slate',
                cancelClass: 'btn-sm btn-light'
            },
            function(start, end) {
                $('.daterange-predefined span').html(start.format('MMMM D, YYYY') + ' &nbsp; - &nbsp; ' + end.format('MMMM D, YYYY'));
                $.jGrowl('Date range has been changed', { header: 'Update', theme: 'bg-primary', position: 'center', life: 1500 });
            }
        );

        $('.daterange-predefined span').html(moment().subtract(29, 'days').format('MMMM D, YYYY') + ' &nbsp; - &nbsp; ' + moment().format('MMMM D, YYYY'));

        $('.daterange-ranges').daterangepicker({
                startDate: moment().subtract(29, 'days'),
                endDate: moment(),
                minDate: '01/01/2012',
                maxDate: '12/31/2019',
                dateLimit: { days: 60 },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                opens: 'left',
                applyClass: 'btn-sm bg-slate-600',
                cancelClass: 'btn-sm btn-light'
            }, function(start, end) {
                $('.daterange-ranges span').html(start.format('MMMM D, YYYY') + ' &nbsp; - &nbsp; ' + end.format('MMMM D, YYYY'));
            }
        );

        $('.daterange-ranges span').html(moment().subtract(29, 'days').format('MMMM D, YYYY') + ' &nbsp; - &nbsp; ' + moment().format('MMMM D, YYYY'));
    };

    var _componentPickadate = function() {
        if (!$().pickadate) {
            console.warn('Warning - picker.js and/or picker.date.js is not loaded.');
            return;
        }

        $('.pickadate').pickadate();
        $('.pickadate-strings').pickadate({ weekdaysShort: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'], showMonthsShort: true});
        $('.pickadate-buttons').pickadate({ today: '', close: '', clear: 'Clear selection'});

        $('.pickadate-accessibility').pickadate({
            labelMonthNext: 'Go to the next month',
            labelMonthPrev: 'Go to the previous month',
            labelMonthSelect: 'Pick a month from the dropdown',
            labelYearSelect: 'Pick a year from the dropdown',
            selectMonths: true,
            selectYears: true
        });

        $('.pickadate-translated').pickadate({
            monthsFull: ['Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'],
            weekdaysShort: ['Dim', 'Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam'],
            today: 'aujourd\'hui',
            clear: 'effacer',
            formatSubmit: 'yyyy/mm/dd'
        });

        $('.pickadate-format').pickadate({ format: 'You selecte!d: dddd, dd mmm, yyyy', formatSubmit: 'yyyy/mm/dd', hiddenPrefix: 'prefix__', hiddenSuffix: '__suffix'});

        var $input_date = $('.pickadate-editable').pickadate({
            editable: true,
            onClose: function() {
                $('.datepicker').focus();
            }
        });

        var picker_date = $input_date.pickadate('picker');
        $input_date.on('click', function(event) {
            if (picker_date.get('open')) {
                picker_date.close();
            } else {
                picker_date.open();
            }
            event.stopPropagation();
        });

        $('.pickadate-selectors').pickadate({ selectYears: true, selectMonths: true});
        $('.pickadate-year').pickadate({ selectYears: 4 });
        $('.pickadate-weekday').pickadate({ firstDay: 1 });
    };

    var _componentPickatime = function() {
        if (!$().pickatime) {
            console.warn('Warning - picker.js and/or picker.time.js is not loaded.');
            return;
        }

        $('.pickatime').pickatime();
        $('.pickatime-clear').pickatime({ clear: '' });
        $('.pickatime-format').pickatime({ format: 'T!ime selected: h:i a', formatLabel: '<b>h</b>:i <!i>a</!i>', formatSubmit: 'HH:i', hiddenPrefix: 'prefix__', hiddenSuffix: '__suffix'});
        $('.pickatime-hidden').pickatime({ formatSubmit: 'HH:i', hiddenName: true });
        $('.pickatime-intervals').pickatime({ interval: 150 });
    };

    var _componentAnytime = function() {
        if (!$().AnyTime_picker) {
            console.warn('Warning - anytime.min.js is not loaded.');
            return;
        }

        $('#anytime-date').AnyTime_picker({ format: '%W, %M %D in the Year %z %E', firstDOW: 1});
        $('#anytime-time').AnyTime_picker({ format: '%H:%i' });
        $('#anytime-time-hours').AnyTime_picker({ format: '%l %p' });
        $('#anytime-both').AnyTime_picker({ format: '%M %D %H:%i' });
        $('#anytime-weekday').AnyTime_picker({ format: '%W, %D of %M, %Z' });
        $('#anytime-month-numeric').AnyTime_picker({ format: '%d/%m/%Z' });
        $('#anytime-month-day').AnyTime_picker({ format: '%D of %M' });

        $('#ButtonCreationDemoButton').on('click', function (e) {
            $('#ButtonCreationDemoInput').AnyTime_noPicker().AnyTime_picker().focus();
            e.preventDefault();
        });


        var oneDay = 24*60*60*1000;
        var rangeDemoFormat = '%e-%b-%Y';
        var rangeDemoConv = new AnyTime.Converter({format:rangeDemoFormat});

        $('#rangeDemoToday').on('click', function (e) {
            $('#rangeDemoStart').val(rangeDemoConv.format(new Date())).trigger('change');
        });

        $('#rangeDemoClear').on('click', function (e) {
            $('#rangeDemoStart').val('').trigger('change');
        });

        $('#rangeDemoStart').AnyTime_picker({ format: rangeDemoFormat });

        $('#rangeDemoStart').on('change', function(e) {
            try {
                var fromDay = rangeDemoConv.parse($('#rangeDemoStart').val()).getTime();
                var dayLater = new Date(fromDay+oneDay);
                dayLater.setHours(0,0,0,0);

                var ninetyDaysLater = new Date(fromDay+(90*oneDay));
                ninetyDaysLater.setHours(23,59,59,999);

                $('#rangeDemoFinish').AnyTime_noPicker().removeAttr('disabled').val(rangeDemoConv.format(dayLater)).AnyTime_picker({
                    earliest: dayLater,
                    format: rangeDemoFormat,
                    latest: ninetyDaysLater
                });
            } catch(e) {
                $('#rangeDemoFinish').val('').attr('disabled', 'disabled');
            }
        });
    };

    return {
        initBeforeLoad: function() {
            _transitionsDisabled();
        },
        initAfterLoad: function() {
            _transitionsEnabled();
        },

        initSidebars: function() {
            _sidebarMainResize();
            _sidebarMainToggle();
            _sidebarSecondaryToggle();
            _sidebarRightMainHide();
            _sidebarRightToggle();
            _sidebarRightSecondaryToggle();
            _sidebarComponentToggle();

            _sidebarMobileFullscreen();
            _sidebarMobileMainToggle();
            _sidebarMobileSecondaryToggle();
            _sidebarMobileRightToggle();
            _sidebarMobileComponentToggle();
        },

        initNavigations: function() {
            _navigationSidebar();
            _navigationNavbar();
        },

        initComponents: function() {
            _componentTooltip();
            _componentPopover();
            _componentMultiselect();
            _componentUniform();
            _componentSwitchery();
            _componentBootstrapSwitch();
            _componentTokenfield();
            _componentTagsinput();
            _componentFancybox();
            _componentSticky();
            _componentUiSortable();
            _componentProgress();
            _componentInputFormatter();
            _componentAutosize();
            _componentPassy();
            _componentMaxlength();
            _componentDaterange();
            _componentPickadate();
            _componentPickatime();
            _componentAnytime();

        },
        initCardActions: function() {
            _cardActionReload();
            _cardActionCollapse();
            _cardActionRemove();
            _cardActionFullscreen();
        },
        initDropdownSubmenu: function() {
            _dropdownSubmenu();
        },
        initHeaderElementsToggle: function() {
            _headerElements();
        },
        initNoty: function() {
            _componentNoty();
        },
        initFileUpload: function() {
            _componentFileUpload();
        },
        initTableFootable: function () {
            _componentFootable();
        },
        initSelect2Selects: function() {
            _componentSelect2();
        },
        initDragAndDrop: function() {
            _componentDragula();
        },
        initFormWizard: function() {
            _componentWizard();
        },
        initFormValidation: function() {
            _componentTouchspin();
            _componentValidation();
        },

        initCore: function() {
            App.initSidebars();
            App.initNavigations();
            App.initComponents();
            App.initCardActions();
            App.initDropdownSubmenu();
            App.initHeaderElementsToggle();
            App.initNoty();
            App.initFileUpload();
            App.initTableFootable();
            App.initFormWizard();
            App.initSelect2Selects();
            App.initDragAndDrop();
            App.initFormValidation();

        }
    }
}();

// Когда контент загружен
document.addEventListener('DOMContentLoaded', function() {
    App.initBeforeLoad();
    App.initCore();
});

// Когда страница полностью загружена
window.addEventListener('load', function() {
    App.initAfterLoad();
});
