<form method="post" enctype="multipart/form-data" class="form-content-wrapper">

    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>
                    <a class="btn btn-sm btn-light" href="index.php?mod=bannerimages">{general:cancel}</a>
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="index.php?mod=bannerimages" class="breadcrumb-item">{$title}</a>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center"></div>
    		</div>
    	</div>
    </div>

    <div class="content">
        <div class="row"> 
            <div class="col-md-8">
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
        			</div>
                    <div class="card-body">
        			    <div class="row">
            			    <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.title)}text-danger{/if}">{sliders:general:title}</label>
                                    <input type="text" class="form-control" autocomplete="off" name="banner[title]" value="{if isset($banner->title)}{$banner->title}{/if}" />
                                </div>
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">{sliders:text}</label>
                                    <input type="text" class="form-control" autocomplete="off" name="banner[text]" value="{if isset($banner->text)}{$banner->text}{/if}" />
                                </div>
            			    </div>
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">{sliders:alias}</label>
                                    <input type="text" class="form-control" autocomplete="off" name="banner[alias]" value="{if isset($banner->alias)}{$banner->alias}{/if}" />
                                </div>
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">{sliders:links}</label>
                                    <input type="text" class="form-control" autocomplete="off" name="banner[url]" value="{if isset($banner->url)}{$banner->url}{/if}" />
                                </div>
            			    </div>
                        </div> 
                    </div>
    		    </div>
	            <div class="card">
		            <div class="card-header bg-transparent header-elements-inline">
			            <h6 class="card-title">{general:card:description}</h6>
			            <div class="header-elements">
				            <div class="list-icons">
					            <a class="list-icons-item" data-action="collapse"></a>
				            </div>
			            </div>
		            </div>
		            <div class="card-body flex-column flex-md-row m-0 p-0">
			            <textarea id="description" name="banner[summary]" class="description">{if isset($banner->summary)}{$banner->summary}{/if}</textarea>
		            </div>
	            </div>

                <div class="col-md-12 main main_buttons text-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>&nbsp;
                    <a class="btn btn-sm btn-light" href="index.php?mod=bannerimages">{general:cancel}</a>
                </div>
            
            </div>

            <div class="col-md-4">
        		{* STATUS *}
                <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:statusAndVisibility}</h6>
    					<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
    				</div>
	                <div class="card-body border-top-0">
		                <div class="form-group form-group-float">
			                <label class="form-group-float-label is-visible {if isset($errors.group)}text-danger{/if}">Группа баннеров</label>
                            {if isset($banner->groupId)}
                                {html_options options=$groups name="banner[groupId]" selected=$banner->groupId class="form-control select"}
                            {else}
                                {html_options options=$groups name="banner[groupId]" class="form-control select"}
                            {/if}
		                </div>
	                </div>
    				<div class="card-body border-top-0">
                        <div class="form-group form-group-float">
                			<label class="form-group-float-label is-visible">{general:status}</label>
                            {if isset($banner->status)}
                                {html_options options=$statuses name="banner[status]" selected=$banner->status class="form-control select"}
                            {else}
                                {html_options options=$statuses name="banner[status]" class="form-control select"}
                            {/if}
                        </div>
    				</div>
    			</div>
                {* IMAGE *}
                <div class="card">
    				<div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:addImage}</h6>
    					<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
    				</div>

                    <div class="card-body">
                        <div class="content-image gallery">
                            {if isset($banner->image)}
                                <div class="gallery-item item-{$banner->fileId}" id="image_general">
                                    <div class="image" id="image-{$banner->fileId}">
                                        <img src="{$banner->image->medium}" />
                                        <ul class="gallery-item-controls">
                                            <li><span onclick="deleteImage({$banner->bannerId}, 'bannerimage');"><i class="icon-cross2"></i></span></li>
                                        </ul>
                                    </div>

                                </div>
                            {/if}
                        </div>

                    </div>
                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                        <a class="btn btn-sm btn-primary btn-upload read-more"
                           href="javascript:void('')"
                           data-type="image"
                           data-path="/"
                           data-action="read_more"
                           data-module="files"><i class="icon-image2 mr-2"></i> {general:uploadFile} </a>
                    </div>
    			</div>
            </div>
        </div>
    </div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: '{sliders:messages:0}', type: 'success' }).show(); {/if}

        {if isset($errors.access_denied)} new Noty({ text: '{sliders:errors:0}', type: 'error' }).show(); {/if}
        {if isset($errors.title)} new Noty({ text: '{sliders:errors:1}', type: 'error' }).show();; {/if}
        {if isset($errors.group)} new Noty({ text: '{sliders:errors:1}', type: 'error' }).show();; {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{sliders:errors:3}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.image_not_saved)} new Noty({ text: '{sliders:errors:5}', type: 'error' }).show(); {/if}
        {if isset($errors.slider_not_found)} new Noty({ text: '{sliders:errors:6}', type: 'error' }).show(); {/if}
    });

    function deleteImageSuccess() {
        new Noty({ text: '{sliders:messages:1}', type: 'success' }).show();
        document.getElementById('image_general').style.display = 'none';
    }
    function deleteImageError() {
        new Noty({ text: '{sliders:errors:13}', type: 'error' }).show();
    }

    function deleteMessage(){
        new Noty({ text: '{sliders:messages:2}', type: 'success' }).show();
    }
    function successImageMessage(){
        new Noty({ text: '{sections:messages:10}', type: 'success', timeout: 1500 }).show();
    }

    </script>
