<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="index.php?mod=overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="index.php?mod=bannerimages" class="breadcrumb-item">{$title}</a>
			</div>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
				<a class="breadcrumb-elements-item" href="index.php?mod=bannerimage&action=add"><i class="icon-plus3"></i> {general:add}</a>
			</div>
		</div>
	</div>
</div>

<div class="content">
    			
    <div class="row">
    	<div class="col-md-12">
            <div class="card">
                <table class="table table-togglable table-xs table-striped table-hover" id="banners">
                    <thead>
                        <tr>
                            <th data-hide="ID" class="text-center" width="30">#</th>
{*                            <th data-hide="ID" class="text-center" width="30">ID</th>*}
                            <th data-hide="image" class="text-center">{sliders:image}</th>
                            <th data-toggle="true">Название банера</th>
                            <th data-toggle="true">Группа</th>
                            <th data-hide="phone" class="text-center">{general:status}</th>
                            <th class="text-center text-muted"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>
                    {if !empty($banners)}
                    <tbody class="selectable-demo-list banner_list" id="banner_list">

                        {foreach item=banner from=$banners name=banners}
                    	<tr id="banner-{$banner->bannerId}" data-id="{$banner->bannerId}">
                            <td class="move_zone text-center" nowrap="nowrap"><i class="icon-menu8" style="opacity: 0.5;"></i></td>
{*                            <td class="text-center" nowrap="nowrap">{$banner->orderBy}</td>*}
                            <td class="text-center"><img src="{if isset($banner->image)}{$banner->image->small}{else}assets/img/no_images.jpg{/if}" class="img-fluid img-preview rounded"/></td>
                            <td width="100%">{$banner->title|strip_tags|truncate:100|escape nofilter}</td>
                            <td class="text-nowrap">{$banner->groupName|escape}</td>
                            <td style="" id="status-{$banner->bannerId}" align="center">{$banner->statusName}</td>
                            
                            <td class="text-center">
                                <div class="list-icons">
    								<div class="list-icons-item dropdown">
    									<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>

    									<div class="dropdown-menu dropdown-menu-right">
    										<a class="dropdown-item" href="index.php?mod=bannerimage&action=edit&id={$banner->bannerId}"><i class="icon-pencil7"></i> {general:edit}</a>
                                            <a href="#" class="dropdown-item ajax_action {if $banner->status eq 'visible'}active_class{/if}" data-module="bannerimages" data-action="status" data-id="{$banner->bannerId}" name="status" value="1"><i class="{if $banner->status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
    										<div class="dropdown-divider"></div>
    										<a href="javascript:;" class="dropdown-item" onclick="remove({$banner->bannerId}, '{$banner->title|escape}', 'bannerimages');"><i class="icon-cross2"></i> {general:delete}</a>
    									</div>
    								</div>
    							</div>
                            </td>
                        </tr>
                        {/foreach}
                    </tbody>
                    {if isset($pageNums) && $pageNums > 0}
                        <tfoot><tr><td colspan="6"><div class="">{general:results}</div></td></tr></tfoot>
                    {/if}
                {else}
                    <tbody><tr class="odd"><td class="data none" colspan="6" align="center">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
            </div>
    	</div>
    </div>
</div>

	<script>
    $(document).ready(function () {

        {if isset($errors.slider_not_found)} new Noty({ text: 'Баннер с таким ID не найден', type: 'error' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: 'Баннер сохранен', type: 'success' }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Баннер не сохранен', type: 'error' }).show();{/if}

    });
    function deleteError(){
        new Noty({ text: 'Ошибка при удаление баннера', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id){
        new Noty({ text: 'Баннер удален', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'banner');
    }

    $("#banner_list").sortable({
        items: "> tr",
        opacity: 0.5,
        revert: true,
        scroll: true,
        tolerance: "pointer",
        handle: ".move_zone",
        scrollSensitivity: 50,
        scrollSpeed: 50,
        cursor: "move",
        connectWith: '.banner_list',
        placeholder	: "ui-sortable-handle",
        update		: function(){
            $.post( "index.php?mod=bannerimages&action=reorder", $(this).sortable('serialize'), function( data ) {
                location.reload();
            });
	    }
    }).disableSelection();

</script>



