<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="index.php?mod=botreviews" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
			</div>
		</div>
	</div>
</div>
<!-- /page header -->


<!-- Content area -->
<div class="content">
    			
    <div class="row">
    	<div class="col-md-12">
            <div class="card">
                <table class="table table-togglable table-xs table-striped table-hover" id="users">
                    <thead>
                        <tr>
                            <th data-hide="ID" class="text-center" width="30">{users:table:id}</th>
                            <th data-hide="ID" class="text-center" width="90">CHAT ID</th>
                            <th data-hide="login" class="text-left">{users:table:login}</th>
                            <th data-hide="phone" class="text-left">{users:table:phone}</th>
                            <th data-toggle="true" class="text-left">Имя</th>
                            <th data-toggle="true" class="text-left">Отзыв</th>
                            <th data-toggle="true" width="150" class="text-center">Дата</th>
                            <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>

                    {if isset($users)}
	                    <tbody>
	                        {foreach item=user from=$users name=users}
	                        <tr id="user-{$user->review_id}">
	                            <td class="text-center text-nowrap">{$user->review_id}</td>
	                            <td class="text-center text-nowrap">{$user->chat_id}</td>
	                            <td class="text-left">{$user->username nofilter}</td>
	                            <td class="text-left">{$user->contact nofilter}</td>
	                            <td class="text-left">{$user->firstName}</td>
		                        <td class="text-left">{$user->review nofilter}</td>
		                        <td class="text-center text-nowrap">{$user->createdAt nofilter}</td>
	                            <td class="text-center text-nowrap">
		                            <div class="list-icons">
		                            <a href="javascript:void('');" class="list-icons-item text-danger-600"  onclick="remove({$user->review_id}, '{$user->chat_id}', 'botreviews')"><i class="icon-cross2"></i> {general:delete}</a>
		                            </div>
	                            </td>
	                        </tr>
	                        {/foreach}
	                    </tbody>

	                    {if isset($pageNums) && $pageNums > 0}
		                    <tfoot>
		                        <tr>
		                            <td colspan="11">
		                                <div class="">{general:results}</div>
		                                {if isset($pageNums.pages)}
		                                <ul class="pagination-flat justify-content-center twbs-visible-pages pagination">
		                                    <li class="page-item prev {if !isset($pageNums.previousPage)}disabled{/if}">
		                                        <a class="page-link legitRipple" href="index.php?mod=botreviews&page={if isset($pageNums.previousPage)}{$pageNums.previousPage}{/if}{if isset($query)}&query={$query}{/if}{if isset($status)}&status={$status}{/if}">←</a>
		                                    </li>
		                                    {foreach from=$pageNums.pages item=number}
		                                        {if $number eq $page}
		                                            <li class="page-item active"><a class="page-link legitRipple" href="index.php?mod=botreviews&page={if isset($number)}{$number}{/if}{if isset($query)}&query={$query}{/if}{if isset($status)}&status={$status}{/if}">{$number}</a></li>
		                                        {elseif $number eq '...'}
		                                            ...
		                                        {else}
		                                            <li class="page-item"><a class="page-link legitRipple" href="index.php?mod=botreviews&page={$number}{if isset($query)}&query={$query}{/if}{if isset($status)}&status={$status}{/if}">{$number}</a></li>
		                                        {/if}
		                                    {/foreach}

		                                    <li class="page-item next {if !isset($pageNums.nextPage)}disabled{/if}">
		                                        <a  class="page-link legitRipple" href="index.php?mod=botreviews&page={if isset($pageNums.nextPage)}{$pageNums.nextPage}{/if}{if isset($query)}&query={$query}{/if}{if isset($status)}&status={$status}{/if}" >→</a>
		                                    </li>
		                                </ul>
		                                {/if}
		                            </td>
		                        </tr>
		                    </tfoot>
	                    {/if}
                    {else}
                    <tbody><tr class="odd"><td class="data none" colspan="11" align="center">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
            </div>
    	</div>
    
    </div>
</div>

<script>

    function deleteImageMessage(){ new Noty({ text: '{users:messages:2}', type: 'success', timeout: 1500 }).show(); }
    function deleteMessage(){ new Noty({  text: '{users:messages:1}', type: 'success', timeout: 1500 }).show(); }
    function userNotFound(){ new Noty({ text: '{managers:errors:1}', type: 'error' }).show(); }
    function notDeleteAdministrator(){ new Noty({ text: '{managers:errors:6}', type: 'error' }).show(); }
    function notDeleteDeveloper(){ new Noty({ text: '{managers:errors:14}', type: 'error' }).show(); }
    function notDeleteFound(){ new Noty({ text: '{users:errors:17}', type: 'error' }).show(); }


</script>




