<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="index.php?mod=overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="index.php?mod=faqs" class="breadcrumb-item">{$title}</a>
			</div>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
				<a class="breadcrumb-elements-item" href="index.php?mod=faq&action=add"><i class="icon-plus3"></i> {general:add}</a>
			</div>
		</div>
	</div>
</div>

<div class="content">
    			
    <div class="row">
    	<div class="col-md-12">
            <div class="card">
                <table class="table table-togglable table-xs table-striped table-hover" id="faqs">
                    <thead>
                        <tr>
                            <th data-hide="ID" class="text-center" width="30">#</th>
                            <th data-hide="ID" class="text-center" width="30">ID</th>
                            <th data-toggle="true">Вопрос</th>
                            <th data-hide="phone" class="text-center">{general:status}</th>
                            <th class="text-center text-muted"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>
                    {if isset($faqs)}
                    <tbody class="selectable-demo-list faq_list" id="faq_list">

                        {foreach item=faq from=$faqs name=faqs}
                    	<tr id="faq-{$faq->faqId}" data-id="{$faq->faqId}">
                            <td class="move_zone text-center" nowrap="nowrap"><i class="icon-menu8" style="opacity: 0.5;"></i></td>
                            <td class="text-center" nowrap="nowrap">{$faq->orderBy}</td>
                            <td width="100%">{$faq->question|escape nofilter}</td>
                            <td class="text-center" id="status-{$faq->faqId}">{$faq->statusName}</td>
                            
                            <td class="text-center">
                                <div class="list-icons">
    								<div class="list-icons-item dropdown">
    									<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>

    									<div class="dropdown-menu dropdown-menu-right">
    										<a class="dropdown-item" href="index.php?mod=faq&action=edit&id={$faq->faqId}"><i class="icon-pencil7"></i> {general:edit}</a>
                                            <a href="#" class="dropdown-item ajax_action {if $faq->status eq 'visible'}active_class{/if}" data-module="faqs" data-action="status" data-id="{$faq->faqId}" name="status" value="1"><i class="{if $faq->status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
    										<div class="dropdown-divider"></div>
    										<a href="javascript:;" class="dropdown-item" onclick="remove({$faq->faqId}, '{$faq->question|escape}', 'faqs');"><i class="icon-cross2"></i> {general:delete}</a>
    									</div>
    								</div>
    							</div>
                            </td>
                        </tr>
                        {/foreach}
                    </tbody>
                    {if isset($pageNums) && $pageNums > 0}
                    <tfoot><tr><td colspan="6"><div class="">{general:results}</div></td></tr></tfoot>
                    {/if}
                {else}
                    <tbody><tr class="odd"><td class="data none" colspan="6" align="center">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
            </div>
    	</div>
    </div>
</div>

	<script>
    $(document).ready(function () {
        {if isset($errors.not_saved)} new Noty({ text: 'Впрос не сохранен', type: 'error' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: 'Вопрос сохранен', type: 'success' }).show(); {/if}
    });
    function deleteError(){
        new Noty({ text: 'Ошибка при удаление вопроса', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id){
        new Noty({ text: 'Вопрос удален', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'faq');
    }


    $("#faq_list").sortable({
        items: "> tr",
        opacity: 0.5,
        revert: true,
        scroll: true,
        tolerance: "pointer",
        handle: ".move_zone",
        scrollSensitivity: 50,
        scrollSpeed: 50,
        cursor: "move",
        connectWith: '.faq_list',
        placeholder	: "ui-sortable-handle",
        update		: function(){
            $.post( "index.php?mod=faqs&action=reorder", $(this).sortable('serialize'), function( data ) {
                location.reload();
            });

	    }
    }).disableSelection();

</script>



