<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="index.php?mod=overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="index.php?mod=articles" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">

				<a class="breadcrumb-elements-item" href="index.php?mod=feature&action=add{if isset($page)}&page={$page}{/if}{if isset($query)}&query={$query}{/if}{if isset($section)}&section={$section}{/if}{if isset($status)}&status={$status}{/if}" title="{general:add}"><i class="icon-plus3"></i> {general:add}</a>
			</div>
		</div>
	</div>
</div>
<!-- /page header -->

<!-- Content area -->
<div class="content">
    <div class="row">
    	<div class="col-md-12">
            
            <div class="card">
	            <table class="table table-togglable table-xs table-striped table-hover feature-archive" id="features">
		            <thead>
			            <tr>
				            <th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
				            <th data-toggle="true">{general:table:name}</th>
				            <th data-hide="phone" >{general:table:status}</th>
				            <th class="text-center text-muted"><i class="icon-checkmark3"></i></th>
			            </tr>
		            </thead>
		            <tbody class="selectable-demo-list" id="feature_list"></tbody>
	            </table>
            </div>
    	</div>
    </div>
</div>

	<script>

        var FeatureList = function() {

            // Datatable
            var _componentDatatable = function() {
                if (!$().DataTable) {
                    console.warn('Warning - datatables.min.js is not loaded.');
                    return;
                }

                // Initialize
                $.extend( $.fn.dataTable.defaults, {
                    autoWidth: false,
                    processing: true,
                    serverSide: true,
                    deferRender: false,
                    stateSave: true,
                    ajax: {
                        "url": "index.php?mod=features",
                        "type": 'POST',
                        "data": { action: 'table' },
                        dataSrc: "data",
                        // success: function (data) {
                        //     console.log(data.data);
                        // },
                    },
                    'createdRow': function( row, data, dataIndex ) {
                        console.log(data);
                        console.log(dataIndex);
                        $(row).attr("data-id", data.id).attr("id", 'feature-'+data.id);
                    },
                    columns: [
                        { data: "orderBy",
                            render: function (dataField, type, row) {
                                return  '<i class="icon-menu8" style="opacity: 0.5;"></i>';
                                // return  '<i class="icon-menu8"></i>' +row.id + ' - ' + row.orderBy;
                            }
                        },
                        { data: "name",
                            render: function (dataField) {
                                return `<b>` +dataField + `</b>`;
                            }
                        },
                        { data: "statusName",
                            render: function (dataField) {
                                return "<td>" + dataField + "</td>";
                            }
                        },
                        { data: "id",
                            render: function (dataField, type, row) {
                                console.log(row)
                                let active_class = '';
                                let icon_eye = '';
                                if (row.status == 'visible') {
                                    active_class = 'active_class';
                                    icon_eye = 'icon-eye';
                                } else {
                                    icon_eye = 'icon-eye-blocked';
                                }
                                return '<td class="text-center"><div class="list-icons">' +
                                    '<div class="list-icons-item dropdown">' +
                                    '<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>' +
                                    '<div class="dropdown-menu dropdown-menu-right">' +
                                    '<a class="dropdown-item" href="index.php?mod=feature&action=edit&id=' + dataField + '"><i class="icon-pencil7"></i> {general:edit}</a>' +
                                    '<a href="javascript:void(0);" class="dropdown-item ajax_action ' + active_class + '" data-module="features" data-action="status" data-id="' + dataField + '" value="1" ><i class="' + icon_eye + '"></i> {general:status}</a>' +

                                    '<div class="dropdown-divider"></div>' +
                                    '<a href="javascript:void(0);" class="dropdown-item" onclick="remove(' + dataField + ', `' + row.name + '`, `features`);">' +
                                    '<i class="icon-cross2"></i> {general:delete}</a>' +
                                    '</div>' +
                                    '</div>' +
                                    '</div>' +
                                    '</td>';
                            }
                        },
                    ],
                    columnDefs: [
                        { width: '5%',      targets: 0, className: "move_zone text-nowrap"},
                        { width: '80%',     targets: 1,  className: "text-nowrap" },
                        { width: '10%',     targets: 2, className: "text-nowrap"},
                        { orderable: false, targets: 3, width: '5%', className: "text-center" },
                        // { visible: false,   targets: 5 , orderable: false,}
                    ],
                    order: [[0, 'asc']],
                    dom: '<"datatable-header"fl><"datatable-scroll-lg"t><"datatable-footer"ip>',
                    language: { "url": "{$GLOBAL_URL}/admin/assets/js/plugins/tables/datatables/lang/{$config.admin_language}.json" },
                    lengthMenu: [10, 25, 50, 75, 100],
                    displayLength: 10,
                    // drawCallback: function (settings) {
                    //     var api = this.api();
                    //     var rows = api.rows({ page: 'current' }).nodes();
                    // }
                });

                var table = $('.feature-archive').DataTable({ });


            };
            var _componentSortable = function() {

                $("#feature_list").sortable({
                    items: "> tr",
                    opacity: 0.5,
                    revert: true,
                    scroll: true,
                    tolerance: "pointer",
                    handle: ".move_zone",
                    scrollSensitivity: 50,
                    scrollSpeed: 50,
                    cursor: "move",
                    connectWith: '.feature_list',
                    placeholder	: "ui-sortable-handle",

                    update: function(event, ui) {

                        var featureIds = [];
                        $('#feature_list tr').each(function() {
                            featureIds.push($(this).attr("data-id"));
                        });

                        console.log(featureIds);
                        $.ajax({
                            url:"index.php?mod=features",
                            method:"POST",
                            data:{ featureIds: featureIds, action: 'reorder' },
                            success:function(data) {
                                console.log(data)
                                // location.reload();
                                //alert(data);
                            }
                        });
                    }
                }).disableSelection();
            };

            return {
                init: function() {
                    _componentDatatable();
                    _componentSortable();
                }
            }
        }();

        document.addEventListener('DOMContentLoaded', function() {
            FeatureList.init();
        })

    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
        
        {if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}

    });

    function successImageMessage(){
        new Noty({ text: '{sections:messages:10}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }

    function deleteError(){
        new Noty({ text: 'ошибка при удаление контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id) {
        new Noty({ text: '{articles:messages:2}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'feature');
    }

    function notFound(){
        new Noty({ text: 'контент не найден или пустой ID', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function approveError(){
        new Noty({ text: 'ошибка при одобрение контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }
    function statusError(){
        new Noty({ text: 'ошибка при изменение статуса контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function approveSuccess(id) {
        document.getElementById('status-' + id).innerHTML = '{general:statuses:visible}';
        document.getElementById('article-approve-' + id).style.display = 'none';
        document.getElementById('article-status-' + id).innerHTML = '<i class="icon-eye"></i> {general:statuses:visible}';
        new Noty({ text: 'Контент одобрен без модерации', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }






</script>



