<IfModule mod_autoindex>
	Options -Indexes
</IfModule>

{if $config.mod_deflate}
# Gzip сжатие / поддерживается не на всех хостингах
<IfModule mod_deflate.c>
	# Compress HTML, CSS, JavaScript, Text, XML and fonts
	AddOutputFilterByType DEFLATE application/javascript
	AddOutputFilterByType DEFLATE application/rss+xml
	AddOutputFilterByType DEFLATE application/vnd.ms-fontobject
	AddOutputFilterByType DEFLATE application/x-font
	AddOutputFilterByType DEFLATE application/x-font-opentype
	AddOutputFilterByType DEFLATE application/x-font-otf
	AddOutputFilterByType DEFLATE application/x-font-truetype
	AddOutputFilterByType DEFLATE application/x-font-ttf
	AddOutputFilterByType DEFLATE application/x-javascript
	AddOutputFilterByType DEFLATE application/xhtml+xml
	AddOutputFilterByType DEFLATE application/xml
	AddOutputFilterByType DEFLATE font/opentype
	AddOutputFilterByType DEFLATE font/otf
	AddOutputFilterByType DEFLATE font/ttf
	AddOutputFilterByType DEFLATE image/svg+xml
	AddOutputFilterByType DEFLATE image/x-icon
	AddOutputFilterByType DEFLATE text/css
	AddOutputFilterByType DEFLATE text/html
	AddOutputFilterByType DEFLATE text/javascript
	AddOutputFilterByType DEFLATE text/plain
	AddOutputFilterByType DEFLATE text/xml

	# Remove browser bugs (only needed for really old browsers)
	<ifmodule mod_setenvif.c>
		BrowserMatch ^Mozilla/4 gzip-only-text/html
		BrowserMatch ^Mozilla/4\.0[678] no-gzip
		BrowserMatch \bMSIE !no-gzip !gzip-only-text/html
	</ifmodule>
</IfModule>
{/if}

{if $config.mod_headers}
<ifModule mod_headers.c>
	# Все html и htm файлы будут храниться в кэше браузера один день
	<FilesMatch "\.(html|htm)$">
		Header set Cache-Control "max-age=43200"
	</FilesMatch>
	# Все css, javascript и текстовые файлы будут храниться в кэше браузера одну неделю
	<FilesMatch "\.(js|css|txt)$">
		Header set Cache-Control "max-age=604800"
	</FilesMatch>
	# Все флэш файлы и изображения будут храниться в кэше браузера один месяц
	<FilesMatch "\.(flv|swf|ico|gif|jpg|jpeg|png)$">
		Header set Cache-Control "max-age=43200"
	</FilesMatch>
	# Отключаем кеширование php и других служебных файлов
	<FilesMatch "\.(pl|php|cgi|spl|scgi|fcgi)$">
	Header unset Cache-Control
	</FilesMatch>
</IfModule>
{/if}

{if $config.mod_expires}
# Кэширование / поддерживается не на всех хостингах
<ifmodule mod_expires.c>
	<filesmatch "\.(jpg|jpeg|png|gif|js|css|swf|ico|woff|mp3)$">
	ExpiresActive on
	ExpiresDefault "access plus 7 days"
	</filesmatch>
</ifmodule>
{/if}

{if $homePageId}
DirectoryIndex /public/section.php?sectionId={$homePageId}&rewrite={$rewrite}
{/if}
RewriteEngine On

SetEnvIf Authorization "(.*)" HTTP_AUTHORIZATION=$1

{if IS_HTTPS}{literal}
RewriteCond %{HTTPS} =off
RewriteRule (.*) https://%{HTTP_HOST}%{REQUEST_URI} [QSA,L]
{/literal}{/if}
ErrorDocument 404 /public/error-404.php?rewrite={$rewrite}

{if $config.compress_js_css}
RewriteCond %{ldelim}REQUEST_FILENAME{rdelim} -f
RewriteRule ^(.+\.(css|js))$ /compress.php?path=$1&rewrite={$rewrite} [L]
{/if}

#RewriteRule ^rss.xml$ /public/rss.php?rewrite={$rewrite} [L]
RewriteRule ^sitemap.xml$ /public/sitemap.php?rewrite={$rewrite} [L]

{foreach item=section from=$SECTIONS}{if $section->type eq "plain"}
{if $section->fileName eq "index"}
RewriteRule ^{$section->dir|preg_quote}\.{$config.file_extension}$ {$SITE_URL}/ [L,R=301]
{else}
RewriteRule ^{$section->dir|preg_quote}\.{$config.file_extension}$ /public/section.php?sectionId={$section->sectionId}&rewrite={$rewrite} [L]
{/if}

{/if}{/foreach}

RewriteRule ^brands/([^/]+)/page([0-9]+)\.{$config.file_extension}$ /public/brand.php?{literal}%{QUERY_STRING}{/literal}&fileName=$1&page=$2&rewrite={$rewrite} [L]
RewriteRule ^brands/([^/]+) /public/brand.php?{literal}%{QUERY_STRING}{/literal}&fileName=$1&rewrite={$rewrite} [L]

{foreach item=section from=$SECTIONS}{if $section->type eq "tree"}
RewriteRule ^{$section->dir|preg_quote}$ {$section->path}/ [L,R=301]
RewriteRule ^{$section->dir|preg_quote}/$ /public/section.php?{literal}%{QUERY_STRING}{/literal}&sectionId={$section->sectionId}&rewrite={$rewrite} [L]
RewriteRule ^{$section->dir|preg_quote}/page([0-9]+)\.{$config.file_extension}$ /public/section.php?{literal}%{QUERY_STRING}{/literal}&sectionId={$section->sectionId}&page=$1&rewrite={$rewrite} [L]
RewriteRule ^{$section->dir|preg_quote}/([^/]+)\.{$config.file_extension}$ /public/article.php?{literal}%{QUERY_STRING}{/literal}&fileName=$1&sectionId={$section->sectionId}&rewrite={$rewrite} [L]

{/if}{/foreach}

RewriteRule ^objects /api/map-api.php?rewrite={$rewrite} [QSA]

# все запросы в префиксом (ajax) будут обрабатываться следующим образом ajax-(что здесь будет) /public/ajax-ТО СЮДА ПРИДЕТ.php
RewriteRule ^ajax-(.*) /public/ajax-$1.php?rewrite={$rewrite} [QSA]

# все запросы в префиксом (api) будут обрабатываться следующим образом api-(что здесь будет) /public/api-ТО СЮДА ПРИДЕТ.php
RewriteRule ^api-(.*) /public/api-$1.php?rewrite={$rewrite} [QSA]

# Подтверждение регистрации
RewriteRule ^confirm/([^/]+)/([^/]+)/$ /public/user-confirm.php?selector=$1&token=$2&rewrite={$rewrite} [QSA]
RewriteRule ^recovery/([^/]+)/([^/]+)/$ /public/user-recovery-confirm.php?selector=$1&token=$2&rewrite={$rewrite} [QSA]
RewriteRule ^sign-out$ /public/user-sign-out.php?rewrite={$rewrite} [QSA]


# Set the “ea-php74” package as the default “PHP” programming language.
<IfModule mime_module>
	AddHandler application/x-httpd-ea-php74 .php .php7 .phtml
</IfModule>

