<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="javascript:;" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="index.php?mod=overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> {header:statistics}</a>
				<a href="index.php?mod=managers" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="javascript:;" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
				<a class="breadcrumb-elements-item" href="index.php?mod=manager&action=add"><i class="icon-plus3"></i> {general:add}</a>
			</div>
		</div>
	</div>
</div>

<div class="content">
    			

    <div class="card">
        <table class="table table-togglable table-xs table-striped table-hover managers-archive" id="managers">
            <thead>
                <tr>
                    <th data-hide="ID" width="30%">{managers:title}</th>
                    <th data-hide="image">{managers:email}</th>
                    <th data-toggle="true">{general:table:type}</th>
                    <th data-toggle="true">{general:table:status}</th>
                    <th class="text-center text-muted"><i class="icon-checkmark3"></i></th>
                </tr>
            </thead>
{*            {if isset($managers)}*}
{*            <tbody>*}
{*                {foreach item=manager from=$managers}*}
{*                <tr id="manager-{$manager->userId}">*}
{*                    <td nowrap="nowrap">*}
{*                        <div class="d-flex align-items-center">*}
{*							<div class="mr-3"><img src="{if isset($manager->image)}{$manager->image->lg}{else}avatar/no-image.jpg{/if}" alt="{if !empty($manager->fullName)}{$manager->fullName}{/if}" class="rounded-circle" width="32" height="32"></div>*}
{*							<div>*}
{*								<a href="index.php?mod=manager&action=edit&id={$manager->userId}" class="text-default font-weight-semibold">{if !empty($manager->fullName)}{$manager->fullName nofilter}{/if}</a>*}
{*								<div class="text-muted font-size-sm">*}
{*									<span class="badge badge-mark {if $manager->status eq 1}border-success{elseif $manager->status eq 1}border-slate{elseif $manager->status eq 2 || $manager->status eq 3}border-danger{elseif $manager->status eq 4 || $manager->status eq 5}border-primary{else}border-grey-400{/if} mr-1"></span>*}
{*									{$manager->last_login|date_format:"%d.%m.%Y %H:%M"}*}
{*								</div>*}
{*							</div>*}
{*						</div>*}
{*                        *}
{*                    </td>*}
{*                    <td nowrap="nowrap">{if !empty($manager->email)}{$manager->email}{else}Email не указан{/if}</td>*}
{*                    <td nowrap="nowrap">{$manager->accessLevelName}</td>*}
{*                    <td nowrap="nowrap">{$manager->statusName}</td>*}
{*                    <td class="text-center">*}
{*                        <div class="list-icons">*}
{*							<div class="list-icons-item dropdown">*}
{*								<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>*}
{*								<div class="dropdown-menu dropdown-menu-right">*}
{*									<a class="dropdown-item" href="index.php?mod=manager&action=edit&id={$manager->userId}"><i class="icon-pencil7"></i> {general:edit}</a>*}
{*									<div class="dropdown-divider"></div>*}
{*									<a href="javascript:void();" class="dropdown-item" onclick="remove({$manager->userId}, '{if !empty($manager->fullName)}{$manager->fullName}{/if}', 'managers')"><i class="icon-cross2"></i> {general:delete}</a>*}
{*								</div>*}
{*							</div>*}
{*						</div>*}
{*                    </td>*}
{*                </tr>*}
{*            {/foreach}*}
{*            </tbody>*}
{*            {if isset($pageNums) && $pageNums > 0}*}
{*            <tfoot>*}
{*                <tr>*}
{*                    <td colspan="5">*}
{*                        <div class="">{general:results}</div>*}
{*                        {if isset($pageNums.pages)}*}
{*                            <ul class="pagination-flat justify-content-center twbs-visible-pages pagination">*}
{*                                <li class="page-item prev {if !isset($pageNums.previousPage)}disabled{/if}">*}
{*                                    <a class="page-link legitRipple" href="index.php?mod=managers&page={if isset($pageNums.previousPage)}{$pageNums.previousPage}{/if}">←</a>*}
{*                                </li>*}
{*                                {foreach from=$pageNums.pages item=number}*}
{*                                    {if $number eq $page}*}
{*                                        <li class="page-item active"><a class="page-link legitRipple" href="index.php?mod=managers&page={$number}">{$number}</a></li>*}
{*                                    {elseif $number eq '...'}*}
{*                                        ...*}
{*                                    {else}*}
{*                                        <li class="page-item"><a class="page-link legitRipple" href="index.php?mod=managers&page={$number}">{$number}</a></li>*}
{*                                    {/if}*}
{*                                {/foreach}*}

{*                                <li class="page-item next {if !isset($pageNums.nextPage)}disabled{/if}">*}
{*                                    <a  class="page-link legitRipple" href="index.php?mod=managers&page={if isset($pageNums.nextPage)}{$pageNums.nextPage}{/if}" >→</a>*}
{*                                </li>*}
{*                            </ul>*}
{*                        {/if}*}
{*                    </td>*}
{*                </tr>*}
{*            </tfoot>*}
{*            {/if}*}
{*            {else}*}
{*            <tbody><tr class="odd"><td class="data none" colspan="5" align="center">- {general:none} -</td></tr></tbody>*}
{*            {/if}*}
        </table>
                
    </div>
</div>

<script>

    function deleteSuccess(id) {
        new Noty({ text: '{managers:messages:1}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'manager');
    }

    function deleteError() {
        new Noty({ text: '{managers:errors:15}', layout: 'topRight', type: 'error' }).show();
    }

    function userNotFound() {
        new Noty({ text: '{managers:errors:1}', layout: 'topRight', type: 'error' }).show();
    }

    function notDeleteAdministrator() {
        new Noty({ text: '{managers:errors:6}', layout: 'topRight', type: 'error' }).show();
    }

    function notDeleteDeveloper() {
        new Noty({ text: '{managers:errors:14}', layout: 'topRight', type: 'error' }).show();
    }


    var BrandList = function() {

        // Datatable
        var _componentDatatable = function() {
            if (!$().DataTable) {
                console.warn('Warning - datatables.min.js is not loaded.');
                return;
            }

            $.extend( $.fn.dataTable.defaults, {
                autoWidth: false,
                processing: true,
                serverSide: true,
                deferRender: true,
                stateSave: true,
                ajax: { "url": "index.php?mod=managers&action=table", "type": 'POST' },
                'createdRow': function( row, data, dataIndex ) {
                    $(row).attr("data-id", data.userId).attr("id", 'manager-' + data.userId);
                },
                columns: [
                    { data: "fullName",
                        render: function (data, type, row) {
                            // console.log(row)
	                        var classStatus = '', image = '/admin/assets/img/no_images.jpg';
                            if (row.status == 1) {
                                classStatus = 'border-success';
                            } else if (row.status == 2 || row.status == 3) {
                                classStatus = 'border-danger';
                            } else if (row.status == 4 || row.status == 5) {
                                classStatus = 'border-primary';
                            } else {
                                classStatus = 'border-grey-400';
                            }
                            if (row.image) image = row.image.medium;

	                        return '<div class="d-flex align-items-center">' +
		                                '<div class="mr-3"><img src="' + image +'" alt="' + row.fullName + '" class="rounded-circle" width="32" height="32"></div>' +
                                        '<div>'+
                                            '<a href="index.php?mod=manager&action=edit&id=' + row.userId + '" class="text-default font-weight-semibold">' + row.fullName + '</a>'+
                                            '<div class="text-muted font-size-sm"><span class="badge badge-mark ' + classStatus + ' mr-1"></span>' + row.last_login + '</div>'+
                                        '</div>' +
		                            '</div>';
                        }
                    },
                    { data: "email",
                        render: function (dataField) {
                            if (dataField) {
                                return `<b>` + dataField + `</b>`;
                            } else {
                                return `<b>{general:isNotSpecified}</b>`;
                            }
                        }
                    },
                    { data: "accessLevelName",
                        render: function (dataField) {
                            return `<b>` +dataField + `</b>`;
                        }
                    },
                    { data: "statusName",
                        render: function (dataField) {
                            return `<b>` +dataField + `</b>`;
                        }
                    },
                    { data: "userId",
                        render: function (dataField, type, row) {
                        // console.log(row);
                            return '<div class="list-icons"><div class="list-icons-item dropdown">' +
                                '<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>' +
                                '<div class="dropdown-menu dropdown-menu-right">' +
                                '<a class="dropdown-item" href="index.php?mod=manager&action=edit&id=' + dataField + '"><i class="icon-pencil7"></i> {general:edit}</a>' +

                                '<div class="dropdown-divider"></div>' +
                                '<a href="javascript:void(0);" class="dropdown-item" onclick="remove(' + row.userId + ', `' + row.fullName + '`, `managers`);">' +
                                '<i class="icon-cross2"></i> {general:delete}</a>' +
                                '</div>' +
                                '</div></div>';
                        }
                    },
                ],
                columnDefs: [
                    { width: '10%',     targets: 0, className: " text-left text-nowrap"},
                    { width: '40%',     targets: 1,  className: "text-center text-nowrap" },
                    { orderable: false, width: '20%',     targets: 2, className: "text-nowrap" },
                    { orderable: false, width: '30%',     targets: 3, className: "text-center text-nowrap"},
                    { orderable: false, targets: 4, width: '5%', className: "text-center" },
                ],
                order: [[0, 'asc']],
                dom: '<"datatable-header"fl><"datatable-scroll-lg"t><"datatable-footer"ip>',
                language: { "url": "{$GLOBAL_URL}/admin/assets/js/plugins/tables/datatables/lang/{$config.admin_language}.json" },
                lengthMenu: [10, 25, 50, 75, 100],
                displayLength: 10,
                drawCallback: function (settings) {
                    var api = this.api();
                    var rows = api.rows({ page: 'current' }).nodes();
                }
            });

            var table = $('.managers-archive').DataTable({ });

        };

        return {
            init: function() {
                _componentDatatable();
            }
        }
    }();

    document.addEventListener('DOMContentLoaded', function() {
        BrandList.init();
    });
</script>



