{strip}
    {assign var=wrapper value="" scope=global}
{if isset($list)}
    {if isset($list.dirs)}
        {foreach item=dir from=$list.dirs}
			<div class="file-manager-list" data-name="{$dir.name|escape}">
				<div class="card">
					<a href="javascript:void('')" data-path="{$path}{$dir.name|escape}" data-action="read_more" class="card-body read-more p-0">
						<div class="card-img-actions mx-1 mt-1"><i class="icon-folder5 card-img img-fluid" style="font-size: 90px;"></i></div>
						<div class="card-file-upload-body text-left">
							<div class="img-apply">
								<div class="font-weight-semibold">{$dir.name|escape}</div>
								<div class="font-size-sm text-muted">Size: {$dir.size}</div>
							</div>
						</div>
					</a>
					<div class="card-footer bg-white d-flex justify-content-center align-items-center p-1">
						<ul class="list-inline mb-0">
							<li class="list-inline-item">
								<a href="javascript:void('')" data-path="{$path|escape}" data-folder="{$dir.name|escape}" data-action="delete_folder" data-confirm="{javascript:sureToDelete} «{$dir.name|escape}»?" class="list-icons-item remove_folder"></a>
							</li>
						</ul>
					</div>
				</div>
			</div>
        {/foreach}
    {/if}

    {if isset($list.files)}
        {foreach item=file from=$list.files}
			<figure class="file-manager-list" data-id="{$file.fileId}">
				<div class="card">
					<a href="javascript:void('')" class="card-body card_file_item p-0" data-action="read_file" data-id="{$file.fileId}" data-path="{$path|escape}">
						<div class="card-img-actions mx-1 mt-1">
							<div class="card-img card-file-upload class_ext_{$file.class_ext}" style="{if $file.class_ext ne 2} background-size: contain; background-image: url('{$file.icon}') {else}background-image: url('{$file.original}'){/if}"></div>
						</div>
						<div class="card-file-upload-body text-left">
							<div class="img-apply">
								<div class="font-weight-semibold" style="overflow: hidden;text-overflow: ellipsis;white-space: nowrap;"> {$file.fileName}</div>
								<div class="font-size-sm text-muted">Size: {$file.size}</div>
							</div>
						</div>
					</a>
					<div class="card-footer bg-white d-flex justify-content-center align-items-center p-1">
						<ul class="list-inline mb-0">
							<li class="list-inline-item"><a href="{$file.original}" download class="list-icons-item"><i class="icon-download top-0"></i></a></li>
							<li class="list-inline-item"><a href="javascript:void('')" data-id="{$file.fileId}" data-path="{$path|escape}" data-action="remove" data-confirm="{javascript:sureToDelete} «{$file.fileName|escape}»?" class="list-icons-item remove-files"></a></li>
						</ul>
					</div>
				</div>
			</figure>
        {/foreach}
    {/if}
{/if}
{/strip}
