<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">Статистика</span> - {$title}</h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
			</div>
		</div>
	</div>


	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="index.php?mod=overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="index.php?mod=overview" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>

		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">

			</div>
		</div>
	</div>
</div>

<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="card">
				<div class="card-header header-elements-inline">
					<h5 class="card-title">{$title}</h5>
					<div class="header-elements">
						<div class="list-icons">
							<a class="list-icons-item" data-action="collapse"></a>
						</div>
					</div>
				</div>
				<div class="card-body d-flex">
					{include file="stats.form.type-selector.tpl" action="index.php?mod=visitor&visitorId=$visitorId"}
					{include file="stats.form.date-selector.tpl"}
				</div>
			</div>
		</div>
		<div class="col-md-6">
			<div class="card">
				<div class="card-header header-elements-inline">
					<h5 class="card-title">{stats:visitorInfo}</h5>
					<div class="header-elements">
						<div class="list-icons">
							<a class="list-icons-item" data-action="collapse"></a>
						</div>
					</div>
				</div>
				<table class="table table-bordered table-xs table-striped table-actions">
					<tbody>
						<tr class="">
							<td nowrap="nowrap">{stats:visitorId}:</td>
							<td class="p-0" width="100%">
								<form autocomplete="off" method="get" action="index.php?mod=visitor" class="d-flex">
									<div class="col-md-8"><input type="text" name="visitorId" value="{$visitorId}" class="form-control" disabled /></div>
{*									<div class="col-md-4"><input type="submit" value="Сменить" class="btn btn-sm btn-primary" /></div>*}
								</form>
							</td>
						</tr>
						<tr>
							<td class="data" align="right" width="120">{stats:referer}:</td>
							<td class="data">
								{if isset($visitor->refererUrl)}
									<a href="{$visitor->refererUrl}" target="_blank">
										{if isset($visitor->refererWebsite)}
											{$visitor->refererWebsite|truncate:50}
										{else}
											{$visitor->refererUrl|truncate:50}
										{/if}
									</a>
								{else}
									{$visitor->referer|truncate:50}
								{/if}
							</td>
						</tr>
						{if isset($visitor->searchPhrase)}
							<tr>
								<td class="" align="right" nowrap="nowrap">{stats:searchQuery}:</td>
								<td class="small">{$visitor->searchPhrase|truncate:50}</td>
							</tr>
						{/if}
						<tr>
							<td class="data" align="right" nowrap="nowrap">{stats:visitorIp}:</td>
							<td class="data small">{$visitor->visitorIp} (<a href="http://whois.domaintools.com/{$visitor->visitorIp}" target="_blank">{stats:whois}</a>)</td>
						</tr>
						<tr>
							<td class="data" align="right">{stats:useragent}:</td>
							<td class="data small" title="{$visitor->userAgent}">{$visitor->userAgent}</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
		<div class="col-md-6">
			<div class="card">
				<div class="card-header header-elements-inline">
					<h5 class="card-title">{stats:firstVisit}</h5>
					<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
				</div>
				<table class="table table-bordered table-xs table-striped table-actions">
					<tbody>
                        <tr>
                            <td class="data" align="right" width="120">{general:date}:</td>
                            <td class="data" nowrap="nowrap">{$visitor->firstVisitOn nofilter}</td>
                        </tr>
                        <tr>
                            <td class="data" align="right" nowrap="nowrap" width="120">{stats:type}:</td>
                            <td class="data">
                                {if $visitor->firstVisit->typeId eq 6}
                                    <span class="code{if isset($visitor->firstVisit->errorCode)}{$visitor->firstVisit->errorCode}{/if}">{stats:error} {if isset($visitor->firstVisit->errorCode)}{$visitor->firstVisit->errorCode}{/if}</span>
                                {elseif $visitor->firstVisit->typeName}
                                    {$visitor->firstVisit->typeName nofilter}
                                {/if}
                            </td>
                        </tr>
                        <tr>
                            <td class="data" align="right" width="120">{stats:page}:</td>
                            <td class="data">
                                {if isset($visitor->firstVisit->typeId) and $visitor->firstVisit->typeId eq 1}
                                    <a href="{$SITE_URL}/" target="_blank">{stats:homePage}</a>
                                {elseif $visitor->firstVisit->typeId eq 2 && isset($visitor->firstVisit->name)}
                                    <a href="{$visitor->firstVisit->url}" target="_blank">{$visitor->firstVisit->name|truncate:50}</a>
                                {elseif $visitor->firstVisit->typeId eq 3 && isset($visitor->firstVisit->title)}
                                    <a href="{$visitor->firstVisit->url}" target="_blank">{$visitor->firstVisit->title|truncate:50} </a>
                                {elseif $visitor->firstVisit->typeId eq 4}
                                    <a href="{$SITE_URL}/search.php?query={$visitor->firstVisit->searchQuery|escape:'url'}&page={$visitor->firstVisit->searchPage}" target="_blank">{$visitor->firstVisit->searchQuery|truncate:50}</a>
                                {elseif $visitor->firstVisit->typeId eq 6}
                                    <a href="{if isset($visitor->firstVisit->requestUri)} {$visitor->firstVisit->requestUri} {/if}" target="_blank">
										{if isset($visitor->firstVisit->requestUri)} {$visitor->firstVisit->requestUri|truncate:50} {/if}
									</a>
                                    {if isset($visitor->firstVisit->refererUrl)}(<a href="{$visitor->firstVisit->refererUrl}" target="_blank">{"{stats:referer}"|strtolower}</a>){/if}
                                {elseif $visitor->firstVisit->typeId eq 7}
                                    {if !isset($visitor->firstVisit->section)}
                                        <a href="{$SITE_URL}/rss.xml" target="_blank">{stats:genRss}</a>
                                    {elseif $visitor->firstVisit->section}
                                        <a href="{$visitor->firstVisit->section.path}/rss.xml" target="_blank">{$visitor.firstVisit.section.name|truncate:35}</a>
                                    {else}
                                        {stats:unknown}
                                    {/if}
                                {elseif $visitor->firstVisit->typeId eq 8}
                                    <a href="{$SITE_URL}/sitemap.{$config.file_extension}" target="_blank">{stats:genSitemap}</a>
                                {elseif $visitor->firstVisit->typeId eq 9}
                                    <a href="{$SITE_URL}/sitemap.xml" target="_blank">{stats:xmlSitemap}</a>
                                {elseif $visitor->firstVisit->typeId eq 11}
                                    <a href="{$visitor->firstVisit->url}" target="_blank">{$visitor->firstVisit.alias|default:$visitor.firstVisit.title|truncate:45}</a>
                                {elseif $visitor->firstVisit->typeId eq 12}
                                    <a href="{$visitor->firstVisit->url}" target="_blank">{$visitor->firstVisit.alias|default:$visitor.firstVisit.title|truncate:45}</a>
                                {elseif $visitor->firstVisit->typeId eq 13}
                                    <a href="{$visitor->firstVisit->url}" target="_blank">{$visitor->firstVisit.alias|default:$visitor.firstVisit.title|truncate:45}</a>
                                {else}
                                    {stats:unknown}
                                {/if}
                            </td>
                        </tr>
					</tbody>
				</table>
			</div>
		</div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-header header-elements-inline">
                    <h5 class="card-title">{stats:visit}</h5>
                    <div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
                </div>
                <table class="table table-bordered table-xs table-striped table-actions">
                    <thead>
                        <tr>
                            <th class="text-center" style="min-width:120px;">{general:date}</th>
                            <th class="text-center" style="min-width:100px;">{stats:type}</th>
                            <th class="text-center">{stats:visit}</th>
                        </tr>
                    </thead>
                    {if isset($visits) && !empty($visits)}
                        <tbody>
                            {foreach item=visit from=$visits name=visits}
                                <tr id="visit-{$visit->visitId}" {if isset($visit->isHidden)}style="display:none"{/if}>
                                    <td class="text-center" align="right" nowrap="nowrap">{if isset($visit->visitDate)}{$visit->visitDate}{/if}</td>
                                    <td  nowrap="nowrap">
                                        {if isset($visit->typeId) && $visit->typeId eq 6}
                                            <span class="code{if isset($visit->errorCode)}{$visit->errorCode}{/if}">{stats:error} {if isset($visit->errorCode)}{$visit->errorCode}{/if}</span>
                                        {else}
											{if isset($visit->typeName)}{$visit->typeName nofilter}{/if}
                                        {/if}
                                    </td>
                                    <td class="data" width="100%">
                                        {if isset($visit->typeId) and $visit->typeId eq 1}
                                            <a href="{$SITE_URL}/" target="_blank">{stats:homePage}</a>
                                        {elseif isset($visit->typeId) && $visit->typeId eq 2 && isset($visit->name)}
                                            <a href="{$visit->url}" target="_blank">{$visit->name|truncate:60}</a>
                                        {elseif isset($visit->typeId) &&  $visit->typeId eq 3 && isset($visit->title)}
                                            <a href="{$visit->url}" target="_blank">{$visit->title|truncate:60}</a>
                                        {elseif isset($visit->typeId) && $visit->typeId eq 4}
                                            <a href="{$SITE_URL}/search.php?query={$visit->searchQuery|escape:'url'}&page={$visit->searchPage}" target="_blank">{$visit->searchQuery|truncate:60}</a>
                                        {elseif isset($visit->typeId) && $visit->typeId eq 6}
                                            <a href=" {if isset($visit->requestUri)}{$visit->requestUri}{/if}" target="_blank">{if isset($visit->requestUri)}{$visit->requestUri|truncate:60}{/if}</a>
												{if isset($visit->refererUrl)} (<a href="{$visit->refererUrl}" target="_blank">{"{stats:referer}"}</a>) {/if}
                                        {elseif isset($visit->typeId) && $visit->typeId eq 7}
                                            {if !isset($visit->section)}
                                                <a href="{$SITE_URL}/rss.xml" target="_blank">{stats:genRss}</a>
                                            {elseif $visit->section}
                                                <a href="{$visit->section->path}/rss.xml" target="_blank">{$visit->section->name|truncate:60}</a>
                                            {else}
                                                {stats:unknown}
                                            {/if}
                                        {elseif isset($visit->typeId) && $visit->typeId eq 8}
                                            <a href="{$SITE_URL}/sitemap.{$config.file_extension}" target="_blank">{stats:genSitemap}</a>
                                        {elseif isset($visit->typeId) && $visit->typeId eq 9}
                                            <a href="{$SITE_URL}/sitemap.xml" target="_blank">{stats:xmlSitemap}</a>
                                        {elseif isset($visit->typeId) && $visit->typeId eq 10}
                                            <a href="{$visit->url}" target="_blank">{$visit->alias|default:$visit->title|truncate:60}</a>
                                        {elseif isset($visit->typeId) && $visit->typeId eq 11}
                                            <a href="{$visit->url}" target="_blank">{$visit->alias|default:$visit->title|truncate:60}</a>
                                        {elseif isset($visit->typeId) && $visit->typeId eq 12}
                                            <a href="{$visit->url}" target="_blank">{$visit->alias|default:$visit->title|truncate:60}</a>
                                        {elseif isset($visit->typeId) && $visit->typeId eq 13}
                                            <a href="{$visit->url}" target="_blank">{$visit->alias|default:$visit->title|truncate:60}</a>
                                        {else}
                                            {stats:unknown}
                                        {/if}
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
						{if isset($pageNums) && $pageNums > 0}
                        <tfoot>
							<tr>
								<td colspan="3">
									<div class="">{general:results}</div>
									{if isset($pageNums.pages)}
										<ul class="pagination-flat justify-content-center twbs-visible-pages pagination">
											{foreach from=$pageNums.pages item=number}
												{if $number eq $page}
													<li  class="page-item active">
														<a class="page-link" href="index.php?mod=visitor&visitorId={$visitorId}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}&page={$number}">{$number}</a>
													</li>
												{elseif $number eq '...'}
													<li class="page-item"><a class="page-link">...</a></li>
												{else}
													<li  class="page-item">
														<a class="page-link" href="index.php?mod=visitor&visitorId={$visitorId}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}&page={$number}">{$number}</a>
													</li>
												{/if}
											{/foreach}
										</ul>
									{/if}
								</td>
							</tr>
                        </tfoot>
						{/if}
                    {else}
                        <tbody><tr><td colspan="3" align="center">- {general:none} -</td></tr></tbody>
                    {/if}

                </table>
            </div>
        </div>
	</div>
</div>
<!-- /content area -->