<?php

namespace Mnv\Core\Files\Image;

/**
 * Class ImageSizes
 * @package Mnv\Core\Files\Image
 */
final class ImageSizes
{

    /**
     * The instance itself
     * @var ImageSizes
     */
    private static $instance;

    public $original;
    public $fileFormat;
    public $fileName;

    private static $sizes = array('large', 'medium', 'small');

    private function __construct() { }
    /**
     * Returns the instance of the class.
     * @return ImageSizes
     */
    public static function init()
    {
        // Create it if it doesn't exist.
        if (!self::$instance) {
            self::$instance = new ImageSizes();
        }
        return self::$instance;
    }

    /**
     * @param $image
     * @param $file
     * @return ImageSizes
     */
    public static function get($image, $file)
    {

        $imageSizes             = $image ?? new ImageSizes;
        $imageSizes->fileFormat = self::fileExtension($file->fileName);
        $imageSizes->fileName   = $file->fileName;


        if (file_exists(GLOBAL_ROOT . $file->path . $file->fileName)) $imageSizes->original = $file->path . $file->fileName;
        /** получим все размеры */
        foreach (self::$sizes as $size) {
            if (file_exists(GLOBAL_ROOT . $file->path . $size . '/' . $file->fileName))  $imageSizes->{$size} = $file->path . $size  . '/' . $file->fileName;
        }

        /** если это `svg` получим все размеры из оригинальной */
        if ($imageSizes->fileFormat == 'svg') {
            foreach (self::$sizes as $size) {
                if (file_exists(GLOBAL_ROOT . $file->path . $file->fileName))  $imageSizes->{$size} = $file->path . $file->fileName;
            }
        }

        return $imageSizes;
    }


    /**
     * получить расширение файла
     *
     * @param $name
     * @return false|string
     */
    public static function fileExtension($name)
    {
        $n = strrpos($name, '.');
        return ($n === false) ? '' : substr($name, $n+1);
    }




}