<?php

namespace Mnv\Core\Locale;

use League\Flysystem\Filesystem;
use League\Flysystem\FileAttributes;
use League\Flysystem\FilesystemException;
use League\Flysystem\Local\LocalFilesystemAdapter;
use League\Flysystem\UnixVisibility\PortableVisibilityConverter;

class BackendTranslations
{
    /** @var $_initializedLang */
    private $_initializedLang;

    /** @var  Filesystem */
    private $filesystem;

    /** @var array $lang */
    public $lang = array();

    public function __construct() { }

    public function init($langLabel = 'ru')
    {
        if ($this->_initializedLang === $langLabel) {
            return;
        }

        $adapter = new LocalFilesystemAdapter(GLOBAL_ROOT . "/admin/languages/",
            PortableVisibilityConverter::fromArray([
                'file' => [
                    'public' => 0666,
                    'private' => 0644
                ],
                'dir' => [
                    'public' => 0777,
                    'private' => 0755
                ]
            ]),
            LOCK_EX,
            LocalFilesystemAdapter::DISALLOW_LINKS
        );

        $this->filesystem = new Filesystem($adapter, ['directory_visibility' => 'public', 'visibility' => 'public']);

        if ( $this->filesystem->fileExists($langLabel . ".inc.php")) {
            $this->lang = include(GLOBAL_ROOT . "/admin/languages/" . $langLabel . ".inc.php");
        }

        $this->_initializedLang = $langLabel;
    }


    /**
     * добавление перевода к уже существующему набору
     * @param $var
     * @param $translation
     */
    public function add($var, $translation)
    {
        $var = preg_replace('~[^\w]~', '', $var);
        $this->$var = $translation;

//        print_r($this);
    }

    /**
     *  Translate language variable wrapper (for usage in templates and scripts)
     * @param string $tag
     * @param string|null $default
     * @return array|string
     */
    public function __(string $tag, ?string $default = '')
    {
        $text = getTagVal($tag, $default);
        return !empty($text) ? $this->array2unicode($text) : '';
    }

    /**
     * @param string $tag
     * @param string|null $default
     * @return array|string
     */
    public function lang(string $tag, ?string $default = null)
    {
        $text = $this->getTagVal($tag, $default);
        return $this->array2unicode($text);
    }

    /**
     * @param string $tag
     * @param string|null $default
     * @return array|string
     */
    public function langJs(string $tag, ?string $default = null)
    {
        $text = $this->getTagVal($tag, $default);
        return $this->array2js($text);
    }

    /**
     * @param $date
     * @return array|string
     */
    public function langDate($date)
    {
        $date = strtr($date, $this->lang['dates']);
        return $this->array2unicode($date);
    }

    /**
     * @param string $tag
     * @param string|null $default
     * @return int
     */
    public function langlen(string $tag, ?string $default = null)
    {
        $text = $this->getTagVal($tag, $default);
        return strlen($text);
    }


    /**
     * @param string $tag
     * @param string|null $default
     * @return mixed
     */
    private function getTagVal(string $tag,?string  $default = null)
    {
        $result = null;

        $keys = explode(':', $tag);

        switch (count($keys)) {
            case 1:
                $result = $this->lang[$keys[0]] ?? $default;
                break;
            case 2:
                $result = $this->lang[$keys[0]][$keys[1]] ?? $default;
                break;
            case 3:
                $result = $this->lang[$keys[0]][$keys[1]][$keys[2]] ?? $default;
                break;
            case 4:
                $result = $this->lang[$keys[0]][$keys[1]][$keys[2]][$keys[3]] ?? $default;
                break;
        }

        return $result;
    }

    /**
     * @param $var
     * @return array|string
     */
    private function array2unicode($var)
    {
        if (is_array($var)) {
            return array_map(array($this, 'array2unicode'), $var);
        } else {
            return $this->text2unicode($var, $this->lang['charset']);
        }
    }

    /**
     * @param $text
     * @param $encoding
     * @return string
     */
    private function text2unicode($text, $encoding): string
    {
        mb_internal_encoding('UTF-8');

        return mb_convert_encoding($text, 'UTF-8', $encoding);
    }


    /**
     * @param $source
     * @return null|string|string[]
     */
    public function replaceLanguageTags($source)
    {
        if (!isset($this->lang)) $this->loadLanguage($this->_initializedLang);

        return preg_replace_callback('/{([0-9a-zA-Z_\-:]+?)}/', array($this, '_replace_lang_tags_callback'), $source);
    }

    /**
     * @param $matches
     * @return array|string
     */
    private function _replace_lang_tags_callback($matches)
    {

        $text = $this->getTagVal($matches[1], $matches[0]);

        return $this->array2unicode($text);
    }

    /**
     * @param $var
     * @return array|string
     */
    private function array2js($var)
    {
        if (is_array($var)) {
            return array_map(array($this, 'array2js'), $var);
        } else {
            return $this->text2js($var, $this->lang['charset']);
        }
    }

    /**
     * @param string $text
     * @param string $encoding
     * @return string
     */
    private function text2js(string $text, string $encoding): string
    {
        return $this->text2unicode($text, $encoding);
    }



    /**
     * @param $language
     */
    function loadLanguage($language)
    {
        if ( $this->filesystem->fileExists($language . ".inc.php")) {
            $this->lang = include(GLOBAL_ROOT.'/admin/languages/'.$language.'.inc.php');
        } else {
            $this->lang = include(GLOBAL_ROOT . '/admin/languages/ru.inc.php');
        }
    }


    /**
     * Получаем существующие языки
     * @return array Array ( [ru] => Русский [en] => English )
     */
    public function getLanguages(): array
    {
        $listing = array();
        $languages = array();
        try {
            $listing = $this->filesystem->listContents('/', false)->sortByPath();
        } catch (FilesystemException $e) {
            print_r($e->getMessage());
        }

        foreach ($listing as $item) {
            if ($item instanceof FileAttributes) {
                if (!in_array($item->path(), array('.','..', '.DS_Store'))) {
                    $lang = include(GLOBAL_ROOT."/admin/languages/".$item->path());
                    $languages[$lang['codeName']] = $this->text2unicode($lang['langName'], $lang['charset']);
                }
            }
        }

        return array_reverse($languages);

    }

    public function __destruct()
    {
//        echo 'C';
    }


}