<?php

namespace Mnv\Core\Locale;

/**
 * Class Charset
 * @package Mnv\App\Locale
 */
class Charset
{

    /**
     * @var string[]
     */
    public static $languageCharsets = array(
        'ab' => 'windows-1252',
        'ar' => 'windows-1256',
        'hy' => 'windows-1252',
        'az' => 'windows-1252',
        'eu' => 'windows-1252',
        'be' => 'windows-1250',
        'bn' => 'utf-8',
        'bs' => 'utf-8',
        'bg' => 'windows-1251',
        'ca' => 'windows-1252',
        'zh' => 'big5',
        'hr' => 'windows-1250',
        'cs' => 'windows-1250',
        'da' => 'windows-1252',
        'nl' => 'windows-1252',
        'en' => 'utf-8',
        'eo' => 'windows-1252',
        'et' => 'windows-1257',
        'fo' => 'windows-1252',
        'fi' => 'windows-1252',
        'fr' => 'windows-1252',
        'ka' => 'windows-1252',
        'de' => 'windows-1252',
        'el' => 'windows-1253',
        'he' => 'windows-1255',
        'hi' => 'utf-8',
        'hu' => 'windows-1250',
        'id' => 'windows-1252',
        'ga' => 'windows-1252',
        'it' => 'windows-1252',
        'ja' => 'iso-2022-jp',
        'kk' => 'windows-1252',
        'ky' => 'windows-1252',
        'ko' => 'iso-2022-kr',
        'ku' => 'utf-8',
        'la' => 'windows-1252',
        'lv' => 'windows-1257',
        'lt' => 'windows-1257',
        'mk' => 'utf-8',
        'ms' => 'windows-1252',
        'mo' => 'utf-8',
        'mn' => 'utf-8',
        'no' => 'windows-1252',
        'os' => 'windows-1252',
        'fa' => 'utf-8',
        'pl' => 'windows-1250',
        'pt' => 'windows-1252',
        'ro' => 'windows-1250',
        'ru' => 'utf-8',
        'sa' => 'utf-8',
        'sr' => 'windows-1251',
        'sk' => 'windows-1250',
        'sl' => 'windows-1250',
        'es' => 'windows-1252',
        'sv' => 'windows-1252',
        'tg' => 'windows-1252',
        'tt' => 'windows-1252',
        'th' => 'windows-874',
        'tr' => 'windows-1254',
        'tk' => 'windows-1252',
        'ug' => 'windows-1252',
        'uk' => 'windows-1251',
        'uz' => 'utf-8',
        'vi' => 'windows-1258',
    );

    /**
     * @var string[]
     */
    public static $charsetOptions = array(
        'utf-8'                => 'Unicode (UTF-8)',
        'ASMO-708'             => 'Arabic (ASMO 708)',
        'DOS-720'              => 'Arabic (DOS)',
        'iso-8859-6'           => 'Arabic (ISO)',
        'x-mac-arabic'         => 'Arabic (Mac)',
        'windows-1256'         => 'Arabic (Windows)',
        'ibm775'               => 'Baltic (DOS)',
        'iso-8859-4'           => 'Baltic (ISO)',
        'windows-1257'         => 'Baltic (Windows)',
        'ibm852'               => 'Central European (DOS)',
        'iso-8859-2'           => 'Central European (ISO)',
        'x-mac-ce'             => 'Central European (Mac)',
        'windows-1250'         => 'Central European (Windows)',
        'EUC-CN'               => 'Chinese Simplified (EUC)',
        'gb2312'               => 'Chinese Simplified (GB2312)',
        'hz-gb-2312'           => 'Chinese Simplified (HZ)',
        'x-mac-chinesesimp'    => 'Chinese Simplified (Mac)',
        'big5'                 => 'Chinese Traditional (Big5)',
        'x-Chinese-CNS'        => 'Chinese Traditional (CNS)',
        'x-Chinese-Eten'       => 'Chinese Traditional (Eten)',
        'x-mac-chinesetrad'    => 'Chinese Traditional (Mac)',
        'cp866'                => 'Cyrillic (DOS)',
        'iso-8859-5'           => 'Cyrillic (ISO)',
        'koi8-r'               => 'Cyrillic (KOI8-R)',
        'koi8-u'               => 'Cyrillic (KOI8-U)',
        'x-mac-cyrillic'       => 'Cyrillic (Mac)',
        'windows-1251'         => 'Cyrillic (Windows)',
        'x-Europa'             => 'Europa',
        'x-IA5-German'         => 'German (IA5)',
        'ibm737'               => 'Greek (DOS)',
        'iso-8859-7'           => 'Greek (ISO)',
        'x-mac-greek'          => 'Greek (Mac)',
        'windows-1253'         => 'Greek (Windows)',
        'ibm869'               => 'Greek, Modern (DOS)',
        'DOS-862'              => 'Hebrew (DOS)',
        'iso-8859-8-i'         => 'Hebrew (ISO-Logical)',
        'iso-8859-8'           => 'Hebrew (ISO-Visual)',
        'x-mac-hebrew'         => 'Hebrew (Mac)',
        'windows-1255'         => 'Hebrew (Windows)',
        'ibm861'               => 'Icelandic (DOS)',
        'x-mac-icelandic'      => 'Icelandic (Mac)',
        'x-iscii-as'           => 'ISCII Assamese',
        'x-iscii-be'           => 'ISCII Bengali',
        'x-iscii-de'           => 'ISCII Devanagari',
        'x-iscii-gu'           => 'ISCII Gujarathi',
        'x-iscii-ka'           => 'ISCII Kannada',
        'x-iscii-ma'           => 'ISCII Malayalam',
        'x-iscii-or'           => 'ISCII Oriya',
        'x-iscii-pa'           => 'ISCII Panjabi',
        'x-iscii-ta'           => 'ISCII Tamil',
        'x-iscii-te'           => 'ISCII Telugu',
        'euc-jp'               => 'Japanese (EUC)',
        'iso-2022-jp'          => 'Japanese (JIS)',
        'x-mac-japanese'       => 'Japanese (Mac)',
        'shift_jis'            => 'Japanese (Shift-JIS)',
        'ks_c_5601-1987'       => 'Korean',
        'euc-kr'               => 'Korean (EUC)',
        'iso-2022-kr'          => 'Korean (ISO)',
        'Johab'                => 'Korean (Johab)',
        'x-mac-korean'         => 'Korean (Mac)',
        'iso-8859-3'           => 'Latin 3 (ISO)',
        'iso-8859-15'          => 'Latin 9 (ISO)',
        'x-IA5-Norwegian'      => 'Norwegian (IA5)',
        'IBM437'               => 'OEM United States',
        'x-IA5-Swedish'        => 'Swedish (IA5)',
        'windows-874'          => 'Thai (Windows)',
        'ibm857'               => 'Turkish (DOS)',
        'iso-8859-9'           => 'Turkish (ISO)',
        'x-mac-turkish'        => 'Turkish (Mac)',
        'windows-1254'         => 'Turkish (Windows)',
        'unicode'              => 'Unicode',
        'unicodeFFFE'          => 'Unicode (Big-Endian)',
        'utf-7'                => 'Unicode (UTF-7)',
        'us-ascii'             => 'US-ASCII',
        'windows-1258'         => 'Vietnamese (Windows)',
        'ibm850'               => 'Western European (DOS)',
        'x-IA5'                => 'Western European (IA5)',
        'iso-8859-1'           => 'Western European (ISO)',
        'macintosh'            => 'Western European (Mac)',
        'windows-1252'         => 'Western European (Windows)',
    );

}