<?php

namespace Mnv\Core\Test;


/**
 * Class Testing
 * @package Mnv\Models
 */
class Testing
{

    public $show_debug    = false;
    public static $existErrors;
    public static $fileLog;

    /**
     * Testing constructor.
     */
    public function __construct($testing = false)
    {
        $this->show_debug = $testing;

        $gmDate = adjustTime(gmdate('Y-m-d H:i:s'), false, 'Y-m-d');

        self::$fileLog = ERRORSLOG . 'app-'.$gmDate.'.log';


        set_error_handler(array($this, 'debug_critical_error'));
		# default : error hide
		self::error_report($testing);
        # check error log
        self::check_errorlog();

    }


    private static function check_errorlog()
    {
		if (is_file(self::$fileLog) && filesize(self::$fileLog) != 0) {
			self::$existErrors = true;
		}

		if (is_file(SYSERRLOG) && filesize(SYSERRLOG) != 0) {
            self::$existErrors = true;
		}
	}


	/**
	 * System Error Interceptor
	 *
	 * @param mixed $errno - error number
	 * @param mixed $msg   - message od error
	 * @param mixed $file  - filename with error
	 * @param mixed $line  - string number with error
	 *
	 * @return null|boolean
	 */
	public function debug_critical_error($errno, $msg, $file, $line)
	{

        $subj = file_read(self::$fileLog);

        switch($errno) {
	        case E_ERROR:			# critical
		        $erlevel = 0;
                $ercode  = "E_ERROR";
		        break;

	        case E_USER_ERROR:		# critical
		        $erlevel = 0;
                $ercode  = "E_USER_ERROR";
		        break;

	        case E_RECOVERABLE_ERROR :	# warning(?)critical
		        $erlevel = 1;
                $ercode  = "E_RECOVERABLE_ERROR";
		        break;

	        case E_WARNING:			# warning
		        $erlevel = 1;
                $ercode  = "E_WARNING";
		        break;

	        case E_USER_WARNING:		# warning
		        $erlevel = 1;
                $ercode  = "E_USER_WARNING";
		        break;

	        case E_CORE_WARNING:		# warning
		        $erlevel = 1;
                $ercode  = "E_CORE_WARNING";
		        break;

	        case E_COMPILE_WARNING:		# warning
		        $erlevel = 1;
                $ercode  = "E_COMPILE_WARNING";
		        break;

	        case E_NOTICE:			# notice
		        $erlevel = 2;
		        $ercode  = "E_NOTICE";
		        break;

	        case E_USER_NOTICE:		# notice
		        $erlevel = 2;
                $ercode  = "E_USER_NOTICE";
		        break;

	        default:			# unknown
		        $erlevel = 3;
                $ercode  = "";
		        break;
        }

        $time = date("d.m.Y H:i");


        $subj .= $time . " | " . getenv('REMOTE_ADDR') . " | " . $_SERVER['REQUEST_URI'] . " | " . $ercode . " | " . $errno . " | " . $msg . " | " . $line . " | " . $file . "\r\n";

        $f = fopen(self::$fileLog, "w+");
        if (is_writable(self::$fileLog)) {
            fwrite($f, $subj);
        }
        fclose($f);

		# hide error if not use debug mode
		if (error_reporting() == 0 && $erlevel == 0) {
			die("<blockquote style='padding: 1rem; margin: .2rem .4rem;border: 1px solid moccasin;background-color: lemonchiffon;color: #1e1e1e;font-size: .85rem;'>
					Извините, что то пошло не так. Мы уже работаем над устранением причин. <small>".$time."</small> 
				    <a href='javascript:history.back(1)'>< Вернуться назад</a></blockquote>");
		}

        if ($this->show_debug) {
            print "<div style='padding: 1rem; margin: .2rem .4rem;border: 1px solid red;background-color: moccasin;color: #1e1e1e;font-size: .85rem;z-index: 100;position: relative;'>
			Error: <b> #{$errno} - {$ercode}</b>
			<br />Строка: <b>{$line}</b> в файле <b>{$file}</b>
			<br /><b>{$msg}</b>
			</div>\n";

		} else {
            print "<!--\r\n";
            print "
			Error: <b> #{$errno} - {$ercode}</b>
			<br />Строка: <b>{$line}</b> в файле <b>{$file}</b>
			<br /><b>{$msg}</b>\n";
            print "-->";
        }

		# Мы убиваем стандартного обработчика, чтобы он ничего не выдал шпиону (:
		return true;
	}

	private static function error_report($show = false)
	{
		ini_set("error_log", SYSERRLOG);
		if ($show) {
			error_reporting(E_ALL);			     #8191
			ini_set("display_startup_errors",	1);
			ini_set("display_errors",		    1);
			ini_set("html_errors",			    1);
			ini_set("report_memleaks",		    1);
			ini_set("track_errors",			    1);
			ini_set("log_errors",			    1);
			ini_set("log_errors_max_len",		2048);
			ini_set("ignore_repeated_errors",	1);
			ini_set("ignore_repeated_source",	1);
		}
		else {

			error_reporting(0);
		}
	}



    public static function productivityTime($startTime): float
    {
        $endTime = microtime(true);
        return round(($endTime - $startTime), 4);
    }

    public static function memoryPeakUsage(): float
    {
        return round((memory_get_peak_usage()/1024)/1024, 2);
    }

    public static function productivityMemory(): float
    {
        return round((memory_get_usage() / 1024)/1024, 2);
    }
}