<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class BannerGroups
 * @package Mnv\Models
 */
class BannerGroups extends Mnv
{

    private static $_table = 'banners_group';

    /** @var $groups */
    public $groups;

    /** @var $group */
    public $group;

    /** @var $groupId */
    public $groupId;

    /** @var $total */
    public $total;

    /**
     * BannersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Все группы со статусом `visible` для select
     * @return array
     */
    public function getGroups(): array
    {
        $groupSelects = array('' => lang('general:select'));
        if ($groups = DB::init()->connect()->table(self::$_table)->where('status', 'visible')->orderBy('orderBy')->indexKey('groupId')->getAllIndexes()) {
            foreach ($groups as $groupId => $group)
                $groupSelects[$groupId] = $group->name;
        }
        return $groupSelects;
    }

    /**
     * Все группы
     */
    public function get(): void
    {
        if ($this->groups = DB::init()->connect()->table(self::$_table)->orderBy('orderBy')->indexKey('groupId')->getAllIndexes()) {
            foreach ($this->groups as $groupId => &$group) {
                $group->statusName = lang('general:statuses:' . $group->status);
                $group->pages = explode(',', $group->pages);
                foreach ($group->pages as $page)
                    $this->groups[$groupId]->pageNames[$page] = DB::init()->connect()->table('sections')->select('name')->where('sectionId', $page)->getValue();
            }
        }
    }

    /**
     * Кол-во групп
     */
    public function total(): void
    {
        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }


    /**
     * Редактировать группу
     */
    public function edit(): void
    {
        if (!empty($this->groupId)) {
            $this->group = DB::init()->connect()->table(self::$_table)->where('groupId', $this->groupId)->get();
            $this->group->pages = explode(',',  $this->group->pages);
        }
    }


    /**
     * Новыя группа
     *
     * @param $group
     * @return bool
     */
    public function add($group): bool
    {
        $group->orderBy = DB::init()->connect()->table(self::$_table)->max('orderBy')->getValue() + 1;
        if ($this->groupId = DB::init()->connect()->table(self::$_table)->insert((array)$group)) return true;

        return false;
    }

    /**
     * Обновление группы
     *
     * @param $group
     * @return bool
     */
    public function update($group): bool
    {
        if (!empty($this->groupId)) {
            DB::init()->connect()->table(self::$_table)->where('groupId', $this->groupId)->update((array)$group);
            $this->edit();

            return true;
        }

        return false;
    }

    /**
     * Сортировка групп
     *
     * @param $groupIds
     */
    public function reorder($groupIds)
    {
        $i = 0;
        foreach ($groupIds as $groupId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('groupId', $groupId)->update(['orderBy' => $i]);
        }
    }
    /**
     * Скрать / показать группу
     *
     * @return array
     */
    public function status(): array
    {

        if ($slider = DB::init()->connect()->table(static::$_table)->where('groupId', $this->groupId)->get()) {
            $sliderUpdate['status'] = ($slider->status == 'visible') ? 'hidden' : 'visible';
            DB::init()->connect()->table(static::$_table)->where('groupId', $this->groupId)->update($sliderUpdate);
            return array('data' => true, 'status' => $sliderUpdate['status']);
        }

        return array('data' => false);
    }

    /**
     * удаление группы
     *
     * @return bool
     */
    public function remove(): bool
    {
        if (!empty($this->groupId)) {
            if (DB::init()->connect()->table(static::$_table)->where('groupId', $this->groupId)->delete()) return true;
        }
        return false;
    }

}