<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;
use Mnv\Core\Files\Image\ImageSizes;

/**
 * Class BannerImages
 * @package Mnv\Models
 */
class BannerImages extends Mnv
{

    private static $_table  = 'banners_images';
    private static $_files = 'files';

    public $banners;
    public $banner;
    public $bannerId;
    public $total;


    /**
     * SlidersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return int|mixed
     */
    public function getAll(): void
    {
        $this->banners = DB::init()->connect()->table(static::$_table)->orderBy('orderBy')->getAll();
        foreach ($this->banners as &$banner) {
            $banner->statusName = lang('general:statuses:' .  $banner->status);
            $banner->groupName  = DB::init()->connect()->table('banners_group')->select('name')->where('groupId', $banner->groupId)->getValue();
            if (!empty($banner->fileId) && $banner->fileId > 0) $banner->image = $this->get_image($banner->fileId);
        }


    }

    public function total(): void
    {
        $this->total = DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue();
    }


    public function edit()
    {
        if ($this->banner = DB::init()->connect()->table(static::$_table)->where('bannerId', $this->bannerId)->get()) {
            if (!empty($this->banner->fileId) && $this->banner->fileId > 0) $this->banner->image = $this->get_image($this->banner->fileId);
        }
    }

    /**
     * Получение картинок к слайду
     *
     * @param int $fileId
     * @return ImageSizes|null
     */
    public function get_image(int $fileId): ?ImageSizes
    {
        $image = null;
        if ($file = DB::init()->connect()->table(static::$_files)->where('fileId', $fileId)->get())
            $image = ImageSizes::init()->get(null, $file);

        return $image;
    }

    /**
     * Новый слайд
     * @param $banner
     * @return bool
     */
    public function add($banner): bool
    {
        $banner->orderBy = DB::init()->connect()->table(static::$_table)->max('orderBy')->getValue() + 1;
        if ($this->bannerId = DB::init()->connect()->table(static::$_table)->insert((array)$banner)) return true;

        return false;
    }

    /**
     * Обновление слайда
     *
     * @param $banner
     * @return bool
     */
    public function update($banner): bool
    {
        if (!empty($this->bannerId)) {
            if (DB::init()->connect()->table(static::$_table)->where('bannerId',  $this->bannerId)->update((array)$banner)) {
                $this->edit();

                return true;
            }
        }
        return false;
    }




    /**
     * удалене картинка слайда
     * @param int|null $sliderId
     * @return bool
     */
    public function deleteImage(?int $sliderId): bool
    {
        if (!empty($sliderId)) {
            DB::init()->connect()->table(static::$_table)->where('bannerId', $this->bannerId)->update(['fileId' => 0]);
            return true;
        }
        return false;
    }

    /**
     * Сортировка слайдов
     *
     * @param $bannerIds
     */
    public function reorder($bannerIds)
    {
        $i = 0;
        foreach ($bannerIds as $bannerId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('bannerId', $bannerId)->update(['orderBy' => $i]);
        }
    }

    /**
     * Скрать / показать раздел
     *
     * @return array
     */
    public function status(): array
    {
        if (!empty($this->bannerId)) {
            if ($slider = DB::init()->connect()->table(static::$_table)->where('bannerId', $this->bannerId)->get()) {
                $sliderUpdate['status'] = ($slider->status == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(static::$_table)->where('bannerId', $this->bannerId)->update($sliderUpdate);
                return array('data' => true, 'status' => $sliderUpdate['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }

    /**
     * удаление слайда
     *
     * @return bool
     */
    public function remove(): bool
    {
        if (!empty($this->bannerId)) {
            if (DB::init()->connect()->table(static::$_table)->where('bannerId', $this->bannerId)->delete()) return true;
        }
        return false;
    }

}