<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Banners
 * @package Mnv\Models
 */
class Banners extends Mnv
{

    private static $_table = 'banners';

    /**
     * BannersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Получение всех банеров
     * @return int
     */
    public function getAllBanners()
    {
        return DB::init()->connect()->table(static::$_table)->orderBy('bannerId')->getAll();
    }

    /**
     * Получение банера для редактирования
     * @param $bannerId
     * @return string
     */
    public function editBanner($bannerId)
    {
        if ($banner = DB::init()->connect()->table(static::$_table)->where('bannerId', $bannerId)->get()) return $banner;

        return null;
    }

    /**
     * Сохранение или изменение банера
     * @param $banner
     * @return bool|int
     */
    public function newBanner($banner)
    {

        unset($banner['bannerId']);
        if ($bannerId = DB::init()->connect()->table(static::$_table)->insert($banner)) return $bannerId;

        return false;
    }

    public function updateBanner($banner)
    {
        if (DB::init()->connect()->table(static::$_table)->where('bannerId', $banner['bannerId'])->update($banner)) return true;

        return false;
    }


    /**
     * TODO сделано
     * Удаление баннера
     * @param $bannerId
     * @return bool
     */
    public function remove($bannerId)
    {
        if (!empty($bannerId)) {
            $bannerFile =  DB::init()->connect()->table(static::$_table)->select('fileUrl')->where('bannerId',$bannerId)->getValue();
            if (!empty($bannerFile)) @unlink(SITE_ROOT . '/' . $bannerFile);
            DB::init()->connect()->table(static::$_table)->where('bannerId', $bannerId)->delete();
            return true;
        }
        return false;
    }


}