<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Currencies
 * @package Mnv\Models
 */
class Currencies extends Mnv
{
    private static $_table = 'shop_currency';

    public $currencies;
    public $currency;
    public $currencyId;

    /**
     * CurrencyAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function getAll(): void
    {
        $this->currencies = DB::init()->connect()->table(self::$_table)->orderBy('isDefault', 'DESC')->getAll();
    }


    public function edit()
    {
        if (isset($this->currencyId))	{
            $this->currency = DB::init()->connect()->table(self::$_table)->where('id',  $this->currencyId)->get();
        }
    }

    /**
     * TODO сделано
     * @param $currency
     * @return bool
     */
    public function add($currency): bool
    {
        if ($this->currencyId = DB::init()->connect()->table(self::$_table)->insert((array)$currency)) return true;

        return false;
    }

    /**
     * TODO сделано
     * @param $currency
     * @return bool
     */
    public function update($currency): bool
    {
        if (!empty($this->currencyId)) {
            if (DB::init()->connect()->table(self::$_table)->where('id', $this->currencyId)->update((array)$currency)) return true;
        }

        return false;
    }

    /**
     * Удаление курса
     *
     * @return bool
     */
    public function remove(): bool
    {
        if (!empty($this->currencyId)) {
            if (DB::init()->connect()->table(self::$_table)->where('id', $this->currencyId)->delete()) return true;
        }
        return false;
    }

    /**
     * Сортировка слайдов
     *
     * @param $currencyIds
     */
    public function reorder($currencyIds)
    {
        $i = 0;

        foreach ($currencyIds as $currencyId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('id', $currencyId)->update(['isDefault' => ($i == 1) ? 1 : 0]);
        }
    }



    public function getDefaultCurrency()
    {
        return DB::init()->connect()->table(self::$_table)->where('isDefault',1)->get();
    }


}