<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class FAQ
 * @package Mnv\Models
 */
class FAQ extends Mnv
{

    private static $_table  = 'faq';

    public $faq;
    public $faqId;
    public $faqs;
    public $total;

    /**
     * SlidersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }


    public function getAll(): void
    {
        $this->faqs = DB::init()->connect()->table(static::$_table)->orderBy('orderBy')->getAll();
        foreach ($this->faqs as &$faq)
            $faq->statusName = lang('general:statuses:' .  $faq->status);
    }


    public function total(): void
    {
        $this->total = DB::init()->connect()->table(static::$_table)->count('*', 'count')->getValue();
    }



    public function edit(): void
    {
        if (!empty($this->faqId)) {
            $this->faq = DB::init()->connect()->table(static::$_table)->where('faqId', $this->faqId)->get();
        }
    }


    /**
     * Новый слайд
     * @param $faq
     * @return bool
     */
    public function add($faq): bool
    {
        $faq->orderBy = DB::init()->connect()->table(static::$_table)->max('orderBy')->getValue() + 1;
        if ($this->faqId = DB::init()->connect()->table(static::$_table)->insert((array)$faq)) return true;

        return false;
    }

    /**
     * Обновление слайда
     *
     * @param $faq
     * @return bool
     */
    public function update($faq): bool
    {
        if (!empty($this->faqId)) {
            DB::init()->connect()->table(static::$_table)->where('faqId', $this->faqId)->update((array)$faq);
            $this->edit();

            return true;
        }
        return false;
    }

    /**
     * Сортировка слайдов
     *
     * @param $faqIds
     */
    public function reorder($faqIds): void
    {
        $i = 0;
        foreach ($faqIds as $faqId) {
            $i++;
            DB::init()->connect()->table(self::$_table)->where('faqId', $faqId)->update(['orderBy' => $i]);
        }

    }
    /**
     * Скрать / показать
     *
     * @return array
     */
    public function status(): array
    {
        if (!empty($this->faqId)) {
            if ($faq = DB::init()->connect()->table(static::$_table)->where('faqId', $this->faqId)->get()) {
                $faqUpdate['status'] = ($faq->status == 'visible') ? 'hidden' : 'visible';
                DB::init()->connect()->table(static::$_table)->where('faqId', $this->faqId)->update($faqUpdate);
                return array('data' => true, 'status' => $faqUpdate['status']);
            }

            return array('data' => false);
        }

        return array('data' => false);
    }


    /**
     * удаление слайда
     *
     * @return bool
     */
    public function remove(): bool
    {
        if (!empty($this->faqId)) {
            if (DB::init()->connect()->table(static::$_table)->where('faqId', $this->faqId)->delete()) return true;
        }
        return false;
    }

}