<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

/**
 * Class Feedbacks
 * @package Mnv\Models
 */
class Feedbacks extends Mnv
{

    private static $_table = 'feedback';

    const STATE_CREATED                  = 1;
    const STATE_READ                     = 2;
    const STATE_STARRED                  = 3;
    const STATE_SENT                     = 4;
    const STATE_IMPORTANT                = 5;
    const STATE_SPAM                     = 6;
    const STATE_DELETED                  = 7;
    const STATE_SHARE                    = 8;


    public $id;
    public $mail;
    public $mails;
    /**
     * кол-во
     * @var $total
     */
    public $total;

    /**
     * кол-во при фильтрации
     * @var $total
     */
    public $totalFiltered;

    public $colours = array( "#45b0e6", "#b8c1d9", "#006098", "#56bf68", "#8f98b3", "#9161f3", "#e673bf", "#ffcc33", "#47ccc1", "#3d88f2", "#f39718", "#e64545" );


    /**
     * Feedbacks constructor.
     */
    public function __construct()
    {
        parent::__construct();

        $this->mail = new PHPMailer();

//        if ($this->config['mail_transport'] == 'smtp') {
            $this->mail->CharSet    = $this->config['charset'];
            $this->mail->Encoding   = "base64";
            $this->mail->SMTPAuth = true;
            $this->mail->isSMTP();
            $this->mail->Timeout = 10;
            $this->mail->SMTPAutoTLS = false;
            $this->mail->Host       = $this->config['smtp_server'];
            $this->mail->Username   = $this->config['smtp_user'];
            $this->mail->Password   = $this->config['smtp_pass'];
            $this->mail->SMTPSecure = $this->config['smtp_secure'];
            $this->mail->Port       = $this->config['smtp_port'];

            if ($this->mail->SMTPSecure == 'ssl') {
                $this->mail->SMTPOptions = array("ssl" => array("verify_peer" => false, "verify_peer_name" => false));
            }

            if ($this->mail->SMTPSecure == 'tls') {
                $this->mail->SMTPOptions = array("tls" => array("verify_peer" => false, "verify_peer_name" => false));
            }
            if( $this->config['smtp_user'] ) {
                $this->mail->SMTPAuth = true;
                $this->mail->Username = $this->config['smtp_user'];
                $this->mail->Password = $this->config['smtp_pass'];
            }

            if( $this->config['smtp_mail'] ) {
                $this->mail->From = $this->config['smtp_mail'];
                $this->mail->Sender = $this->config['smtp_mail'];
            }
            $this->mail->XMailer = "Life Style CMS";

//        } else {
//            $this->mail->SMTPAuth = true;
//            $this->mail->SMTPAutoTLS = false;
//            $this->mail->SMTPSecure = false;
//            $this->mail->Host = $this->config['smtp_server'];
//            $this->mail->Port = 25;
//            $this->mail->IsHTML(true);
//            $this->mail->Username = "";
//            $this->mail->Password = "";
//        }
    }

//    /**
//     * Права доступа
//     */
//    public function permission_manager()
//    {
//        if (!in_array($this->manager->accessLevel, array('administrator', 'developer')) || !in_array('feedback', $this->manager->permissions)) App::redirect('access.php');
//    }




    /**
     * @param $id
     * @return array|null
     * @throws Exception
     */
    public function read_feedback($id)
    {
        if ($feedback = DB::init()->connect()->table('feedback')->where('id', '=', $id)->get()) {
            $feedback->created = langDate(adjustTime($feedback->created, false, 'F j, Y H:i'));
            $feedback->user_lt = mb_strtoupper(mb_substr(preg_replace('![^\w\d\s]*!u','',$feedback->user_name), 0, 2));
            $feedback->bgcolor = $this->colours[array_rand($this->colours)];

            if ($feedback->state !== self::STATE_SENT) $this->update_feedback_state($id, self::STATE_READ);

            return $feedback;
        }

        return null;
    }

    /**
     * @param $id
     * @param $reply
     * @throws Exception
     */
    public function reply_to_feedback($id, $reply)
    {

        if ($feedback = DB::init()->connect()->table('feedback')->where('id', '=', $id)->get()) {
            if (!empty($feedback->email)) {
                DB::init()->connect()->table('feedback')->where('id', '=', $feedback->id)->update(['reply' => $reply, 'state' => 3]);
                $this->send_message($feedback->email, $feedback->subject, $reply);
            }
        }
    }

    /**
     * @param $feedback
     * @param $file
     * @return bool
     * @throws Exception
     */
    public function compose_feedback($feedback, $file = null)
    {
        $feedback->state   = self::STATE_SENT;
        $feedback->created = gmdate('Y-m-d H:i:s');
        $this->send_message($feedback->to, $feedback->subject, $feedback->message, $file);
        $feedback = (array) $feedback;

        unset($feedback['to']);

        if ($feedbackId = DB::init()->connect()->table('feedback')->insert($feedback)) return true;

        return false;
    }

    /**
     * @param $id
     * @param $state
     * @throws Exception
     */
    public function update_feedback_state($id, $state)
    {
        if (is_array($id)) {
            DB::init()->connect()->where('id', $id, 'IN');
        } else {
            DB::init()->connect()->where('id', $id);
        }
        DB::init()->connect()->table('feedback')->update($state);

    }


//    public function share_feedback($id)
//    {
//        if ($feedback = $this->dbQuery()->where('id', $id)->objectBuilder()->DB_ARRAY('feedback')) {
//            if (!empty($feedback->email)) {
//                $this->send_message($feedback->email, $feedback->subject, $feedback->message);
//            }
//        }
//    }

    public function delete_feedback($Ids)
    {
        if (is_array($Ids)) {
            DB::init()->connect()->in('id', $Ids);
        } else {
            DB::init()->connect()->where('id', $Ids);
        }
        DB::init()->connect()->table('feedback')->delete();

    }

    /**
     * Получение всех писем
     *
     * @param string|null $query (optional)
     * @param string|null $status (optional)
     * @param int $page
     * @param int $limit
     * @param null $columnSortOrder (optional)
     * @param null $columnName (optional)
     */
    public function getAll(?string $query, ?string $status, int $page, int $limit, $columnSortOrder = null, $columnName = null) : void
    {
        $columnIndex = $columnSortOrder[0]['column'];
//print_r($columnSortOrder);
        if ($columnSortOrder) {
            $orderBy = $columnName[$columnIndex]['data'] . " " . strtoupper($columnSortOrder[0]['dir']);
        } else {
            $orderBy = 'created DESC';
        }

        if (!empty($query)) DB::init()->connect()->like('CONCAT_WS(fullName, email, phone)', "%$query%");
        if (!empty($status)) DB::init()->connect()->where('status', $status);

        $this->mails = DB::init()->connect()->table(self::$_table)->select('*')->limit($page, $limit)->orderBy($orderBy)->getAll();

        foreach ($this->mails as $mailId => $mail) {
            $this->mails[$mailId]->created =  langDate(adjustTime($mail->created, false, 'd.m.Y H:i'));
//            $this->mails[$mailId]->statusName = lang('comments:statuses:'.$mail->status);
//            $this->mails[$mailId]->created = langDate(date('d.m.Y H:i', strtotime($mail->created)));
        }
    }

    /**
     * получение кол-во пользователей
     *
     * @param string|null $query
     * @param string|null $status
     */
    public function total(?string $query, ?string $status) : void
    {
        if (!empty($query)) {
            DB::init()->connect()->like('email', "%$query%")->orLike('fullName', "%$query%")->orLike('phone', "%$query%");
        }
        if (!empty($status)) DB::init()->connect()->where('status', '=', $status);

        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    /**
     * Получить кол-во пользователей при фильтрации
     *
     * @param string|null $query
     */
    public function countTableFiltered(?string $query) : void
    {
        if (!empty($query)) DB::init()->connect()->like('email', "%$query%")->orLike('fullName', "%$query%")->orLike('phone', "%$query%");

        $this->totalFiltered = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    /**
     * Редактирование пользователя
     *
     * @param int $mailId
     */
    public function readMail(int $mailId)
    {
        if (!empty($mailId)) {
            $this->mail = DB::init()->connect()->table(self::$_table)->where('id', $mailId)->get();
        }
    }

    public function remove(int $mailId): bool
    {
        if (!empty($mailId)) {
            if (DB::init()->connect()->table(self::$_table)->where('id', $mailId)->delete()) return true;

            return false;
        }
    }


    /**
     * @param $type
     * @param $date
     * @param $page
     * @param $itemsPerPage
     * @return array|false|mixed|string
     */
    public function getAllFeedback($type = '', $date = '', $page, $limit)
    {
//        if (!empty($type)) {
//            if ($type === 'starred')    DB::init()->connect()->where('state', self::STATE_STARRED);
//            if ($type === 'sent')       DB::init()->connect()->where('state', self::STATE_SENT);
//            if ($type === 'important')  DB::init()->connect()->where('state', self::STATE_IMPORTANT);
//            if ($type === 'spam')       DB::init()->connect()->where('state', self::STATE_SPAM);
//            if ($type === 'deleted')    DB::init()->connect()->where('state', self::STATE_DELETED);
//        } else {
//            DB::init()->connect()->where('state', '<>',self::STATE_SENT)->where('state', '<>',self::STATE_SPAM)->where('state', '<>',self::STATE_DELETED);
//        }

//        if (!empty($date)) DB::init()->connect()->like('created', '%'.$date.'%');


        $feedback = DB::init()->connect()->table('feedback')->orderBy('created', 'DESC')->pagination($limit, $page)->getAll();

//        foreach ($feedback as $item) {
            // $item->created = adjustTime($item->created, false, 'd.m.Y H:i');
//            $item->created = langDate(adjustTime($item->created, false, 'F j'));
//            $item->user_lt = mb_strtoupper(mb_substr(preg_replace('![^\w\d\s]*!u','',$item->user_name), 0, 2));
//            $item->bgcolor = $this->colours[array_rand($this->colours)];

//        }

        return $feedback;
    }

    public function totalCount($type = '', $date = null)
    {
//        if (!empty($type)) {
//            if ($type === 'starred')    DB::init()->connect()->where('state', self::STATE_STARRED);
//            if ($type === 'sent')       DB::init()->connect()->where('state', self::STATE_SENT);
//            if ($type === 'important')  DB::init()->connect()->where('state', self::STATE_IMPORTANT);
//            if ($type === 'spam')       DB::init()->connect()->where('state', self::STATE_SPAM);
//            if ($type === 'deleted')    DB::init()->connect()->where('state', self::STATE_DELETED);
//        } else {
//            DB::init()->connect()->where('state', '<>',self::STATE_SENT)->where('state', '<>',self::STATE_SPAM)->where('state', '<>',self::STATE_DELETED);
//        }
//        if (!empty($date)) DB::init()->connect()->like('created', '%'.$date.'%');

        return DB::init()->connect()->table('feedback')->count('*', 'count')->getValue();


    }

    /**
     * Получить кол-во новых
     * @return int|mixed
     * @throws Exception
     */
    public function get_new_feedback()
    {

        if ($feedbackCount = DB::init()->connect()->table('feedback')->where('state', '=', self::STATE_CREATED)->count('*')->getValue()) {
            return $feedbackCount;
        }

        return 0;
    }

    /**
     * Получить кол-во помеченных
     * @return int|mixed
     * @throws Exception
     */
    public function get_starred_feedback()
    {
        if ($feedbackCount = DB::init()->connect()->table('feedback')->where('state', '=', self::STATE_STARRED)->count('*')->getValue()) {
            return $feedbackCount;
        }

        return 0;
    }


    /**
     * Получить кол-во в spam
     * @return int|mixed
     * @throws Exception
     */
    public function get_spam_feedback()
    {

        if ($feedbackCount = DB::init()->connect()->table('feedback')->where('state', '=', self::STATE_SPAM)->count('*')->getValue()) {
            return $feedbackCount;
        }

        return 0;
    }

    /**
     * Получить кол-во удаленных
     * @return int|mixed
     * @throws Exception
     */
    public function get_deleted_feedback()
    {

        if ($feedbackCount = DB::init()->connect()->table('feedback')->where('state', '=', self::STATE_DELETED)->count('*')->getValue()) {
            return $feedbackCount;
        }

        return 0;
    }

    /**
     * Отправить сообщение
     * @param $email
     * @param $subject
     * @param $message
     * @param $file
     * @return bool|string
     * @throws \PHPMailer\PHPMailer\Exception
     */
    public function send_message($email, $subject, $message, $file = null)
    {
        if (!empty($file)) {
            if ($file['error'] == UPLOAD_ERR_OK){
                $this->mail->AddAttachment($file['tmp_name'], $file['name']);
            }
        }

        $this->mail->setFrom($this->config['smtp_user'], $this->config['website_name']);
        $email = explode(',', $email);
//        if (count($this->bcc)) {
//            foreach($this->bcc as $bcc) {
//                $this->mail->addBCC($bcc);
//            }
//        }
        foreach ($email as $item) {
            $this->mail->addBCC($item, $this->config['website_name']);
//            $this->mail->addAddress($item, $this->config['website_name']);
        }
        $this->mail->addReplyTo($this->config['smtp_user'], $this->config['website_name']);
        $this->mail->isHTML(true);
        $this->mail->Subject = $subject;
        $this->mail->Body    = $message;

        if (!$this->mail->send()) {
            return $this->mail->ErrorInfo;
        } else {
            return true;
        }
    }

}