<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Maps
 * @package Mnv\Models
 */
class Maps extends Mnv
{

    private static $_table = 'maps';

    public $map;

    /**
     * MapsAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return object
     */
    public function getMaps(): void
    {
        $this->map = DB::init()->connect()->table(self::$_table)->select('codename, value')->indexKey('codename')->valueKey('value')->getAllIndexes();
    }

    /**
     * @param $map
     * @return bool
     */
    public function save($map): bool
    {
        foreach ($map as $codename => $value) {
            $data = [
                'codename'  => $codename,
                'value'     => $value,
            ];

            DB::init()->connect()->table( self::$_table)->replace($data);
        }
        return true;
    }



}