<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Payments
 * @package Mnv\Models
 */
class Payments extends Mnv
{

    public $paymentId;
    public $payment;
    public $payments;

    public $total;
    public $result;


    /**
     * Payments constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Все платежные системы
     *
     * @return array|false|mixed|string
     */
    public function getAllPayments()
    {
        $this->payments = DB::init()->connect()->table('shop_payments')->orderBy('paymentId', 'ASC')->limit(30)->getAll();
        foreach ($this->payments as &$payment) {
            $payment->statusName = lang('general:statuses:'.$payment->status);
        }
    }

    /**
     * Кол-во платежных систем
     *
     * @return mixed|string|null
     */
    public function countPayments()
    {
        $this->total = DB::init()->connect()->table('shop_payments')->count('*', 'count')->getValue();
    }

    /**
     * Редактирование платежной системы
     *
     * @return mixed|null
     */
    public function editPayment()
    {
        if (!empty($this->paymentId)) {
            if ($this->payment = DB::init()->connect()->table('shop_payments')->where('paymentId', $this->paymentId)->get()) {
                if (isset($this->payment->settings) && !empty($this->payment->settings)) $this->payment->settings = json_decode($this->payment->settings);
                /* получать информацию о пользователях, которые создали и изменили */
                return $this->get_manager_info($this->payment);
            }
        }

        return null;
    }


    /**
     * Проверка на совпадение и получение fileName
     *
     * @param string|null $fileName
     * @return mixed|string|null
     */
    public function fileNameExist(?string $fileName)
    {
        if (empty($this->paymentId)) {
            if ($fileName = DB::init()->connect()->table('shop_payments')->select('fileName')->where('LOWER(fileName)', '=', strtolower($fileName))->getValue()) return $fileName;
        } else {
            if ($fileName = DB::init()->connect()->table('shop_payments')->select('fileName')->where('LOWER(fileName)', '=', strtolower($fileName))->where('paymentId','<>', $this->paymentId)->getValue()) return $fileName;
        }

        return null;
    }

    /**
     * Добавление в базу новой платежной системы
     *
     * @param $payment
     * @param $manager
     * @return bool
     */
    public function add($payment, $manager): bool
    {
        $payment->addedBy      = $manager->userId;
        $payment->addedOn      = gmdate('Y-m-d H:i:s');
        $payment->modifiedBy   = $manager->userId;
        $payment->modifiedOn   = gmdate('Y-m-d H:i:s');

        if ($this->paymentId = DB::init()->connect()->table('shop_payments')->insert((array)$payment)) return true;

        return false;
    }

    /**
     * Обновление платежной системы
     *
     * @param $payment
     * @param $manager
     * @return bool
     */
    public function update($payment, $manager): bool
    {
        unset($payment->addedBy);
        unset($payment->addedOn);

        $payment->modifiedBy   = $manager->userId;
        $payment->modifiedOn   = gmdate('Y-m-d H:i:s');

        if (DB::init()->connect()->table('shop_payments')->where('paymentId', $this->paymentId)->update((array)$payment)) {
            $this->editPayment();
            return  true;
        }

        return false;
    }


    /**
     * Проверка на существование платежной системы
     *
     * @param $paymentId
     * @return array|false|mixed|string
     */
    public function oldPayment($paymentId)
    {
        if ($payments = DB::init()->connect()->table('shop_payments')->where('paymentId','=', $paymentId)->getAll()) return $payments;
        return false;
    }


    /**
     * Удаление платежной системы
     *
     * @return bool
     */
    public function deletePayment(): bool
    {
        if (DB::init()->connect()->table('shop_payments')->where('paymentId', $this->paymentId)->delete()) return true;

        return false;
    }

    public function statusPayment(): array
    {
        if ($payment = DB::init()->connect()->table('shop_payments')->where('paymentId', $this->paymentId)->get()) {
            $paymentUpdate['status'] = ($payment->status == 'visible') ? 'hidden' : 'visible';
            DB::init()->connect()->table('shop_payments')->where('paymentId',$this->paymentId)->update($paymentUpdate);
            $this->result = array('data' => true, 'status' => $paymentUpdate['status']);
        }
        $this->result = array('data' => false);
    }


    /**
     * получать информацию о пользователях, которые создали и изменили статью
     *
     * @param $payment
     * @return mixed
     */
    public function get_manager_info($payment)
    {
        $managers = DB::init()->connect()->table('users')->in('userId', [$payment->addedBy, $payment->modifiedBy])->indexKey('userId')->getAllIndexes();
        $payment->addedBy    = empty($managers[$payment->addedBy]) ? unknownUser() : $managers[$payment->addedBy];
        $payment->modifiedBy = empty($managers[$payment->modifiedBy]) ? unknownUser() : $managers[$payment->modifiedBy];
        $payment->addedOn    = langDate(adjustTime($payment->addedOn, false, 'd.m.Y H:i'));
        $payment->modifiedOn = langDate(adjustTime($payment->modifiedOn, false, 'd.m.Y H:i'));



        return $payment;
    }


    public function getPaymentModules()
    {
        $modulesDir = GLOBAL_ROOT.'/app/Modules/Payment/';

        $modules = array();
        $handler = opendir($modulesDir);
        while ($dir = readdir($handler))
        {
            $dir = preg_replace("/[^A-Za-z0-9]+/", "", $dir);
            if (!empty($dir) && $dir != "." && $dir != ".." && is_dir($modulesDir.$dir)) {

                if(is_readable($modulesDir . $dir .'/settings.xml') && $xml = simplexml_load_file($modulesDir . $dir . '/settings.xml'))
                {
                    $module = new \stdClass;

                    $module->name = (string)$xml->name;
                    $module->settings = array();

                    foreach($xml->settings as $setting) {
                        $module->settings[(string)$setting->variable] = new \stdClass;
                        $module->settings[(string)$setting->variable]->name = (string)$setting->name;
                        $module->settings[(string)$setting->variable]->variable = (string)$setting->variable;
                        $module->settings[(string)$setting->variable]->variable_options = array();
                        foreach($setting->options as $option) {
                            $module->settings[(string)$setting->variable]->options[(string)$option->value] = new \stdClass;
                            $module->settings[(string)$setting->variable]->options[(string)$option->value]->name = (string)$option->name;
                            $module->settings[(string)$setting->variable]->options[(string)$option->value]->value = (string)$option->value;
                        }
                    }
                    $modules[$dir] = $module;
                }

            }
        }
        closedir($handler);
        return $modules;

    }
}